/*
 * Decompiled with CFR 0.152.
 */
package shadows.compatched.tileentity;

import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import shadows.compatched.CompactRegistry;
import shadows.compatched.inventory.ContainerChest;
import shadows.compatched.inventory.IChest;
import shadows.compatched.inventory.InfoItemHandler;
import shadows.compatched.util.StorageInfo;
import shadows.placebo.recipe.VanillaPacketDispatcher;

public class TileEntityChest
extends TileEntity
implements IChest,
ITickableTileEntity,
INamedContainerProvider {
    private Color color = Color.WHITE;
    protected StorageInfo info;
    protected boolean retaining = false;
    private float lidAngle = 0.0f;
    private float prevLidAngle = 0.0f;
    protected int numPlayersUsing = 0;
    protected int ticksSinceSync = 0;
    private InfoItemHandler items;
    LazyOptional<IItemHandler> itemOpt = LazyOptional.of(() -> this.items);

    public TileEntityChest(StorageInfo info) {
        super(CompactRegistry.CHEST_TILE);
        this.info = info;
        this.items = new InfoItemHandler(info);
    }

    public TileEntityChest() {
        this(new StorageInfo(9, 3, 180, StorageInfo.Type.CHEST));
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.numPlayersUsing = type;
            return true;
        }
        return super.func_145842_c(id, type);
    }

    @Override
    public void onOpened(PlayerEntity player) {
        if (!player.func_175149_v()) {
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            ++this.numPlayersUsing;
            this.field_145850_b.func_175641_c(this.field_174879_c, (Block)CompactRegistry.CHEST, 1, this.numPlayersUsing);
            this.field_145850_b.func_195593_d(this.field_174879_c, (Block)CompactRegistry.CHEST);
        }
    }

    @Override
    public void onClosed(PlayerEntity player) {
        if (!player.func_175149_v()) {
            --this.numPlayersUsing;
            this.field_145850_b.func_175641_c(this.field_174879_c, (Block)CompactRegistry.CHEST, 1, this.numPlayersUsing);
            this.field_145850_b.func_195593_d(this.field_174879_c, (Block)CompactRegistry.CHEST);
        }
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_218657_a("info", (INBT)this.info.serialize());
        tag.func_74757_a("retaining", this.retaining);
        tag.func_218657_a("items", (INBT)this.getItems().serializeNBT());
        return tag;
    }

    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        this.retaining = tag.func_74767_n("retaining");
        this.info.deserialize(tag.func_74775_l("info"));
        this.getItems().deserializeNBT(tag.func_74775_l("items"));
        this.color = this.getHue() == -1 ? Color.white : Color.getHSBColor((float)this.info.getHue() / 360.0f, 0.5f, 0.5f);
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = super.func_189517_E_();
        tag.func_218657_a("info", (INBT)this.info.serialize());
        tag.func_74757_a("retaining", this.retaining);
        return tag;
    }

    public void handleUpdateTag(CompoundNBT tag) {
        this.retaining = tag.func_74767_n("retaining");
        this.info.deserialize(tag.func_74775_l("info"));
        this.getItems().setSize(this.info.getSizeX() * this.info.getSizeY());
        this.color = this.getHue() == -1 ? Color.white : Color.getHSBColor((float)this.info.getHue() / 360.0f, 0.5f, 0.5f);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, -1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public void updateBlock() {
        this.func_70296_d();
    }

    public void func_73660_a() {
        int i = this.field_174879_c.func_177958_n();
        int j = this.field_174879_c.func_177956_o();
        int k = this.field_174879_c.func_177952_p();
        ++this.ticksSinceSync;
        if (!this.field_145850_b.field_72995_K && this.numPlayersUsing != 0 && (this.ticksSinceSync + i + j + k) % 200 == 0) {
            this.numPlayersUsing = 0;
            for (PlayerEntity player : this.field_145850_b.func_217357_a(PlayerEntity.class, new AxisAlignedBB((double)((float)i - 5.0f), (double)((float)j - 5.0f), (double)((float)k - 5.0f), (double)((float)(i + 1) + 5.0f), (double)((float)(j + 1) + 5.0f), (double)((float)(k + 1) + 5.0f)))) {
                IChest iinventory;
                if (!(player.field_71070_bA instanceof ContainerChest) || (iinventory = ((ContainerChest)player.field_71070_bA).chest) != this) continue;
                ++this.numPlayersUsing;
            }
        }
        this.setPrevLidAngle(this.getLidAngle());
        if (this.numPlayersUsing > 0 && this.getLidAngle() == 0.0f) {
            double d1 = (double)i + 0.5;
            double d2 = (double)k + 0.5;
            this.field_145850_b.func_184148_a(null, d1, (double)j + 0.5, d2, SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numPlayersUsing == 0 && this.getLidAngle() > 0.0f || this.numPlayersUsing > 0 && this.getLidAngle() < 1.0f) {
            float f2 = this.getLidAngle();
            if (this.numPlayersUsing > 0) {
                this.setLidAngle(this.getLidAngle() + 0.1f);
            } else {
                this.setLidAngle(this.getLidAngle() - 0.1f);
            }
            if (this.getLidAngle() > 1.0f) {
                this.setLidAngle(1.0f);
            }
            if (this.getLidAngle() < 0.5f && f2 >= 0.5f) {
                double d3 = (double)i + 0.5;
                double d0 = (double)k + 0.5;
                this.field_145850_b.func_184148_a(null, d3, (double)j + 0.5, d0, SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.getLidAngle() < 0.0f) {
                this.setLidAngle(0.0f);
            }
        }
    }

    @Override
    public int getInvX() {
        return this.info.getSizeX();
    }

    @Override
    public int getInvY() {
        return this.info.getSizeY();
    }

    @Override
    public StorageInfo getInfo() {
        return this.info;
    }

    @Override
    public int getHue() {
        return this.info.getHue();
    }

    @Override
    public void setHue(int hue) {
        this.info.setHue(hue);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemOpt.cast();
        }
        return super.getCapability(cap, side);
    }

    public Color getColor() {
        return this.color;
    }

    @Override
    public ItemStackHandler getItems() {
        return this.items;
    }

    public boolean isRetaining() {
        return this.retaining;
    }

    public void setRetaining(boolean retain) {
        this.retaining = retain;
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers((TileEntity)this);
    }

    public Direction getDirection() {
        return (Direction)this.func_195044_w().func_177229_b((IProperty)HorizontalBlock.field_185512_D);
    }

    public float getLidAngle() {
        return this.lidAngle;
    }

    public void setLidAngle(float lidAngle) {
        this.lidAngle = lidAngle;
    }

    public float getPrevLidAngle() {
        return this.prevLidAngle;
    }

    public void setPrevLidAngle(float prevLidAngle) {
        this.prevLidAngle = prevLidAngle;
    }

    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new ContainerChest(id, this.field_145850_b, this, player, this.field_174879_c);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(CompactRegistry.CHEST.func_149739_a(), new Object[0]);
    }
}

