/*
 * Decompiled with CFR 0.152.
 */
package shadows.compatched.tileentity;

import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import shadows.compatched.CompactRegistry;
import shadows.compatched.inventory.ContainerChestBuilder;
import shadows.compatched.util.StorageInfo;

public class TileEntityChestBuilder
extends TileEntity
implements INamedContainerProvider {
    protected StorageInfo info = new StorageInfo(9, 3, 180, StorageInfo.Type.CHEST);
    protected ItemHandler items = new ItemHandler(5);
    LazyOptional<IItemHandler> itemOpt = LazyOptional.of(() -> this.items);

    public TileEntityChestBuilder() {
        super(CompactRegistry.BUILDER_TILE);
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_218657_a("info", (INBT)this.info.serialize());
        tag.func_218657_a("items", (INBT)this.items.serializeNBT());
        return tag;
    }

    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        this.info.deserialize(tag.func_74775_l("info"));
        this.items.deserializeNBT(tag.func_74775_l("items"));
    }

    public StorageInfo getInfo() {
        return this.info;
    }

    public ItemHandler getItems() {
        return this.items;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemOpt.cast();
        }
        return super.getCapability(cap, side);
    }

    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new ContainerChestBuilder(id, this.field_145850_b, player, this);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(CompactRegistry.CHEST_BUILDER.func_149739_a(), new Object[0]);
    }

    public class ItemHandler
    extends ItemStackHandler {
        public ItemHandler(int size) {
            super(size);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (TileEntityChestBuilder.this.info == null) {
                return false;
            }
            List<ItemStack> cost = TileEntityChestBuilder.this.info.getMaterialCost();
            return cost.size() > slot && stack.func_77973_b() == cost.get(slot).func_77973_b();
        }
    }
}

