/*
 * Decompiled with CFR 0.152.
 */
package com.cameron.crossbowmod.items.BaseClasses;

import com.cameron.crossbowmod.CrossbowModMain;
import com.cameron.crossbowmod.Reference;
import com.cameron.crossbowmod.enums.Bolts;
import com.cameron.crossbowmod.enums.Materials;
import com.cameron.crossbowmod.enums.Upgrades;
import com.cameron.crossbowmod.items.BaseClasses.EntityBolt;
import com.cameron.crossbowmod.items.BaseClasses.ItemBolt;
import com.cameron.crossbowmod.items.BaseClasses.ItemUpgrade;
import com.cameron.crossbowmod.items.entity.EntityDiamondBolt;
import com.cameron.crossbowmod.items.entity.EntityExplosiveBolt;
import com.cameron.crossbowmod.items.entity.EntityFlameBolt;
import com.cameron.crossbowmod.items.entity.EntityFreezeBolt;
import com.cameron.crossbowmod.items.entity.EntityGoldBolt;
import com.cameron.crossbowmod.items.entity.EntityIronBolt;
import com.cameron.crossbowmod.items.entity.EntitySpectralBolt;
import com.cameron.crossbowmod.items.entity.EntityStoneBolt;
import com.cameron.crossbowmod.items.entity.EntityTeleportBolt;
import com.cameron.crossbowmod.items.entity.EntityTorchBolt;
import com.cameron.crossbowmod.items.entity.EntityWoodBolt;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCrossbow
extends Item {
    final Materials material;
    float multiplier;
    Bolts bolt;
    boolean fromStorage;
    int slot;
    public ArrayList<Upgrades> upgrades = new ArrayList();

    public ItemCrossbow(String name, final Materials material, final float multiplier) {
        this.material = material;
        this.bolt = material.bolt;
        this.field_77777_bU = 1;
        this.func_77655_b(name);
        this.setRegistryName(name);
        this.func_77656_e((int)((float)material.durability * multiplier));
        this.func_77637_a(Reference.tabCustom);
        this.fromStorage = false;
        this.slot = 0;
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return entityIn == null ? 0.0f : (entityIn.func_184607_cu().func_77973_b() instanceof ItemCrossbow && !((ItemCrossbow)entityIn.func_184607_cu().func_77973_b()).upgrades.contains((Object)Upgrades.AUTO_RELOAD) ? (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / (material.drawbackSpeed * multiplier) : 0.0f);
            }
        });
        this.func_185043_a(new ResourceLocation("pulling"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        super.onEntitySwing(entityLiving, stack);
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            if (!player.field_70170_p.field_72995_K) {
                int guiId = 0;
                switch (this.material) {
                    case DIAMOND: {
                        guiId = 1;
                        break;
                    }
                    case GOLD: {
                        guiId = 2;
                        break;
                    }
                    case IRON: {
                        guiId = 2;
                        break;
                    }
                    case STONE: {
                        guiId = 3;
                        break;
                    }
                    case WOOD: {
                        guiId = 3;
                        break;
                    }
                }
                player.openGui((Object)CrossbowModMain.instance, guiId, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            }
            return false;
        }
        return true;
    }

    private ItemStack findAmmo(EntityPlayer player) {
        if (this.isBolt(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.isBolt(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (itemstack == null) continue;
            if (itemstack.func_77973_b() instanceof ItemCrossbow) {
                int invSize = 0;
                switch (this.material) {
                    case DIAMOND: {
                        invSize = 8;
                        break;
                    }
                    case GOLD: {
                        invSize = 4;
                        break;
                    }
                    case IRON: {
                        invSize = 4;
                        break;
                    }
                    case STONE: {
                        invSize = 2;
                        break;
                    }
                    case WOOD: {
                        invSize = 2;
                        break;
                    }
                }
                for (int j = 0; j < invSize; ++j) {
                    ItemStack temp = ((ItemCrossbow)itemstack.func_77973_b()).readFromNBT(itemstack.func_77978_p(), j);
                    if (!this.isBolt(temp)) continue;
                    this.fromStorage = true;
                    this.slot = j;
                    return temp;
                }
            }
            this.fromStorage = false;
            if (!this.isBolt(itemstack)) continue;
            return itemstack;
        }
        return null;
    }

    protected boolean isBolt(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.func_77973_b() instanceof ItemBolt) {
            this.bolt = ((ItemBolt)stack.func_77973_b()).getBolt();
            return this.bolt.tier <= this.material.tier;
        }
        return false;
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entityLiving;
            boolean flag = entityplayer.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
            ItemStack itemstack = this.findAmmo(entityplayer);
            if (this.upgrades.contains((Object)Upgrades.AUTO_RELOAD)) {
                return;
            }
            int i = this.func_77626_a(stack) - timeLeft;
            if (itemstack != null) {
                if ((i = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)worldIn, (EntityPlayer)entityplayer, (int)i, (itemstack.field_77994_a != 0 || flag ? 1 : 0) != 0)) < 0) {
                    return;
                }
                if (itemstack.field_77994_a == 0 || flag) {
                    itemstack = new ItemStack(this.material.bolt.bolt);
                }
            }
            this.fireBolt(stack, worldIn, entityplayer, i);
        }
    }

    public float getBoltVelocity(int charge) {
        float f = (float)charge / (this.material.drawbackSpeed * this.multiplier);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public int func_77626_a(ItemStack stack) {
        return this.upgrades.contains((Object)Upgrades.AUTO_RELOAD) ? 0 : 72000;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return this.upgrades.contains((Object)Upgrades.AUTO_RELOAD) ? EnumAction.NONE : EnumAction.BOW;
    }

    public EntityBolt selectBolt(World worldIn, EntityPlayer entityplayer) {
        switch (this.bolt) {
            case WOOD: {
                return new EntityWoodBolt(worldIn, (EntityLivingBase)entityplayer, this.bolt);
            }
            case STONE: {
                return new EntityStoneBolt(worldIn, (EntityLivingBase)entityplayer, this.bolt);
            }
            case IRON: {
                return new EntityIronBolt(worldIn, (EntityLivingBase)entityplayer, this.bolt);
            }
            case GOLD: {
                return new EntityGoldBolt(worldIn, (EntityLivingBase)entityplayer, this.bolt);
            }
            case DIAMOND: {
                return new EntityDiamondBolt(worldIn, (EntityLivingBase)entityplayer, this.bolt);
            }
            case EXPLOSIVE: {
                return new EntityExplosiveBolt(worldIn, (EntityLivingBase)entityplayer, this.bolt);
            }
            case FLAME: {
                return new EntityFlameBolt(worldIn, (EntityLivingBase)entityplayer, this.bolt);
            }
            case TELEPORT: {
                return new EntityTeleportBolt(worldIn, (EntityLivingBase)entityplayer, this.bolt);
            }
            case TORCH: {
                return new EntityTorchBolt(worldIn, (EntityLivingBase)entityplayer, this.bolt);
            }
            case FREEZE: {
                return new EntityFreezeBolt(worldIn, (EntityLivingBase)entityplayer, this.bolt);
            }
            case SPECTRAL: {
                return new EntitySpectralBolt(worldIn, (EntityLivingBase)entityplayer, this.bolt);
            }
        }
        return new EntityBolt(worldIn, (EntityLivingBase)entityplayer, this.bolt);
    }

    public void fireBolt(ItemStack stack, World worldIn, EntityPlayer entityplayer, int i) {
        float boltSpeed;
        ItemStack itemstack = this.findAmmo(entityplayer);
        if (this.fromStorage) {
            ((ItemCrossbow)stack.func_77973_b()).writeToNBT(stack.func_77978_p(), this.slot);
        }
        if ((double)(boltSpeed = this.getBoltVelocity(i)) >= 0.1) {
            boolean flag1;
            boolean bl = flag1 = entityplayer.field_71075_bZ.field_75098_d || itemstack.func_77973_b() instanceof ItemBolt && ((ItemBolt)itemstack.func_77973_b()).isInfinite(itemstack, stack, entityplayer);
            if (!worldIn.field_72995_K) {
                int k;
                EntityBolt entityBolt = this.selectBolt(worldIn, entityplayer);
                int j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack);
                if (j > 0) {
                    entityBolt.func_70239_b(entityBolt.func_70242_d() + (double)j * 0.5 + 0.5);
                }
                if ((k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack)) > 0) {
                    entityBolt.func_70240_a(k);
                }
                if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0 || this.bolt == Bolts.FLAME) {
                    entityBolt.func_70015_d(100);
                }
                if (!this.upgrades.contains((Object)Upgrades.REINFORCED_LIMBS)) {
                    stack.func_77972_a(1, (EntityLivingBase)entityplayer);
                }
                if (flag1 || entityplayer.field_71075_bZ.field_75098_d) {
                    entityBolt.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                }
                if (this.upgrades.contains((Object)Upgrades.TRI_SHOT)) {
                    entityBolt.func_184547_a((Entity)entityplayer, entityplayer.field_70125_A, entityplayer.field_70177_z, 0.0f, boltSpeed * this.material.strength, 1.0f);
                    worldIn.func_72838_d((Entity)entityBolt);
                    entityBolt.field_70251_a = EntityArrow.PickupStatus.DISALLOWED;
                    entityBolt = this.selectBolt(worldIn, entityplayer);
                    entityBolt.func_184547_a((Entity)entityplayer, entityplayer.field_70125_A, entityplayer.field_70177_z - 7.0f, 0.0f, boltSpeed * this.material.strength, 1.0f);
                    worldIn.func_72838_d((Entity)entityBolt);
                    entityBolt.field_70251_a = EntityArrow.PickupStatus.DISALLOWED;
                    entityBolt = this.selectBolt(worldIn, entityplayer);
                    entityBolt.func_184547_a((Entity)entityplayer, entityplayer.field_70125_A, entityplayer.field_70177_z + 7.0f, 0.0f, boltSpeed * this.material.strength, 1.0f);
                    worldIn.func_72838_d((Entity)entityBolt);
                } else {
                    entityBolt.func_184547_a((Entity)entityplayer, entityplayer.field_70125_A, entityplayer.field_70177_z, 0.0f, boltSpeed * this.material.strength, 1.0f);
                    worldIn.func_72838_d((Entity)entityBolt);
                }
            }
            worldIn.func_184148_a((EntityPlayer)null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + boltSpeed * 0.5f);
            if (!flag1 && !entityplayer.field_71075_bZ.field_75098_d) {
                itemstack.func_77979_a(1);
                if (itemstack.field_77994_a == 0) {
                    entityplayer.field_71071_by.func_184437_d(itemstack);
                }
            }
            entityplayer.func_71029_a(StatList.func_188057_b((Item)this));
        }
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stackin, World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ActionResult ret;
        ItemStack crossbow = playerIn.func_184586_b(handIn);
        if (crossbow.func_77973_b() instanceof ItemCrossbow) {
            this.upgrades = new ArrayList();
            int invSize = 0;
            switch (this.material) {
                case DIAMOND: {
                    invSize = 8;
                    break;
                }
                case GOLD: {
                    invSize = 4;
                    break;
                }
                case IRON: {
                    invSize = 4;
                    break;
                }
            }
            for (int j = 0; j < invSize; ++j) {
                ItemStack temp = ((ItemCrossbow)crossbow.func_77973_b()).readFromNBT(crossbow.func_77978_p(), j);
                if (temp == null || !(temp.func_77973_b() instanceof ItemUpgrade)) continue;
                this.upgrades.add(((ItemUpgrade)temp.func_77973_b()).getUpgrade());
            }
        }
        boolean flag = false;
        if (this.findAmmo(playerIn) != null) {
            boolean bl = flag = this.findAmmo((EntityPlayer)playerIn).field_77994_a != 0;
        }
        if ((ret = ForgeEventFactory.onArrowNock((ItemStack)crossbow, (World)worldIn, (EntityPlayer)playerIn, (EnumHand)handIn, (boolean)flag)) != null && !this.upgrades.contains((Object)Upgrades.AUTO_RELOAD)) {
            return ret;
        }
        if (!playerIn.field_71075_bZ.field_75098_d && !flag) {
            return flag ? new ActionResult(EnumActionResult.PASS, (Object)crossbow) : new ActionResult(EnumActionResult.FAIL, (Object)crossbow);
        }
        playerIn.func_184598_c(handIn);
        if (this.upgrades.contains((Object)Upgrades.AUTO_RELOAD)) {
            this.fireBolt(crossbow, worldIn, playerIn, 72000);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)crossbow);
    }

    public int func_77619_b() {
        return 1;
    }

    public ItemStack readFromNBT(NBTTagCompound compound, int index) {
        if (compound == null) {
            return null;
        }
        NBTTagList items = compound.func_150295_c("InventoryCrossbow", 10);
        NBTTagCompound item = items.func_150305_b(index);
        return ItemStack.func_77949_a((NBTTagCompound)item);
    }

    public void writeToNBT(NBTTagCompound tagcompound, int index) {
        NBTTagList items = tagcompound.func_150295_c("InventoryCrossbow", 10);
        NBTTagCompound item = items.func_150305_b(index);
        int currentCount = item.func_74762_e("Count");
        if (currentCount == 1) {
            items.func_74744_a(index);
        } else {
            item.func_74768_a("Count", currentCount - 1);
        }
    }
}

