/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils;

import java.io.File;
import java.util.Random;
import net.darkhax.bookshelf.lib.LoggingHelper;
import net.darkhax.bookshelf.network.NetworkHandler;
import net.darkhax.bookshelf.registry.RegistryHelper;
import net.darkhax.darkutils.DarkUtilsServer;
import net.darkhax.darkutils.creativetab.CreativeTabDarkUtils;
import net.darkhax.darkutils.features.Feature;
import net.darkhax.darkutils.features.FeatureManager;
import net.darkhax.darkutils.handler.ConfigurationHandler;
import net.darkhax.darkutils.handler.GuiHandler;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;

@Mod(modid="darkutils", name="Dark Utilities", version="1.8.228", dependencies="required-after:bookshelf@[2.3.573,);after:waila;after:jei;after:baubles;", certificateFingerprint="d476d1b22b218a10d845928d1665d45fce301b27", acceptedMinecraftVersions="[1.12.2]")
public class DarkUtils {
    public static final String MOD_ID = "darkutils";
    public static final String MOD_NAME = "Dark Utilities";
    public static final String VERSION_NUMBER = "1.8.228";
    public static final String CLIENT_PROXY_CLASS = "net.darkhax.darkutils.DarkUtilsClient";
    public static final String SERVER_PROXY_CLASS = "net.darkhax.darkutils.DarkUtilsServer";
    public static final String DEPENDENCIES = "required-after:bookshelf@[2.3.573,);after:waila;after:jei;after:baubles;";
    public static final Random RANDOM = new Random();
    public static final LoggingHelper LOGGER = new LoggingHelper("Dark Utilities");
    public static final CreativeTabs TAB = new CreativeTabDarkUtils();
    public static final NetworkHandler NETWORK = new NetworkHandler("darkutils");
    public static final RegistryHelper REGISTRY = new RegistryHelper("darkutils").setTab(TAB).enableAutoRegistration();
    @SidedProxy(clientSide="net.darkhax.darkutils.DarkUtilsClient", serverSide="net.darkhax.darkutils.DarkUtilsServer")
    public static DarkUtilsServer proxy;
    @Mod.Instance(value="darkutils")
    public static DarkUtils instance;

    @Mod.EventHandler
    public void onConstruction(FMLConstructionEvent event) {
        ConfigurationHandler.initConfig(new File("config/darkutils.cfg"));
        FeatureManager.init(event.getASMHarvestedData());
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        ConfigurationHandler.syncConfigData();
        proxy.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        for (Feature feature : FeatureManager.getFeatures()) {
            feature.onPreRecipe();
        }
    }

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        LOGGER.warn("Invalid fingerprint detected! The file " + event.getSource().getName() + " may have been tampered with. This version will NOT be supported by the author!", new Object[0]);
    }
}

