/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.features.material;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.projectile.EntityWitherSkull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockWitherDust
extends Block {
    public static String[] types = new String[]{"default", "bricked", "carved", "chiseled", "magma", "tiled"};
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);

    public BlockWitherDust() {
        super(Material.field_151595_p, MapColor.field_151646_E);
        this.setHarvestLevel("pickaxe", 1);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)EnumType.DEFAULT)));
        this.func_149711_c(0.5f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185849_b);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int meta = 0; meta < types.length; ++meta) {
            list.add((Object)new ItemStack((Block)this, 1, meta));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public boolean isBeaconBase(IBlockAccess worldObj, BlockPos pos, BlockPos beacon) {
        return true;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return !(entity instanceof EntityWither) && !(entity instanceof EntityWitherSkull);
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
    }

    public boolean func_149659_a(Explosion explosion) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_185484_c(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (this.func_176201_c(state) == 4) {
            return 0xF000F0;
        }
        return super.func_185484_c(state, source, pos);
    }

    public static enum EnumType implements IStringSerializable
    {
        DEFAULT(0, "default"),
        BRICK(1, "bricked"),
        CARVED(2, "carved"),
        CHISELED(3, "chiseled"),
        MAGMA(4, "magma"),
        TILED(5, "tiled");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String toString() {
            return this.name;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType type;
                EnumType.META_LOOKUP[type.getMetadata()] = type = enumTypeArray[i];
            }
        }
    }
}

