/*
 * Decompiled with CFR 0.152.
 */
package de.pt400c.defaultsettings;

import de.pt400c.defaultsettings.DefaultSettings;
import de.pt400c.defaultsettings.FileUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import org.apache.logging.log4j.Level;

public class CommandDefaultSettings_18
extends CommandBase {
    public static final ArrayList<String> arg = new ArrayList<String>(){
        private static final long serialVersionUID = -8897230905576922296L;
        {
            this.add("save");
            this.add("export-mode");
        }
    };
    private ThreadPoolExecutor tpe = new ThreadPoolExecutor(1, 3, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());

    public String func_71517_b() {
        return "defaultsettings";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/defaultsettings [save / export-mode]";
    }

    public int func_82362_a() {
        return 0;
    }

    public List<String> func_71514_a() {
        return new ArrayList<String>(){
            private static final long serialVersionUID = -4946223027905825078L;
            {
                this.add("ds");
            }
        };
    }

    public List<String> func_180525_a(ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length < 2) {
            return CommandDefaultSettings_18.func_71530_a((String[])args, (String[])arg.toArray(new String[0]));
        }
        return new ArrayList<String>();
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
    }

    public void func_71515_b(final ICommandSender sender, String[] args) throws WrongUsageException {
        if (args.length == 0 || args.length > 2 || !arg.contains(args[0].toLowerCase())) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        if (this.tpe.getQueue().size() > 0) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Please wait until the last request has been processed!"));
            return;
        }
        if (args[0].toLowerCase().equals("save")) {
            if ((FileUtil.keysFileExist() || FileUtil.optionsFilesExist() || FileUtil.serversFileExists()) && (args.length == 1 || args.length == 2 && !args[1].equals("-o"))) {
                sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "The intended files already exist! If you want to"));
                sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "overwrite them, add the '-o' argument"));
                return;
            }
            MutableBoolean issue = new MutableBoolean(false);
            this.tpe.execute(new ThreadRunnable(sender, issue){

                @Override
                public void run() {
                    try {
                        FileUtil.saveKeys();
                        sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + "Successfully saved the key configuration"));
                        FileUtil.restoreKeys();
                    }
                    catch (Exception e) {
                        DefaultSettings.log.log(Level.ERROR, "An exception occurred while saving the key configuration:", (Throwable)e);
                        sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Couldn't save the key configuration!"));
                        this.issue.setBoolean(true);
                    }
                }
            });
            this.tpe.execute(new ThreadRunnable(sender, issue){

                @Override
                public void run() {
                    try {
                        FileUtil.saveOptions();
                        sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + "Successfully saved the default game options"));
                    }
                    catch (Exception e) {
                        DefaultSettings.log.log(Level.ERROR, "An exception occurred while saving the default game options:", (Throwable)e);
                        sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Couldn't save the default game options!"));
                        this.issue.setBoolean(true);
                    }
                }
            });
            this.tpe.execute(new ThreadRunnable(sender, issue){

                @Override
                public void run() {
                    try {
                        FileUtil.saveServers();
                        sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + "Successfully saved the server list"));
                    }
                    catch (Exception e) {
                        DefaultSettings.log.log(Level.ERROR, "An exception occurred while saving the server list:", (Throwable)e);
                        sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Couldn't save the server list!"));
                        this.issue.setBoolean(true);
                    }
                    if (this.issue.getBoolean()) {
                        sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "Please inspect the log files for further information!"));
                    }
                }
            });
        } else {
            final boolean exportMode = FileUtil.exportMode();
            this.tpe.execute(new ThreadRunnable(sender, null){

                @Override
                public void run() {
                    try {
                        if (exportMode) {
                            FileUtil.restoreConfigs();
                            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + "The export-mode has been disabled successfully"));
                        } else {
                            FileUtil.moveAllConfigs(true);
                            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + "Successfully activated the export-mode"));
                        }
                    }
                    catch (IOException e) {
                        DefaultSettings.getInstance();
                        DefaultSettings.log.log(Level.ERROR, "An exception occurred while trying to move the configs:", (Throwable)e);
                        sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Couldn't switch the export-mode"));
                    }
                }
            });
        }
    }

    private class MutableBoolean {
        private boolean bool;

        public MutableBoolean(boolean bool) {
            this.bool = bool;
        }

        public boolean getBoolean() {
            return this.bool;
        }

        public void setBoolean(boolean bool) {
            this.bool = bool;
        }
    }

    private abstract class ThreadRunnable
    implements Runnable {
        final ICommandSender supply;
        final MutableBoolean issue;

        ThreadRunnable(ICommandSender supply, MutableBoolean issue) {
            this.supply = supply;
            this.issue = issue;
        }
    }
}

