/*
 * Decompiled with CFR 0.152.
 */
package de.pt400c.defaultsettings;

import de.pt400c.defaultsettings.CommandDefaultSettings_18;
import de.pt400c.defaultsettings.CommandDefaultSettings_19;
import de.pt400c.defaultsettings.EventHandlers;
import de.pt400c.defaultsettings.FileUtil;
import de.pt400c.defaultsettings.KeyContainer;
import de.pt400c.defaultsettings.UpdateContainer;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarInputStream;
import net.minecraft.command.ICommand;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.FMLInjectionData;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="defaultsettings", acceptedMinecraftVersions="[1.8,1.12.2]", name="DefaultSettings", version="1.3.5", guiFactory="de.pt400c.defaultsettings.GuiConfigFactory", dependencies="before:*", certificateFingerprint="1945fa1cbb8ec2ffad2ccec7a0ca72ad52b20ef8", clientSideOnly=true, updateJSON="https://gist.githubusercontent.com/PT400C/be22046792a7859688f655f1a5f83975/raw/")
public class DefaultSettings {
    public static final String MODID = "defaultsettings";
    public static final String NAME = "DefaultSettings";
    public static final String VERSION = "1.3.5";
    public static final String modGuiFactory = "de.pt400c.defaultsettings.GuiConfigFactory";
    public static final Logger log = LogManager.getLogger((String)"defaultsettings");
    public static Map<String, Integer> keyRebinds_18 = new HashMap<String, Integer>();
    public static String mcVersion = FMLInjectionData.data()[4].toString();
    public static Map<String, KeyContainer> keyRebinds_19 = new HashMap<String, KeyContainer>();
    private static final UpdateContainer updateContainer = new UpdateContainer();
    public static String BUILD_ID = "<UNKNOWN>";
    public static String BUILD_TIME = "<UNKNOWN>";
    public static final boolean is180 = mcVersion.equals("1.8");
    public static final boolean is18 = mcVersion.startsWith("1.8");
    @Mod.Instance
    public static DefaultSettings instance;

    public DefaultSettings() {
        instance = this;
    }

    @Mod.EventHandler
    public static void construction(FMLConstructionEvent event) {
        try {
            FileUtil.restoreContents();
        }
        catch (Exception e) {
            log.log(Level.ERROR, "An exception occurred while starting up the game:", (Throwable)e);
        }
    }

    @Mod.EventHandler
    public static void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        if (event.isDirectory() || FileUtil.isDev) {
            return;
        }
        log.log(Level.ERROR, "The mod's files have been manipulated! The game will be terminated.");
        FMLCommonHandler.instance().exitJava(0, true);
    }

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent event) {
        if (mcVersion.startsWith("1.8")) {
            ClientCommandHandler.instance.func_71560_a((ICommand)new CommandDefaultSettings_18());
        } else {
            ClientCommandHandler.instance.func_71560_a((ICommand)new CommandDefaultSettings_19());
        }
        MinecraftForge.EVENT_BUS.register(DefaultSettings.class);
        EventHandlers handlers = new EventHandlers();
        FMLCommonHandler.instance().bus().register((Object)handlers);
        MinecraftForge.EVENT_BUS.register((Object)handlers);
    }

    @Mod.EventHandler
    public static void postInit(FMLPostInitializationEvent event) {
        try {
            DefaultSettings.getBuildID();
            DefaultSettings.getBuildTime();
        }
        catch (IOException | NullPointerException exception) {
            // empty catch block
        }
        try {
            FileUtil.restoreKeys();
        }
        catch (IOException e) {
            log.log(Level.ERROR, "An exception occurred while starting up the game (Post):", (Throwable)e);
        }
        catch (NullPointerException e) {
            log.log(Level.ERROR, "An exception occurred while starting up the game (Post):", (Throwable)e);
        }
    }

    private static void getBuildID() throws FileNotFoundException, IOException {
        ModContainer mc = FMLCommonHandler.instance().findContainerFor((Object)DefaultSettings.getInstance());
        try (JarInputStream jarStream = new JarInputStream(new FileInputStream(mc.getSource()));){
            BUILD_ID = jarStream.getManifest().getMainAttributes().getValue("Build-ID");
        }
    }

    private static void getBuildTime() throws FileNotFoundException, IOException {
        ModContainer mc = FMLCommonHandler.instance().findContainerFor((Object)DefaultSettings.getInstance());
        try (JarInputStream jarStream = new JarInputStream(new FileInputStream(mc.getSource()));){
            BUILD_TIME = jarStream.getManifest().getMainAttributes().getValue("Build-Date");
        }
    }

    public static UpdateContainer getUpdater() {
        return updateContainer;
    }

    public static DefaultSettings getInstance() {
        return instance;
    }
}

