/*
 * Decompiled with CFR 0.152.
 */
package de.pt400c.defaultsettings;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import de.pt400c.defaultsettings.DefaultSettings;
import de.pt400c.defaultsettings.GuiConfig;
import de.pt400c.defaultsettings.KeyContainer;
import de.pt400c.defaultsettings.MainJSON;
import de.pt400c.defaultsettings.PersistentJSON;
import de.pt400c.defaultsettings.gui.MenuArea;
import de.pt400c.defaultsettings.gui.ScrollableSegment;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.ResourcePackRepository;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Level;

public class FileUtil {
    public static final Minecraft MC = Minecraft.func_71410_x();
    public static final File mcDataDir = FileUtil.MC.field_71412_D;
    public static final boolean isDev = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
    public static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public static MainJSON mainJson;
    public static PersistentJSON persistentJson;
    public static final String persistentLocation = "config/ds_dont_export.json";
    public static final String mainLocation = "config/defaultsettings.json";
    public HashMap<String, String> check = new HashMap();
    public static String PLAYER_UUID;
    public static Thread registryChecker;
    public static volatile boolean options_exists;
    public static volatile boolean keys_exists;
    public static volatile boolean servers_exists;
    public static final FileFilter fileFilterModular;
    public static final FileFilter fileFilter;

    public static File getMainFolder() {
        File storeFolder = new File(mcDataDir, "config/defaultsettings");
        storeFolder.mkdir();
        return storeFolder;
    }

    public static HashMap<String, String> getOverrides() {
        return FileUtil.getMainJSON().overrides;
    }

    public static List<String> getActives() {
        return FileUtil.getMainJSON().activeConfigs;
    }

    public static void switchState(Byte state, final String query) {
        FileFilter ff = null;
        ff = !query.isEmpty() ? new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.getName().equals("defaultsettings") && !file.getName().equals("defaultsettings.json") && !file.getName().equals("ds_dont_export.json") && !file.getName().equals("keys.txt") && !file.getName().equals("options.txt") && !file.getName().equals("optionsof.txt") && !file.getName().equals("servers.dat") && file.getName().toLowerCase().startsWith(query.toLowerCase());
            }
        } : fileFilter;
        File main = new File(mcDataDir, mainLocation);
        if (state == 1 || state == 2) {
            ArrayList<String> list = new ArrayList<String>(FileUtil.getMainJSON().activeConfigs);
            FileUtil.mainJson.activeConfigs.stream().filter(file -> file.toLowerCase().startsWith(query.toLowerCase()) && new File(mcDataDir + "/config", (String)file).exists()).forEach(file -> FileUtil.removeFromLists(list, file));
            FileUtil.mainJson.activeConfigs = list;
        } else if (state == 0) {
            File fileDir = new File(mcDataDir, "config");
            for (File file2 : fileDir.listFiles(ff)) {
                FileUtil.getMainJSON().activeConfigs.add(file2.getName());
            }
        }
        mainJson.save(main);
    }

    private static void removeFromLists(List<String> list, String file) {
        list.remove(file);
        FileUtil.mainJson.overrides.remove(file);
    }

    public static PersistentJSON getPersistent() {
        if (persistentJson != null) {
            return persistentJson;
        }
        File main = new File(mcDataDir, persistentLocation);
        if (main.exists()) {
            try (FileReader reader = new FileReader(main);){
                persistentJson = (PersistentJSON)gson.fromJson((Reader)reader, PersistentJSON.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return persistentJson;
    }

    public static void setOverride(String name, boolean actual) {
        File main = new File(mcDataDir, mainLocation);
        String random = UUID.randomUUID().toString();
        mainJson = FileUtil.getMainJSON();
        if (!actual) {
            FileUtil.mainJson.overrides.remove(name);
        } else if (!FileUtil.mainJson.overrides.containsKey(name)) {
            FileUtil.mainJson.overrides.put(name, random);
        }
        mainJson.save(main);
    }

    public static void setActive(String name, boolean active) {
        File main = new File(mcDataDir, mainLocation);
        mainJson = FileUtil.getMainJSON();
        if (!active) {
            FileUtil.mainJson.activeConfigs.remove(name);
            FileUtil.mainJson.overrides.remove(name);
        } else if (!FileUtil.mainJson.activeConfigs.contains(name)) {
            FileUtil.mainJson.activeConfigs.add(name);
        }
        mainJson.save(main);
    }

    public static void switchActive(String name) {
        File main = new File(mcDataDir, mainLocation);
        if (FileUtil.getMainJSON().activeConfigs.contains(name)) {
            FileUtil.mainJson.activeConfigs.remove(name);
            FileUtil.mainJson.overrides.remove(name);
        } else {
            FileUtil.mainJson.activeConfigs.add(name);
        }
        mainJson.save(main);
    }

    public static void initialSetupJSON() throws UnknownHostException, SocketException, NoSuchAlgorithmException {
        File persFile;
        PLAYER_UUID = Minecraft.func_71410_x().func_110432_I().func_148255_b();
        File main = new File(mcDataDir, mainLocation);
        String version = FileUtil.getMainJSON().getVersion();
        if (!"1.3.5".equals(version)) {
            mainJson.setVersion("1.3.5").setPrevVersion(version);
        }
        String identifier = mainJson.getIdentifier();
        if (!FileUtil.getIdentifier().equals(identifier)) {
            mainJson.setIdentifier(FileUtil.getIdentifier());
        }
        if ((persFile = new File(mcDataDir, persistentLocation)).exists()) {
            FileUtil.getPersistent().check.forEach((k, v) -> FileUtil.mainJson.check.put((String)k, (String)v));
            persFile.delete();
        }
        String created_for = FileUtil.mainJson.created_for;
        if (!FileUtil.getUUID(PLAYER_UUID).equals(created_for)) {
            FileUtil.mainJson.created_for = FileUtil.getUUID(PLAYER_UUID);
            FileUtil.mainJson.check.clear();
        }
        mainJson.save(main);
    }

    public static MainJSON getMainJSON() {
        block22: {
            if (mainJson != null) {
                return mainJson;
            }
            File main = new File(mcDataDir, mainLocation);
            if (main.exists()) {
                try (FileReader reader = new FileReader(main);){
                    mainJson = (MainJSON)gson.fromJson((Reader)reader, MainJSON.class);
                    break block22;
                }
                catch (Exception e) {
                    DefaultSettings.log.log(Level.ERROR, "Exception at processing configs: ", (Throwable)e);
                    if (e instanceof JsonSyntaxException) {
                        main.renameTo(new File(mcDataDir, "config/defaultsettings_malformed.json"));
                        FileUtil.getMainJSON();
                    }
                    break block22;
                }
            }
            Date date = new Date();
            SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
            String identifier = "<UNKNOWN>";
            try {
                identifier = FileUtil.getIdentifier();
            }
            catch (SocketException | UnknownHostException | NoSuchAlgorithmException e) {
                DefaultSettings.log.log(Level.ERROR, "Exception at processing configs: ", (Throwable)e);
            }
            mainJson = new MainJSON().setVersion("1.3.5").setIdentifier(identifier).setCreated(formatter.format(date) + " (" + TimeZone.getDefault().getDisplayName() + ")");
            try {
                FileUtil.mainJson.created_for = FileUtil.getUUID(PLAYER_UUID);
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            FileUtil.mainJson.initPopup = true;
            File fileDir = new File(mcDataDir, "config");
            for (File file : fileDir.listFiles(fileFilter)) {
                FileUtil.mainJson.activeConfigs.add(file.getName());
            }
            mainJson.save(main);
        }
        return mainJson;
    }

    public static void setPopup(boolean active) {
        FileUtil.getMainJSON().initPopup = active;
        mainJson.save(new File(mainLocation));
    }

    public static void restoreContents() throws NullPointerException, IOException, NoSuchAlgorithmException {
        File serversFile;
        Object main;
        boolean firstBoot;
        FileUtil.initialSetupJSON();
        File options = new File(mcDataDir, "options.txt");
        boolean bl = firstBoot = !options.exists();
        if (firstBoot) {
            FileUtil.restoreOptions();
            if (!FileUtil.exportMode()) {
                FileUtil.moveAllConfigs(false);
            }
            FileUtil.restoreConfigs();
        } else if (mainJson.getExportMode()) {
            FileUtil.restoreConfigs();
            main = new File(mcDataDir, mainLocation);
            mainJson.save((File)main);
        } else {
            for (String name : FileUtil.getOverrides().keySet()) {
                if (!FileUtil.getActives().contains(name) || FileUtil.getMainJSON().check.containsKey(name) && FileUtil.getMainJSON().check.get(name).equals(FileUtil.mainJson.overrides.get(name))) continue;
                FileUtil.restoreSingleConfig(name);
            }
            main = new File(mcDataDir, mainLocation);
            FileUtil.getMainJSON().setExportMode(false);
            mainJson.save((File)main);
        }
        File optionsOF = new File(mcDataDir, "optionsof.txt");
        if (!optionsOF.exists()) {
            FileUtil.restoreOptionsOF();
        }
        if (!(serversFile = new File(mcDataDir, "servers.dat")).exists()) {
            FileUtil.restoreServers();
        }
        if (firstBoot) {
            GameSettings gameSettings = FileUtil.MC.field_71474_y;
            gameSettings.func_74300_a();
            ResourcePackRepository resourceRepository = MC.func_110438_M();
            resourceRepository.func_110611_a();
            ArrayList<ResourcePackRepository.Entry> repositoryEntries = new ArrayList<ResourcePackRepository.Entry>();
            for (String resourcePack : gameSettings.field_151453_l) {
                for (ResourcePackRepository.Entry entry : resourceRepository.func_110609_b()) {
                    if (!entry.func_110515_d().equals(resourcePack)) continue;
                    repositoryEntries.add(entry);
                }
            }
            resourceRepository.func_148527_a(repositoryEntries);
            FileUtil.MC.func_135016_M().field_135048_c = gameSettings.field_74363_ab;
        }
        if (!options.exists()) {
            options.createNewFile();
        }
    }

    public static boolean optionsFilesExist() {
        File optionsFile = new File(FileUtil.getMainFolder(), "options.txt");
        File optionsofFile = new File(FileUtil.getMainFolder(), "optionsof.txt");
        return optionsFile.exists() || optionsofFile.exists();
    }

    public static boolean keysFileExist() {
        File keysFile = new File(FileUtil.getMainFolder(), "keys.txt");
        return keysFile.exists();
    }

    public static void deleteKeys() {
        new File(FileUtil.getMainFolder(), "keys.txt").delete();
        keys_exists = false;
    }

    public static void deleteServers() {
        new File(FileUtil.getMainFolder(), "servers.dat").delete();
        servers_exists = false;
    }

    public static void deleteOptions() {
        new File(FileUtil.getMainFolder(), "options.txt").delete();
        new File(FileUtil.getMainFolder(), "optionsof.txt").delete();
        options_exists = false;
    }

    public static void restoreOptions() throws NullPointerException, IOException {
        File optionsFile = new File(FileUtil.getMainFolder(), "options.txt");
        if (optionsFile.exists()) {
            BufferedReader reader = null;
            PrintWriter writer = null;
            try {
                String line;
                reader = new BufferedReader(new FileReader(optionsFile));
                writer = new PrintWriter(new FileWriter(new File(mcDataDir, "options.txt")));
                while ((line = reader.readLine()) != null) {
                    writer.print(line + "\n");
                }
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                try {
                    reader.close();
                    writer.close();
                }
                catch (IOException e) {
                    throw e;
                }
                catch (NullPointerException e) {
                    throw e;
                }
            }
        }
    }

    public static void restoreKeys() throws NullPointerException, IOException, NumberFormatException {
        if (DefaultSettings.mcVersion.startsWith("1.8")) {
            DefaultSettings.keyRebinds_18.clear();
        } else {
            DefaultSettings.keyRebinds_19.clear();
        }
        File keysFile = new File(FileUtil.getMainFolder(), "keys.txt");
        if (keysFile.exists()) {
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new FileReader(keysFile));
                while ((line = reader.readLine()) != null) {
                    if (line.isEmpty()) continue;
                    if (DefaultSettings.mcVersion.startsWith("1.8")) {
                        DefaultSettings.keyRebinds_18.put(line.split(":")[0], Integer.parseInt(line.split(":")[1]));
                        continue;
                    }
                    DefaultSettings.keyRebinds_19.put(line.split(":")[0], new KeyContainer(Integer.parseInt(line.split(":")[1]), line.split(":").length > 2 ? KeyModifier.valueFromString((String)line.split(":")[2]) : KeyModifier.NONE));
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (NullPointerException e) {
                throw e;
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw e;
                }
                catch (NullPointerException e) {
                    throw e;
                }
            }
            for (KeyBinding keyBinding : FileUtil.MC.field_71474_y.field_74324_K) {
                if (DefaultSettings.mcVersion.startsWith("1.8")) {
                    if (!DefaultSettings.keyRebinds_18.containsKey(keyBinding.func_151464_g())) continue;
                    keyBinding.field_151472_e = DefaultSettings.keyRebinds_18.get(keyBinding.func_151464_g());
                    continue;
                }
                if (!DefaultSettings.keyRebinds_19.containsKey(keyBinding.func_151464_g())) continue;
                KeyContainer container = DefaultSettings.keyRebinds_19.get(keyBinding.func_151464_g());
                FileUtil.setField("keyModifierDefault", KeyBinding.class, keyBinding, container.modifier);
                keyBinding.field_151472_e = container.input;
                keyBinding.setKeyModifierAndCode(keyBinding.getKeyModifierDefault(), keyBinding.field_151472_e);
            }
            KeyBinding.func_74508_b();
        }
    }

    public static void restoreOptionsOF() throws IOException {
        File optionsOFFile = new File(FileUtil.getMainFolder(), "optionsof.txt");
        if (optionsOFFile.exists()) {
            BufferedReader reader = null;
            PrintWriter writer = null;
            try {
                String line;
                reader = new BufferedReader(new FileReader(optionsOFFile));
                writer = new PrintWriter(new FileWriter(new File(mcDataDir, "optionsof.txt")));
                while ((line = reader.readLine()) != null) {
                    writer.print(line + "\n");
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (NullPointerException e) {
                throw e;
            }
            finally {
                try {
                    reader.close();
                    writer.close();
                }
                catch (IOException e) {
                    throw e;
                }
                catch (NullPointerException e) {
                    throw e;
                }
            }
        }
    }

    public static void restoreSingleConfig(String name) throws IOException {
        File file = new File(FileUtil.getMainFolder(), name);
        if (file.exists()) {
            if (file.isDirectory()) {
                FileUtils.copyDirectory((File)file, (File)new File(mcDataDir, "config/" + name));
            } else {
                FileUtils.copyFile((File)file, (File)new File(mcDataDir, "config/" + name));
            }
        } else {
            DefaultSettings.log.log(Level.WARN, "Couldn't restore a config file as it's missing: " + name);
            return;
        }
        String random = FileUtil.getOverrides().get(name);
        FileUtil.getMainJSON().check.put(name, random);
        mainJson.save(new File(mcDataDir, mainLocation));
    }

    public static void restoreConfigs() throws IOException {
        FileUtils.copyDirectory((File)FileUtil.getMainFolder(), (File)new File(mcDataDir, "config"), (FileFilter)fileFilterModular);
        File main = new File(mcDataDir, mainLocation);
        FileUtil.getMainJSON().setExportMode(false);
        mainJson.save(main);
    }

    public static void moveAllConfigs(boolean deletePersistent) throws IOException {
        File fileDir = new File(mcDataDir, "config");
        if (deletePersistent) {
            new File(mcDataDir, persistentLocation).delete();
        }
        FileUtils.copyDirectory((File)fileDir, (File)FileUtil.getMainFolder(), (FileFilter)fileFilterModular);
        for (File f : fileDir.listFiles(fileFilterModular)) {
            if (f.isDirectory()) {
                FileUtils.deleteDirectory((File)f);
                continue;
            }
            Files.delete(f.toPath());
        }
        File main = new File(mcDataDir, mainLocation);
        FileUtil.getMainJSON().setExportMode(true);
        mainJson.save(main);
    }

    public static void setExportMode() throws IOException {
        for (File f : new File(mcDataDir, "config").listFiles(fileFilterModular)) {
            if (f.isDirectory()) {
                FileUtils.deleteDirectory((File)f);
                continue;
            }
            Files.delete(f.toPath());
        }
        File main = new File(mcDataDir, mainLocation);
        FileUtil.getMainJSON().setExportMode(true);
        mainJson.save(main);
    }

    public static boolean exportMode() {
        return new File(mcDataDir, "config").listFiles(fileFilterModular).length == 0;
    }

    public static void restoreServers() throws IOException {
        try {
            File file = new File(FileUtil.getMainFolder(), "servers.dat");
            if (file.exists()) {
                FileUtils.copyFile((File)file, (File)new File(mcDataDir, "servers.dat"));
            } else {
                DefaultSettings.log.log(Level.WARN, "Couldn't restore the server config as it's not included");
            }
        }
        catch (IOException e) {
            DefaultSettings.log.log(Level.ERROR, "Couldn't restore the server config: ", (Throwable)e);
        }
    }

    public static void saveKeys() throws IOException, NullPointerException {
        try (PrintWriter writer = null;){
            writer = new PrintWriter(new FileWriter(new File(FileUtil.getMainFolder(), "keys.txt")));
            for (KeyBinding keyBinding : FileUtil.MC.field_71474_y.field_74324_K) {
                if (DefaultSettings.mcVersion.startsWith("1.8")) {
                    writer.print(keyBinding.func_151464_g() + ":" + keyBinding.func_151463_i() + "\n");
                    continue;
                }
                writer.print(keyBinding.func_151464_g() + ":" + keyBinding.func_151463_i() + ":" + keyBinding.getKeyModifier().name() + "\n");
            }
        }
    }

    public static void saveOptions() throws NullPointerException, IOException {
        String line;
        FileUtil.MC.field_71474_y.func_74303_b();
        PrintWriter writer = null;
        BufferedReader reader = null;
        try {
            writer = new PrintWriter(new FileWriter(new File(FileUtil.getMainFolder(), "options.txt")));
            reader = new BufferedReader(new FileReader(new File(mcDataDir, "options.txt")));
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("key_")) continue;
                writer.print(line + "\n");
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (NullPointerException e) {
            throw e;
        }
        finally {
            try {
                reader.close();
                writer.close();
            }
            catch (IOException e) {
                throw e;
            }
            catch (NullPointerException e) {
                throw e;
            }
        }
        if (!FMLClientHandler.instance().hasOptifine()) {
            return;
        }
        try {
            writer = new PrintWriter(new FileWriter(new File(FileUtil.getMainFolder(), "optionsof.txt")));
            reader = new BufferedReader(new FileReader(new File(mcDataDir, "optionsof.txt")));
            while ((line = reader.readLine()) != null) {
                writer.print(line + "\n");
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (NullPointerException e) {
            throw e;
        }
        finally {
            try {
                reader.close();
                writer.close();
            }
            catch (IOException e) {
                throw e;
            }
            catch (NullPointerException e) {
                throw e;
            }
        }
    }

    public static void saveServers() throws IOException {
        File serversFile = new File(mcDataDir, "servers.dat");
        if (serversFile.exists()) {
            FileUtils.copyFile((File)serversFile, (File)new File(FileUtil.getMainFolder(), "servers.dat"));
        }
    }

    public static boolean serversFileExists() {
        File serversFile = new File(FileUtil.getMainFolder(), "servers.dat");
        return serversFile.exists();
    }

    public static String getUUID(String uuid) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(uuid.getBytes());
        byte[] digest = md.digest();
        return DatatypeConverter.printHexBinary((byte[])digest).toUpperCase();
    }

    public static String getIdentifier() throws UnknownHostException, SocketException, NoSuchAlgorithmException {
        InetAddress l = InetAddress.getLocalHost();
        NetworkInterface inter = NetworkInterface.getByInetAddress(l);
        byte[] mac = inter.getHardwareAddress();
        if (mac != null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < mac.length; ++i) {
                sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
            }
            String address = sb.toString();
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(address.getBytes());
            byte[] digest = md.digest();
            return DatatypeConverter.printHexBinary((byte[])digest).toUpperCase();
        }
        return "0";
    }

    private static void setField(String name, Class clazz, Object obj, Object value) {
        try {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            field.set(obj, value);
        }
        catch (IllegalAccessException e) {
            DefaultSettings.log.log(Level.ERROR, "Reflection exception: ", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            DefaultSettings.log.log(Level.ERROR, "Reflection exception: ", (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            DefaultSettings.log.log(Level.ERROR, "Reflection exception: ", (Throwable)e);
        }
        catch (SecurityException e) {
            DefaultSettings.log.log(Level.ERROR, "Reflection exception: ", (Throwable)e);
        }
    }

    static {
        options_exists = false;
        keys_exists = false;
        servers_exists = false;
        fileFilterModular = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.getName().equals("defaultsettings") && !file.getName().equals("defaultsettings.json") && !file.getName().equals("ds_dont_export.json") && !file.getName().equals("keys.txt") && !file.getName().equals("options.txt") && !file.getName().equals("optionsof.txt") && !file.getName().equals("servers.dat") && (file.getPath().split("config")[1].split(Pattern.quote("\\")).length > 2 || FileUtil.getActives().contains(file.getName()));
            }
        };
        fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.getName().equals("defaultsettings") && !file.getName().equals("defaultsettings.json") && !file.getName().equals("ds_dont_export.json") && !file.getName().equals("keys.txt") && !file.getName().equals("options.txt") && !file.getName().equals("optionsof.txt") && !file.getName().equals("servers.dat");
            }
        };
    }

    public static class RegistryChecker {
        public RegistryChecker() {
            if (registryChecker != null) {
                return;
            }
            registryChecker = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        if (!(FileUtil.MC.field_71462_r instanceof GuiConfig)) break;
                        options_exists = FileUtil.optionsFilesExist();
                        keys_exists = FileUtil.keysFileExist();
                        servers_exists = FileUtil.serversFileExists();
                        GuiScreen gui = FileUtil.MC.field_71462_r;
                        if (gui instanceof GuiConfig && ((GuiConfig)gui).menu != null) {
                            for (MenuArea variant : ((GuiConfig)gui).menu.getVariants()) {
                                variant.getChildren().stream().filter(segment -> segment instanceof ScrollableSegment).forEach(segment -> segment.guiContentUpdate(((ScrollableSegment)segment).searchbar.query));
                            }
                        }
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    registryChecker = null;
                }
            });
            registryChecker.start();
        }
    }
}

