/*
 * Decompiled with CFR 0.152.
 */
package de.pt400c.defaultsettings;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;

@SideOnly(value=Side.CLIENT)
public class FramebufferObject {
    public int framebufferTextureWidth;
    public int framebufferTextureHeight;
    public int framebufferWidth;
    public int framebufferHeight;
    public int framebufferObject = -1;
    public int colorBuffer;

    public FramebufferObject(int width, int height) {
        this.createBindFramebuffer(width, height);
    }

    public void createBindFramebuffer(int width, int height) {
        if (this.framebufferObject >= 0) {
            this.deleteFramebuffer();
        }
        this.createFramebuffer(width, height);
        GL30.glBindFramebuffer((int)36160, (int)0);
    }

    public void deleteFramebuffer() {
        this.unbindFramebuffer();
        if (this.framebufferObject > -1) {
            GL30.glBindFramebuffer((int)36160, (int)0);
            GL30.glDeleteFramebuffers((int)this.framebufferObject);
            this.framebufferObject = -1;
        }
    }

    public void createFramebuffer(int width, int height) {
        this.framebufferWidth = width;
        this.framebufferHeight = height;
        this.framebufferTextureWidth = width;
        this.framebufferTextureHeight = height;
        this.createFrameBuffer();
        this.createColorAttachment();
        this.framebufferClear();
    }

    private void createFrameBuffer() {
        this.framebufferObject = GL30.glGenFramebuffers();
        GL30.glBindFramebuffer((int)36160, (int)this.framebufferObject);
        GL11.glDrawBuffer((int)36064);
    }

    private void createColorAttachment() {
        this.colorBuffer = GL30.glGenRenderbuffers();
        GL30.glBindRenderbuffer((int)36161, (int)this.colorBuffer);
        GL30.glRenderbufferStorageMultisample((int)36161, (int)9, (int)32856, (int)this.framebufferWidth, (int)this.framebufferHeight);
        GL30.glFramebufferRenderbuffer((int)36160, (int)36064, (int)36161, (int)this.colorBuffer);
    }

    public void bindFramebuffer(boolean vp) {
        GL30.glBindFramebuffer((int)36160, (int)this.framebufferObject);
        if (vp) {
            GL11.glViewport((int)0, (int)0, (int)this.framebufferWidth, (int)this.framebufferHeight);
        }
    }

    public void unbindFramebuffer() {
        GL30.glBindFramebuffer((int)36160, (int)0);
    }

    public void framebufferClear() {
        this.bindFramebuffer(true);
        GL11.glClear((int)16384);
        this.unbindFramebuffer();
    }
}

