/*
 * Decompiled with CFR 0.152.
 */
package de.pt400c.defaultsettings;

import de.pt400c.defaultsettings.DefaultSettings;
import de.pt400c.defaultsettings.FileUtil;
import de.pt400c.defaultsettings.FramebufferObject;
import de.pt400c.defaultsettings.gui.ButtonMenuSegment;
import de.pt400c.defaultsettings.gui.ButtonSegment;
import de.pt400c.defaultsettings.gui.ButtonUpdateChecker;
import de.pt400c.defaultsettings.gui.DefaultSettingsGUI;
import de.pt400c.defaultsettings.gui.DeleteSegment;
import de.pt400c.defaultsettings.gui.ExportSwitchSegment;
import de.pt400c.defaultsettings.gui.LeftMenu;
import de.pt400c.defaultsettings.gui.MenuArea;
import de.pt400c.defaultsettings.gui.MenuScreen;
import de.pt400c.defaultsettings.gui.PopupSegment;
import de.pt400c.defaultsettings.gui.PopupWindow;
import de.pt400c.defaultsettings.gui.QuitButtonSegment;
import de.pt400c.defaultsettings.gui.ScrollableSegment;
import de.pt400c.defaultsettings.gui.SplitterSegment;
import de.pt400c.defaultsettings.gui.TextSegment;
import de.pt400c.neptunefx.NEX;
import java.awt.Color;
import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GL30;

@SideOnly(value=Side.CLIENT)
public class GuiConfig
extends DefaultSettingsGUI {
    public final GuiScreen parentScreen;
    public LeftMenu leftMenu;
    public PopupSegment popup;
    public ButtonSegment buttonS;
    public ButtonSegment buttonK;
    public ButtonSegment buttonO;
    public ButtonMenuSegment selectedSegment = null;
    private ExecutorService tpe = new ThreadPoolExecutor(1, 3, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private ButtonState[] cooldowns = new ButtonState[]{new ButtonState(false, 0), new ButtonState(false, 0), new ButtonState(false, 0)};
    public FramebufferObject framebufferMc;
    public boolean legacy;
    private int bgDPLList = -1;
    private boolean compiled;

    public GuiConfig(GuiScreen parentScreen) {
        this.field_146297_k = FileUtil.MC;
        this.parentScreen = parentScreen;
    }

    @Override
    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1 && this.popupField != null) {
            this.popupField.setOpening(false);
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    @Override
    public void func_73866_w_() {
        new FileUtil.RegistryChecker();
        if (this.framebufferMc != null) {
            GL30.glDeleteRenderbuffers((int)this.framebufferMc.colorBuffer);
            GL30.glDeleteFramebuffers((int)this.framebufferMc.framebufferObject);
        }
        this.compiled = false;
        boolean fbo = FileUtil.MC.field_71474_y.field_151448_g;
        if (!fbo) {
            this.legacy = true;
        }
        if (!this.legacy) {
            this.framebufferMc = new FramebufferObject(FileUtil.MC.field_71443_c, FileUtil.MC.field_71440_d);
        }
        Keyboard.enableRepeatEvents((boolean)true);
        this.clearSegments();
        this.addSegment(new QuitButtonSegment((GuiScreen)this, (float)(this.field_146294_l - 22), 2.0f, 20, 20, button -> {
            this.field_146297_k.func_147108_a(this.parentScreen);
            return true;
        }, 5.0f, false));
        this.menu = new MenuScreen(this, 74.0f, 25.0f);
        this.leftMenu = new LeftMenu(this, 0.0f, 25.0f, 46.0f, this.field_146295_m - 25);
        this.buttonO = new ButtonSegment((GuiScreen)this, this.menu.getWidth() / 2.0f - 60.0f, this.menu.getHeight() / 2.0f - 30.0f, "Save options", button -> {
            this.tpe.execute(new Runnable(){

                @Override
                public void run() {
                    GuiConfig.this.saveOptions();
                }
            });
            return true;
        }, 80, 25, 3, "Save all default game options");
        this.buttonS = new ButtonSegment((GuiScreen)this, this.menu.getWidth() / 2.0f + 52.0f, this.menu.getHeight() / 2.0f - 30.0f, "Save servers", button -> {
            this.tpe.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        GuiConfig.this.saveServers();
                    }
                    catch (ClosedByInterruptException e) {
                        DefaultSettings.log.log(Level.DEBUG, "An exception occurred while saving the server list: Interruption exception");
                    }
                }
            });
            return true;
        }, 80, 25, 3, "Save your servers");
        this.buttonK = new ButtonSegment((GuiScreen)this, this.menu.getWidth() / 2.0f - 167.0f, this.menu.getHeight() / 2.0f - 30.0f, "Save keys", button -> {
            this.tpe.execute(new Runnable(){

                @Override
                public void run() {
                    GuiConfig.this.saveKeys();
                }
            });
            return true;
        }, 80, 25, 3, "Save keybindings");
        this.addSegment(this.menu.addVariant(new MenuArea(this, 74.0f, 25.0f).addChild(this.buttonO).addChild(this.buttonS).addChild(this.buttonK).addChild(new DeleteSegment((GuiScreen)this, this.menu.getWidth() / 2.0f - 167.0f + 40.0f, this.menu.getHeight() / 2.0f - 30.0f + 50.0f, 22, 22, 0)).addChild(new DeleteSegment((GuiScreen)this, this.menu.getWidth() / 2.0f - 60.0f + 40.0f, this.menu.getHeight() / 2.0f - 30.0f + 50.0f, 22, 22, 1)).addChild(new DeleteSegment((GuiScreen)this, this.menu.getWidth() / 2.0f + 52.0f + 40.0f, this.menu.getHeight() / 2.0f - 30.0f + 50.0f, 22, 22, 2))).addVariant(new MenuArea(this, 74.0f, 25.0f).addChild(new ScrollableSegment((GuiScreen)this, 20.0f, 30.0f, this.field_146294_l - 74 - 90, this.field_146295_m - 25 - 10 - 30, 0))).addVariant(new MenuArea(this, 74.0f, 25.0f).addChild(new TextSegment(this, 10.0f, 20.0f, 20, 20, "DefaultSettings: " + DefaultSettings.mcVersion + "-" + "1.3.5" + "\n\nBuild-ID: " + DefaultSettings.BUILD_ID + "\n\nBuild-Time: " + DefaultSettings.BUILD_TIME + "\n\n\nCreated by Jomcraft Network, 2019", 0, false))));
        this.addSegment(this.leftMenu.addChild(new ButtonMenuSegment(0, this, 10.0f, 9.0f, "Save", button -> true, this.leftMenu, "textures/gui/save.png").setActive(true, false)).addChild(new ButtonMenuSegment(1, this, 10.0f, 35.0f, "Configs", button -> true, this.leftMenu, "textures/gui/config.png")).addChild(new ButtonMenuSegment(2, this, 10.0f, 61.0f, "About", button -> true, this.leftMenu, "textures/gui/about.png")).addChild(new SplitterSegment(this, 72.0f, 7.0f, this.field_146295_m - 42, this.leftMenu)).addChild(new ButtonUpdateChecker(this, this.field_146295_m - 30 - 25, this.leftMenu)));
        this.addSegment(new ExportSwitchSegment(this, 160.0f, 7.0f));
        this.popup = new PopupSegment(this, 0.0f, 0.0f, this.field_146294_l, this.field_146295_m).setWindow(new PopupWindow((GuiScreen)this, (float)(this.field_146294_l / 2 - 105), (float)(this.field_146295_m / 2 - 50), 210.0f, 100.0f, "").addChild(new QuitButtonSegment((GuiScreen)this, 190.0f, 5.0f, 14, 14, button -> {
            this.popupField.setOpening(false);
            return true;
        }, 3.0f, true)));
        this.addSegment(this.popup);
        this.popupField = null;
        super.func_73866_w_();
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
        if (this.framebufferMc != null) {
            this.framebufferMc.deleteFramebuffer();
        }
        this.tpe.shutdownNow();
    }

    public void changeSelected(ButtonMenuSegment segment) {
        if (this.selectedSegment != null && this.selectedSegment != segment) {
            this.selectedSegment.setActive(false, true);
        }
        this.selectedSegment = segment;
        this.menu.setIndex(segment.id);
    }

    public void func_73876_c() {
        super.func_73876_c();
        for (int id = 0; id < this.cooldowns.length; ++id) {
            if (this.cooldowns[id].renderCooldown > 0) {
                --this.cooldowns[id].renderCooldown;
                continue;
            }
            if (this.cooldowns[id].renderCooldown >= 0) continue;
            ++this.cooldowns[id].renderCooldown;
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.legacy) {
            GuiConfig.func_73734_a((int)0, (int)0, (int)this.field_146294_l, (int)this.field_146295_m, (int)Color.WHITE.getRGB());
            GuiConfig.func_73734_a((int)0, (int)0, (int)72, (int)25, (int)-6316129);
            GuiConfig.func_73734_a((int)72, (int)0, (int)this.field_146294_l, (int)25, (int)-2039584);
            this.field_146289_q.func_175063_a("Tab", (float)GuiConfig.clamp(36 - this.field_146289_q.func_78256_a("Tab") / 2, 0, Integer.MAX_VALUE), 10.0f, 0xFFFFFF);
            int posX = GuiConfig.clamp((this.field_146294_l - 74) / 2 + 74 - this.field_146289_q.func_78256_a("- DefaultSettings -") / 2, 74, Integer.MAX_VALUE);
            this.field_146289_q.func_78276_b("- DefaultSettings -", posX + 1, 11, Color.WHITE.getRGB());
            this.field_146289_q.func_78276_b("- DefaultSettings -", posX, 10, -10658467);
            int n = this.cooldowns[1].getProgress() ? -3364076 : (this.cooldowns[1].renderCooldown < 0 ? -3402732 : (this.buttonS.color = this.cooldowns[1].renderCooldown > 0 ? -10630124 : -5987164));
            int n2 = this.cooldowns[2].getProgress() ? -3364076 : (this.cooldowns[2].renderCooldown < 0 ? -3402732 : (this.buttonK.color = this.cooldowns[2].renderCooldown > 0 ? -10630124 : -5987164));
            this.buttonO.color = this.cooldowns[0].getProgress() ? -3364076 : (this.cooldowns[0].renderCooldown < 0 ? -3402732 : (this.cooldowns[0].renderCooldown > 0 ? -10630124 : -5987164));
            super.func_73863_a(mouseX, mouseY, partialTicks);
        } else {
            this.field_146297_k.func_147110_a().func_147609_e();
            GL11.glPushMatrix();
            GL11.glClear((int)16640);
            this.framebufferMc.bindFramebuffer(true);
            GL11.glEnable((int)32925);
            GL11.glEnable((int)3553);
            ScaledResolution scaledresolution = DefaultSettings.is180 ? new ScaledResolution(this.field_146297_k, this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d) : new ScaledResolution(this.field_146297_k);
            GL11.glClear((int)256);
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            GL11.glOrtho((double)0.0, (double)scaledresolution.func_78327_c(), (double)scaledresolution.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
            GL11.glMatrixMode((int)5888);
            GL11.glLoadIdentity();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
            GL11.glClear((int)256);
            GuiConfig.func_73734_a((int)0, (int)0, (int)this.field_146294_l, (int)this.field_146295_m, (int)Color.WHITE.getRGB());
            if (this.compiled) {
                GL11.glCallList((int)this.bgDPLList);
            } else {
                this.bgDPLList = GLAllocation.func_74526_a((int)1);
                GL11.glNewList((int)this.bgDPLList, (int)4864);
                GL11.glDisable((int)3553);
                GL11.glEnable((int)3042);
                GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)0);
                GL11.glShadeModel((int)7425);
                NEX.drawGradient(72.0f, 25.0f, this.field_146294_l, 30.0f, -5592406, 0xFFFFFF, 1);
                NEX.drawGradient(0.0f, 25.0f, 72.0f, 30.0f, -8618884, 0xFFFFFF, 1);
                GL11.glShadeModel((int)7424);
                GL11.glDisable((int)3042);
                GL11.glEnable((int)3553);
                GuiConfig.func_73734_a((int)0, (int)0, (int)72, (int)25, (int)-6316129);
                GuiConfig.func_73734_a((int)72, (int)0, (int)this.field_146294_l, (int)25, (int)-2039584);
                this.field_146289_q.func_175063_a("Tab", (float)GuiConfig.clamp(36 - this.field_146289_q.func_78256_a("Tab") / 2, 0, Integer.MAX_VALUE), 10.0f, 0xFFFFFF);
                int posX = GuiConfig.clamp((this.field_146294_l - 74) / 2 + 74 - this.field_146289_q.func_78256_a("- DefaultSettings -") / 2, 74, Integer.MAX_VALUE);
                this.field_146289_q.func_78276_b("- DefaultSettings -", posX + 1, 11, Color.WHITE.getRGB());
                this.field_146289_q.func_78276_b("- DefaultSettings -", posX, 10, -10658467);
                GL11.glEndList();
                this.compiled = true;
                GL11.glCallList((int)this.bgDPLList);
            }
            int n = this.cooldowns[1].getProgress() ? -3364076 : (this.cooldowns[1].renderCooldown < 0 ? -3402732 : (this.buttonS.color = this.cooldowns[1].renderCooldown > 0 ? -10630124 : -5987164));
            int n3 = this.cooldowns[2].getProgress() ? -3364076 : (this.cooldowns[2].renderCooldown < 0 ? -3402732 : (this.buttonK.color = this.cooldowns[2].renderCooldown > 0 ? -10630124 : -5987164));
            this.buttonO.color = this.cooldowns[0].getProgress() ? -3364076 : (this.cooldowns[0].renderCooldown < 0 ? -3402732 : (this.cooldowns[0].renderCooldown > 0 ? -10630124 : -5987164));
            super.func_73863_a(mouseX, mouseY, partialTicks);
            this.framebufferMc.unbindFramebuffer();
            GL11.glPopMatrix();
            this.field_146297_k.func_147110_a().func_147610_a(true);
            GL11.glPushMatrix();
            GL30.glBindFramebuffer((int)36008, (int)this.framebufferMc.framebufferObject);
            GL30.glBlitFramebuffer((int)0, (int)0, (int)FileUtil.MC.field_71443_c, (int)FileUtil.MC.field_71440_d, (int)0, (int)0, (int)FileUtil.MC.field_71443_c, (int)FileUtil.MC.field_71440_d, (int)16384, (int)9728);
            GL11.glPopMatrix();
        }
    }

    public void saveServers() throws ClosedByInterruptException {
        if (FileUtil.serversFileExists()) {
            this.popup.setOpening(true);
            this.popup.getWindow().title = "Save Servers";
            this.popup.getWindow().setPos(this.field_146294_l / 2 - 105, this.field_146295_m / 2 - 50);
            this.popupField = this.popup;
            this.popupField.getWindow().clearChildren();
            this.popupField.getWindow().addChild(new TextSegment(this, 5.0f, 30.0f, 20, 20, "The server list already exists\n\nWould you like to overwrite it?", 0, true));
            this.popupField.getWindow().addChild(new QuitButtonSegment((GuiScreen)this, 190.0f, 5.0f, 14, 14, button -> {
                this.popupField.setOpening(false);
                return true;
            }, 3.0f, true));
            this.popupField.getWindow().addChild(new ButtonSegment(this, 75.0f, 75.0f, "Overwrite", button -> {
                this.cooldowns[1].setProgress(true);
                this.popupField.setOpening(false);
                this.tpe.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            FileUtil.saveServers();
                            ((GuiConfig)GuiConfig.this).cooldowns[1].renderCooldown = 30;
                        }
                        catch (ClosedByInterruptException e) {
                            DefaultSettings.log.log(Level.DEBUG, "An exception occurred while saving the server list: Interruption exception");
                        }
                        catch (Exception e) {
                            DefaultSettings.log.log(Level.ERROR, "An exception occurred while saving the server list:", (Throwable)e);
                            ((GuiConfig)GuiConfig.this).cooldowns[1].renderCooldown = -30;
                        }
                        GuiConfig.this.cooldowns[1].setProgress(false);
                        FileUtil.servers_exists = FileUtil.serversFileExists();
                    }
                });
                return true;
            }, 60, 20, 2, null, true));
            this.popup.isVisible = true;
        } else {
            this.cooldowns[1].setProgress(true);
            try {
                FileUtil.saveServers();
                this.cooldowns[1].renderCooldown = 30;
            }
            catch (ClosedByInterruptException e) {
                throw e;
            }
            catch (Exception e) {
                DefaultSettings.log.log(Level.ERROR, "An exception occurred while saving the server list:", (Throwable)e);
                this.cooldowns[1].renderCooldown = -30;
            }
            this.cooldowns[1].setProgress(false);
            FileUtil.servers_exists = FileUtil.serversFileExists();
        }
    }

    public void copyConfigs() {
        this.tpe.execute(new Runnable(){

            @Override
            public void run() {
                GuiConfig.this.menu.exportActive.setByte((byte)0);
                try {
                    FileUtil.restoreConfigs();
                }
                catch (IOException e) {
                    if (e instanceof ClosedByInterruptException) {
                        return;
                    }
                    DefaultSettings.getInstance();
                    DefaultSettings.log.log(Level.ERROR, "An exception occurred while trying to move the configs:", (Throwable)e);
                }
                GuiConfig.this.menu.exportActive.setByte((byte)1);
                for (MenuArea variant : GuiConfig.this.menu.getVariants()) {
                    variant.getChildren().stream().filter(segment -> segment instanceof ScrollableSegment).forEach(segment -> segment.guiContentUpdate(((ScrollableSegment)segment).searchbar.query));
                }
            }
        });
    }

    public void deleteConfigs() {
        if (!FileUtil.exportMode()) {
            this.popup.setOpening(true);
            this.popup.getWindow().title = "Delete Config Folder";
            this.popup.getWindow().setPos(this.field_146294_l / 2 - 105, this.field_146295_m / 2 - 50);
            this.popupField = this.popup;
            this.popupField.getWindow().clearChildren();
            this.popupField.getWindow().addChild(new TextSegment(this, 5.0f, 30.0f, 20, 20, "Do you want to delete every file\nfrom the config folder?\n\n(The defaultsettings folder will be kept)", 0, true));
            this.popupField.getWindow().addChild(new QuitButtonSegment((GuiScreen)this, 190.0f, 5.0f, 14, 14, button -> {
                this.popupField.setOpening(false);
                return true;
            }, 3.0f, true));
            this.popupField.getWindow().addChild(new ButtonSegment(this, 25.0f, 75.0f, "Proceed", button -> {
                this.popupField.setOpening(false);
                this.tpe.execute(new Runnable(){

                    @Override
                    public void run() {
                        GuiConfig.this.menu.exportActive.setByte((byte)0);
                        try {
                            FileUtil.setExportMode();
                        }
                        catch (IOException e) {
                            if (e instanceof ClosedByInterruptException) {
                                return;
                            }
                            DefaultSettings.getInstance();
                            DefaultSettings.log.log(Level.ERROR, "An exception occurred while trying to move the configs:", (Throwable)e);
                        }
                        for (MenuArea variant : GuiConfig.this.menu.getVariants()) {
                            variant.getChildren().stream().filter(segment -> segment instanceof ScrollableSegment).forEach(segment -> segment.guiContentUpdate(((ScrollableSegment)segment).searchbar.query));
                        }
                        GuiConfig.this.menu.exportActive.setByte((byte)2);
                    }
                });
                return true;
            }, 60, 20, 2, null, true));
            this.popupField.getWindow().addChild(new ButtonSegment(this, 125.0f, 75.0f, "Move", button -> {
                this.popupField.setOpening(false);
                this.tpe.execute(new Runnable(){

                    @Override
                    public void run() {
                        GuiConfig.this.menu.exportActive.setByte((byte)0);
                        try {
                            FileUtil.moveAllConfigs(true);
                        }
                        catch (IOException e) {
                            if (e instanceof ClosedByInterruptException) {
                                return;
                            }
                            DefaultSettings.getInstance();
                            DefaultSettings.log.log(Level.ERROR, "An exception occurred while trying to move the configs:", (Throwable)e);
                        }
                        GuiConfig.this.menu.exportActive.setByte((byte)(FileUtil.exportMode() ? 2 : 1));
                        for (MenuArea variant : GuiConfig.this.menu.getVariants()) {
                            variant.getChildren().stream().filter(segment -> segment instanceof ScrollableSegment).forEach(segment -> segment.guiContentUpdate(((ScrollableSegment)segment).searchbar.query));
                        }
                    }
                });
                return true;
            }, 60, 20, 2, "Move all contents from the config folder to DS's config management", true));
            this.popup.isVisible = true;
        } else {
            this.tpe.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        FileUtil.setExportMode();
                    }
                    catch (IOException e) {
                        if (e instanceof ClosedByInterruptException) {
                            return;
                        }
                        DefaultSettings.getInstance();
                        DefaultSettings.log.log(Level.ERROR, "An exception occurred while trying to move the configs:", (Throwable)e);
                    }
                    GuiConfig.this.menu.exportActive.setByte((byte)2);
                    for (MenuArea variant : GuiConfig.this.menu.getVariants()) {
                        variant.getChildren().stream().filter(segment -> segment instanceof ScrollableSegment).forEach(segment -> segment.guiContentUpdate(((ScrollableSegment)segment).searchbar.query));
                    }
                }
            });
        }
    }

    public void saveOptions() {
        if (FileUtil.optionsFilesExist()) {
            this.popup.setOpening(true);
            this.popup.getWindow().title = "Save Options";
            this.popup.getWindow().setPos(this.field_146294_l / 2 - 105, this.field_146295_m / 2 - 50);
            this.popupField = this.popup;
            this.popupField.getWindow().clearChildren();
            this.popupField.getWindow().addChild(new TextSegment(this, 5.0f, 30.0f, 20, 20, "The default options already exist\n\nWould you like to overwrite them?", 0, true));
            this.popupField.getWindow().addChild(new QuitButtonSegment((GuiScreen)this, 190.0f, 5.0f, 14, 14, button -> {
                this.popupField.setOpening(false);
                return true;
            }, 3.0f, true));
            this.popupField.getWindow().addChild(new ButtonSegment(this, 75.0f, 75.0f, "Overwrite", button -> {
                this.cooldowns[0].setProgress(true);
                this.popupField.setOpening(false);
                this.tpe.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            FileUtil.saveOptions();
                            ((GuiConfig)GuiConfig.this).cooldowns[0].renderCooldown = 30;
                        }
                        catch (ClosedByInterruptException e) {
                            DefaultSettings.log.log(Level.DEBUG, "An exception occurred while saving the default game options: Interruption exception");
                        }
                        catch (Exception e) {
                            DefaultSettings.log.log(Level.ERROR, "An exception occurred while saving the default game options:", (Throwable)e);
                            ((GuiConfig)GuiConfig.this).cooldowns[0].renderCooldown = -30;
                        }
                        GuiConfig.this.cooldowns[0].setProgress(false);
                        FileUtil.options_exists = FileUtil.optionsFilesExist();
                    }
                });
                return true;
            }, 60, 20, 2, null, true));
            this.popup.isVisible = true;
        } else {
            this.cooldowns[0].setProgress(true);
            try {
                FileUtil.saveOptions();
                this.cooldowns[0].renderCooldown = 30;
            }
            catch (ClosedByInterruptException e) {
                DefaultSettings.log.log(Level.DEBUG, "An exception occurred while saving the default game options: Interruption exception");
            }
            catch (Exception e) {
                DefaultSettings.log.log(Level.ERROR, "An exception occurred while saving the default game options:", (Throwable)e);
                this.cooldowns[0].renderCooldown = -30;
            }
            this.cooldowns[0].setProgress(false);
            FileUtil.options_exists = FileUtil.optionsFilesExist();
        }
    }

    public void saveKeys() {
        if (FileUtil.keysFileExist()) {
            this.popup.setOpening(true);
            this.popup.getWindow().title = "Save Keybindings";
            this.popup.getWindow().setPos(this.field_146294_l / 2 - 105, this.field_146295_m / 2 - 50);
            this.popupField = this.popup;
            this.popupField.getWindow().clearChildren();
            this.popupField.getWindow().addChild(new TextSegment(this, 5.0f, 30.0f, 20, 20, "The default keybindings already exist\n\nWould you like to overwrite them?", 0, true));
            this.popupField.getWindow().addChild(new QuitButtonSegment((GuiScreen)this, 190.0f, 5.0f, 14, 14, button -> {
                this.popupField.setOpening(false);
                return true;
            }, 3.0f, true));
            this.popupField.getWindow().addChild(new ButtonSegment(this, 75.0f, 75.0f, "Overwrite", button -> {
                this.cooldowns[2].setProgress(true);
                this.popupField.setOpening(false);
                this.tpe.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            FileUtil.saveKeys();
                            ((GuiConfig)GuiConfig.this).cooldowns[2].renderCooldown = 30;
                            FileUtil.restoreKeys();
                        }
                        catch (ClosedByInterruptException e) {
                            DefaultSettings.log.log(Level.DEBUG, "An exception occurred while saving the key configuration: Interruption exception");
                        }
                        catch (Exception e) {
                            DefaultSettings.log.log(Level.ERROR, "An exception occurred while saving the key configuration:", (Throwable)e);
                            ((GuiConfig)GuiConfig.this).cooldowns[2].renderCooldown = -30;
                        }
                        GuiConfig.this.cooldowns[2].setProgress(false);
                        FileUtil.keys_exists = FileUtil.keysFileExist();
                    }
                });
                return true;
            }, 60, 20, 2, null, true));
            this.popup.isVisible = true;
        } else {
            this.cooldowns[2].setProgress(true);
            try {
                FileUtil.saveKeys();
                this.cooldowns[2].renderCooldown = 30;
                FileUtil.restoreKeys();
            }
            catch (ClosedByInterruptException e) {
                DefaultSettings.log.log(Level.DEBUG, "An exception occurred while saving the key configuration: Interruption exception");
            }
            catch (Exception e) {
                DefaultSettings.log.log(Level.ERROR, "An exception occurred while saving the key configuration:", (Throwable)e);
                this.cooldowns[2].renderCooldown = -30;
            }
            this.cooldowns[2].setProgress(false);
            FileUtil.keys_exists = FileUtil.keysFileExist();
        }
    }

    public static int clamp(int num, int min, int max) {
        if (num < min) {
            return min;
        }
        return num > max ? max : num;
    }

    public static float clamp(float num, float min, float max) {
        if (num < min) {
            return min;
        }
        return num > max ? max : num;
    }

    private class ButtonState {
        private boolean inProgress = false;
        public int renderCooldown = 0;

        public ButtonState(boolean inProgress, int renderCooldown) {
            this.inProgress = inProgress;
            this.renderCooldown = renderCooldown;
        }

        public void setProgress(boolean inProgress) {
            this.inProgress = inProgress;
        }

        public boolean getProgress() {
            return this.inProgress;
        }
    }
}

