/*
 * Decompiled with CFR 0.152.
 */
package de.pt400c.defaultsettings.core;

import de.pt400c.defaultsettings.DefaultSettings;
import java.util.Arrays;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.Level;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class DefaultSettingsClassTransformer
implements IClassTransformer {
    private static final String[] classesToTransform = new String[]{"net.minecraft.client.Minecraft"};
    public static boolean gameObf;

    public byte[] transform(String name, String transformedName, byte[] classToTransform) {
        boolean isObfuscated = !name.equals(transformedName);
        int c_index = Arrays.asList(classesToTransform).indexOf(transformedName);
        if (!gameObf && isObfuscated) {
            gameObf = true;
        }
        return c_index != -1 ? this.transform(c_index, classToTransform, gameObf, name, transformedName) : classToTransform;
    }

    private byte[] transform(int c_index, byte[] classToTransform, boolean isObfuscated, String name, String transformedName) {
        DefaultSettings.log.log(Level.INFO, "Transforming now: " + classesToTransform[c_index]);
        try {
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(classToTransform);
            classReader.accept((ClassVisitor)classNode, 0);
            switch (c_index) {
                case 0: {
                    DefaultSettingsClassTransformer.transformDefaultFramerate(classNode, isObfuscated);
                }
            }
            ClassWriter classWriter = new ClassWriter(1);
            classNode.accept((ClassVisitor)classWriter);
            return classWriter.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return classToTransform;
        }
    }

    private static void transformDefaultFramerate(ClassNode mainClass, boolean isObfuscated) {
        String CLASS_NAME = isObfuscated ? "func_90020_K" : "getLimitFramerate";
        String CLASS_DESC_OBF = "()I";
        for (MethodNode method : mainClass.methods) {
            if (!method.name.equals(CLASS_NAME) || !method.desc.equals("()I")) continue;
            AbstractInsnNode targetNode = null;
            for (AbstractInsnNode instruction : method.instructions.toArray()) {
                if (instruction.getOpcode() != 16) continue;
                targetNode = instruction;
                break;
            }
            if (targetNode == null) break;
            method.instructions.set(targetNode, (AbstractInsnNode)new MethodInsnNode(184, "de/pt400c/defaultsettings/EventHandlers", "getLimitFramerate", "()I", false));
            DefaultSettings.log.log(Level.INFO, "Transformed framerate method!");
            break;
        }
    }
}

