/*
 * Decompiled with CFR 0.152.
 */
package de.pt400c.defaultsettings.gui;

import de.pt400c.defaultsettings.DefaultSettings;
import de.pt400c.defaultsettings.FileUtil;
import de.pt400c.defaultsettings.GuiConfig;
import de.pt400c.defaultsettings.gui.ButtonSegment;
import de.pt400c.defaultsettings.gui.DefaultSettingsGUI;
import de.pt400c.defaultsettings.gui.IconSegment;
import de.pt400c.defaultsettings.gui.LeftMenu;
import de.pt400c.neptunefx.DrawString;
import de.pt400c.neptunefx.NEX;
import java.util.function.Function;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

@SideOnly(value=Side.CLIENT)
public class ButtonMenuSegment
extends ButtonSegment {
    public final int id;
    private boolean activated;
    private float offsetX = 0.0f;
    private float offsetTick = 0.0f;
    private final LeftMenu menu;
    private final float origLength;
    private final IconSegment icon;

    public ButtonMenuSegment(int id, GuiScreen gui, float posX, float posY, String title, Function<ButtonSegment, Boolean> function, LeftMenu menu, String icon) {
        super(gui, posX, posY, title, function, 50, 20, 2);
        this.id = id;
        this.menu = menu;
        this.origLength = 50.0f;
        this.icon = new IconSegment(gui, posX + 27.0f, posY + 27.0f - 2.0f, 16, 16, icon, this.menu);
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        float triple = (float)Math.sin(0.25 * (double)this.offsetTick);
        float func = triple * triple * triple * 6.0f;
        this.width = this.origLength - this.menu.offs * 1.6f;
        float percent = GuiConfig.clamp(this.menu.offsetTick / this.menu.maxOffTick, 0.0f, 1.0f);
        if (!(this.width < 3.5f)) {
            if ((this.isSelected(mouseX, mouseY) || this.activated) && (double)this.offsetTick < Math.PI * 2) {
                this.offsetTick = (float)((double)this.offsetTick + 0.4);
            } else if (this.offsetTick > 0.0f && !this.isSelected(mouseX, mouseY) && !this.activated) {
                this.offsetTick = (float)((double)this.offsetTick - 0.5);
            }
            this.offsetX = func;
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)0);
            NEX.drawButton(this.getPosX() + this.offsetX, this.getPosY(), this.getPosX() + this.offsetX + this.getWidth(), this.getPosY() + this.getHeight(), NEX.calcAlpha(this.getRenderColor((byte)(this.activated ? 2 : (this.isSelected(mouseX, mouseY) ? 1 : 0))), percent).getRGB(), NEX.calcAlpha(-2302756, percent).getRGB(), this.border);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3089);
            GL11.glEnable((int)3042);
            GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)0);
            ScaledResolution scaledResolution = DefaultSettings.is180 ? new ScaledResolution(FileUtil.MC, FileUtil.MC.field_71443_c, FileUtil.MC.field_71440_d) : new ScaledResolution(FileUtil.MC);
            int scaleFactor = scaledResolution.func_78325_e();
            GL11.glScissor((int)((int)((this.getPosX() + 2.0f + this.offsetX) * (float)scaleFactor)), (int)((int)(((float)scaledResolution.func_78328_b() - this.getPosY() - this.getHeight()) * (float)scaleFactor)), (int)((int)((this.getWidth() - 4.0f) * (float)scaleFactor)), (int)((int)(this.getHeight() * (float)scaleFactor)));
            DrawString.drawString(this.title, this.posX + this.offsetX + 3.0f, this.posY + this.getHeight() / 2.0f - 4.0f, NEX.calcAlpha(-12961222, percent).getRGB(), false);
            GL11.glDisable((int)3042);
            GL11.glDisable((int)3089);
            GL11.glPopMatrix();
        }
        int plus = this.activated ? 9 : 0;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.activated) {
            NEX.drawRect(this.posX + 29.0f + -25.0f * percent, this.posY, this.posX + 29.0f + 3.0f + -25.0f * percent, this.posY + 19.0f, NEX.calcAlpha(-31464, 1.0f - percent).getRGB(), true, null, false);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)percent);
        this.icon.customRender(mouseX, mouseY, (float)(-25 + plus) * percent, 0.0f, partialTicks);
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isSelected(mouseX, mouseY)) {
            this.grabbed = true;
            ((DefaultSettingsGUI)this.gui).resetSelected();
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseDragged(int mouseX, int mouseY, int button) {
        if (!this.isSelected(mouseX, mouseY)) {
            this.grabbed = false;
        }
        return super.mouseDragged(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseReleased(int mouseX, int mouseY, int button) {
        if (this.grabbed && this.isSelected(mouseX, mouseY)) {
            this.grabbed = false;
            if (((Boolean)this.function.apply(this)).booleanValue()) {
                this.setActive(Boolean.logicalXor(this.activated, true), false);
                this.clickSound();
            }
            return true;
        }
        return false;
    }

    public ButtonMenuSegment setActive(boolean active, boolean silent) {
        if (!silent && ((GuiConfig)this.gui).selectedSegment == this) {
            return this;
        }
        this.activated = active;
        ((GuiConfig)this.gui).changeSelected(this);
        return this;
    }

    @Override
    public boolean isSelected(int mouseX, int mouseY) {
        return ((GuiConfig)this.gui).popupField == null && (float)mouseX >= this.getPosX() && (float)mouseY >= this.getPosY() && (float)mouseX < this.getPosX() + this.offsetX + this.getWidth() && (float)mouseY < this.getPosY() + this.getHeight();
    }

    protected int getRenderColor(byte state) {
        switch (state) {
            case 1: {
                return -8750470;
            }
            case 2: {
                return -10658467;
            }
        }
        return -5987164;
    }
}

