/*
 * Decompiled with CFR 0.152.
 */
package de.pt400c.defaultsettings.gui;

import de.pt400c.defaultsettings.FileUtil;
import de.pt400c.defaultsettings.gui.DefaultSettingsGUI;
import de.pt400c.defaultsettings.gui.LeftMenu;
import de.pt400c.defaultsettings.gui.Segment;
import de.pt400c.neptunefx.DrawString;
import de.pt400c.neptunefx.NEX;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Function;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

@SideOnly(value=Side.CLIENT)
public class ButtonSegment
extends Segment {
    protected final Function<ButtonSegment, Boolean> function;
    private static final float BRIGHT_SCALE = 0.85f;
    public String title;
    public String hoverMessage = null;
    protected boolean grabbed;
    protected final int border;
    public int color = -5987164;
    private int bgDPLList = -1;
    private boolean compiled;

    public ButtonSegment(GuiScreen gui, float posX, float posY, String title, Function<ButtonSegment, Boolean> function, int width, int height, int border, String hoverMessage, LeftMenu menu, boolean popupSegment) {
        super(gui, posX, posY, width, height, popupSegment);
        this.title = title;
        this.function = function;
        this.border = border;
        this.hoverMessage = hoverMessage;
    }

    public ButtonSegment(GuiScreen gui, float posX, float posY, String title, Function<ButtonSegment, Boolean> function, int width, int height, int border, String hoverMessage, boolean popupSegment) {
        this(gui, posX, posY, title, function, width, height, border, hoverMessage, null, popupSegment);
    }

    public ButtonSegment(GuiScreen gui, float posX, float posY, String title, Function<ButtonSegment, Boolean> function, int width, int height, int border, String hoverMessage) {
        this(gui, posX, posY, title, function, width, height, border, hoverMessage, null, false);
    }

    public ButtonSegment(GuiScreen gui, float posX, float posY, String title, Function<ButtonSegment, Boolean> function, int width, int height, int border) {
        this(gui, posX, posY, title, function, width, height, border, null);
    }

    public ButtonSegment(GuiScreen gui, float posX, float posY, String title, Function<ButtonSegment, Boolean> function, int width, int height, int border, boolean popupSegment) {
        this(gui, posX, posY, title, function, width, height, border, null, popupSegment);
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        if (this.compiled) {
            GL11.glCallList((int)this.bgDPLList);
        } else {
            this.bgDPLList = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)this.bgDPLList, (int)4864);
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)772, (int)771);
            GL11.glShadeModel((int)7425);
            GL11.glDisable((int)3553);
            NEX.drawGradient(this.getPosX() + this.width - 2.0f, this.getPosY() + 2.0f, this.getPosX() + this.width + 5.0f, this.getPosY() + this.height - 2.0f, -16777216, 0x404040, 0);
            NEX.drawGradient(this.getPosX() - 5.0f, this.getPosY() + 2.0f, this.getPosX() + 2.0f, this.getPosY() + this.height - 2.0f, -16777216, 0x404040, 2);
            NEX.drawGradient(this.getPosX() + 2.0f, this.getPosY() - 5.0f, this.getPosX() + this.width - 2.0f, this.getPosY() + 2.0f, -16777216, 0x404040, 3);
            NEX.drawGradient(this.getPosX() + 2.0f, this.getPosY() + this.height - 2.0f, this.getPosX() + this.width - 2.0f, this.getPosY() + this.height + 5.0f, -16777216, 0x404040, 1);
            NEX.drawGradientCircle(this.getPosX() + 2.0f, this.getPosY() + 2.0f, 7.0f, 180.0f, 75, -16777216, 0x404040);
            NEX.drawGradientCircle(this.getPosX() + this.width - 2.0f, this.getPosY() + 2.0f, 7.0f, 270.0f, 75, -16777216, 0x404040);
            NEX.drawGradientCircle(this.getPosX() + this.width - 2.0f, this.getPosY() + this.height - 2.0f, 7.0f, 0.0f, 75, -16777216, 0x404040);
            NEX.drawGradientCircle(this.getPosX() + 2.0f, this.getPosY() + this.height - 2.0f, 7.0f, 90.0f, 75, -16777216, 0x404040);
            GL11.glEnable((int)3553);
            GL11.glShadeModel((int)7424);
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
            GL11.glEndList();
            this.compiled = true;
            GL11.glCallList((int)this.bgDPLList);
        }
        NEX.drawButton(this.getPosX(), this.getPosY(), this.getPosX() + this.getWidth(), this.getPosY() + this.getHeight(), this.isSelected(mouseX, mouseY) ? ButtonSegment.darkenColor(this.color).getRGB() : this.color, -2302756, this.border);
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        DrawString.drawString(this.title, this.posX + this.getWidth() / 2.0f - (float)(FileUtil.MC.field_71466_p.func_78256_a(this.title) / 2), this.posY + this.getHeight() / 2.0f - 4.0f, -12961222, false);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    @Override
    public boolean hoverCheck(int mouseX, int mouseY) {
        if (this.isSelected(mouseX, mouseY) && this.hoverMessage != null) {
            ArrayList<String> lines = new ArrayList<String>();
            int textWidth = mouseX + 12 + FileUtil.MC.field_71466_p.func_78256_a(this.hoverMessage);
            if (textWidth > this.gui.field_146294_l) {
                lines.addAll(FileUtil.MC.field_71466_p.func_78271_c(this.hoverMessage, this.gui.field_146294_l - mouseX - 12));
            } else {
                lines.add(this.hoverMessage);
            }
            textWidth = 0;
            for (String line : lines) {
                if (FileUtil.MC.field_71466_p.func_78256_a(line) <= textWidth) continue;
                textWidth = FileUtil.MC.field_71466_p.func_78256_a(line);
            }
            NEX.drawButton(mouseX + 6, mouseY - 7 - 10 * lines.size(), mouseX + 12 + textWidth, mouseY - 3, -12961222, -2302756, 2);
            int offset = 0;
            Collections.reverse(lines);
            for (String line : lines) {
                DrawString.drawString(line, mouseX + 9, mouseY - 14 - offset, -12961222, false);
                offset += 10;
            }
            return true;
        }
        return false;
    }

    protected static Color darkenColor(int color) {
        return new Color((int)((float)((color & 0xFF0000) >> 16) * 0.85f), (int)((float)((color & 0xFF00) >> 8) * 0.85f), (int)((float)(color & 0xFF) * 0.85f), 255);
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isSelected(mouseX, mouseY)) {
            this.grabbed = true;
            ((DefaultSettingsGUI)this.gui).resetSelected();
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseDragged(int mouseX, int mouseY, int button) {
        if (!this.isSelected(mouseX, mouseY)) {
            this.grabbed = false;
        }
        return super.mouseDragged(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseReleased(int mouseX, int mouseY, int button) {
        if (this.grabbed) {
            if (this.isSelected(mouseX, mouseY)) {
                this.grabbed = false;
            }
            if (this.function.apply(this).booleanValue()) {
                this.clickSound();
            }
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public Segment setPos(float x, float y) {
        this.compiled = false;
        return super.setPos(x, y);
    }
}

