/*
 * Decompiled with CFR 0.152.
 */
package de.pt400c.defaultsettings.gui;

import de.pt400c.defaultsettings.DefaultSettings;
import de.pt400c.defaultsettings.FileUtil;
import de.pt400c.defaultsettings.UpdateContainer;
import de.pt400c.defaultsettings.gui.ButtonSegment;
import de.pt400c.defaultsettings.gui.DefaultSettingsGUI;
import de.pt400c.defaultsettings.gui.LeftMenu;
import de.pt400c.neptunefx.DrawString;
import de.pt400c.neptunefx.NEX;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ButtonUpdateChecker
extends ButtonSegment {
    public float timer = 0.0f;
    private final LeftMenu menu;

    public ButtonUpdateChecker(GuiScreen gui, float posY, LeftMenu menu) {
        super(gui, 0.0f, posY, null, null, 20, 20, 2);
        this.menu = menu;
        if (DefaultSettings.getUpdater().getStatus() == UpdateContainer.Status.ERROR || DefaultSettings.getUpdater().getStatus() == UpdateContainer.Status.UNKNOWN) {
            DefaultSettings.getUpdater().update();
        }
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        this.timer = (float)((double)this.timer + 0.05);
        float right = this.menu.width - this.menu.offs + this.width + 6.0f;
        this.posX = right / 2.0f - this.width / 2.0f;
        float darken = (float)((Math.sin((double)this.timer - 1.5707963267948966) + 1.0) / 4.0 + 0.5);
        NEX.drawButton(this.getPosX(), this.getPosY(), this.getPosX() + this.getWidth(), this.getPosY() + this.getHeight(), this.isSelected(mouseX, mouseY) ? ButtonUpdateChecker.darkenColor(this.color).getRGB() : this.color, ButtonUpdateChecker.statusToColor(DefaultSettings.getUpdater().getStatus(), darken), this.border);
    }

    @Override
    public boolean hoverCheck(int mouseX, int mouseY) {
        String text = ButtonUpdateChecker.statusToIdentifier(DefaultSettings.getUpdater().getStatus());
        if (this.isSelected(mouseX, mouseY) && text != null) {
            ArrayList lines = new ArrayList();
            int textWidth = 0;
            lines.addAll(FileUtil.MC.field_71466_p.func_78271_c(text, this.gui.field_146294_l - mouseX - 12));
            for (String line : lines) {
                if (FileUtil.MC.field_71466_p.func_78256_a(line) <= textWidth) continue;
                textWidth = FileUtil.MC.field_71466_p.func_78256_a(line);
            }
            NEX.drawButton(mouseX + 6, mouseY - 7 - 10 * lines.size(), mouseX + 12 + textWidth, mouseY - 3, -12961222, -2302756, 2);
            int offset = 0;
            Collections.reverse(lines);
            for (String line : lines) {
                DrawString.drawString(line, mouseX + 9, mouseY - 14 - offset, -12961222, false);
                offset += 10;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isSelected(mouseX, mouseY)) {
            this.grabbed = true;
            ((DefaultSettingsGUI)this.gui).resetSelected();
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseDragged(int mouseX, int mouseY, int button) {
        if (!this.isSelected(mouseX, mouseY)) {
            this.grabbed = false;
        }
        return super.mouseDragged(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseReleased(int mouseX, int mouseY, int button) {
        if (this.grabbed && this.isSelected(mouseX, mouseY)) {
            this.grabbed = false;
            DefaultSettings.getUpdater().update();
            this.clickSound();
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public static String statusToIdentifier(UpdateContainer.Status status) {
        switch (status) {
            case CHECKING: {
                return "Checking ...";
            }
            case OUTDATED: {
                return String.format("Your mod's version is outdated\nPlease update to %s", DefaultSettings.getUpdater().getOnlineVersion());
            }
            case AHEAD_OF_TIME: {
                return "Heck, you're ahead of reality?!";
            }
            case UP_TO_DATE: {
                return "Up to date";
            }
        }
        return "Something went wrong :(\nWe couldn't check if your\ninstallation is up-to-date";
    }

    public static int statusToColor(UpdateContainer.Status status, float darken) {
        switch (status) {
            case CHECKING: {
                return NEX.darkenColor(-3158065, darken).getRGB();
            }
            case OUTDATED: {
                return -676831;
            }
            case AHEAD_OF_TIME: {
                return -16218954;
            }
            case UP_TO_DATE: {
                return -9898719;
            }
        }
        return -777456;
    }
}

