/*
 * Decompiled with CFR 0.152.
 */
package de.pt400c.defaultsettings.gui;

import de.pt400c.defaultsettings.FileUtil;
import de.pt400c.defaultsettings.gui.DefaultSettingsGUI;
import de.pt400c.defaultsettings.gui.Segment;
import de.pt400c.neptunefx.DrawString;
import de.pt400c.neptunefx.NEX;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

@SideOnly(value=Side.CLIENT)
public class DeleteSegment
extends Segment {
    private final ResourceLocation icon = new ResourceLocation("defaultsettings", "textures/gui/trash.png");
    final int id;
    private boolean grabbed;
    private boolean visible;
    private float timer;

    public DeleteSegment(GuiScreen gui, float posX, float posY, int width, int height, int id) {
        super(gui, posX, posY, width, height, false);
        this.id = id;
    }

    @Override
    public boolean isSelected(int mouseX, int mouseY) {
        return (((DefaultSettingsGUI)this.gui).popupField == null || this.getIsPopupSegment()) && NEX.distanceBetweenPoints(this.posX, this.posY, mouseX, mouseY) <= 11.0f;
    }

    @Override
    public boolean hoverCheck(int mouseX, int mouseY) {
        if (this.isSelected(mouseX, mouseY) && this.visible) {
            String message = "Delete this saved entry";
            ArrayList<String> lines = new ArrayList<String>();
            int textWidth = mouseX + 12 + FileUtil.MC.field_71466_p.func_78256_a("Delete this saved entry");
            if (textWidth > this.gui.field_146294_l) {
                lines.addAll(FileUtil.MC.field_71466_p.func_78271_c("Delete this saved entry", this.gui.field_146294_l - mouseX - 12));
            } else {
                lines.add("Delete this saved entry");
            }
            textWidth = 0;
            for (String line : lines) {
                if (FileUtil.MC.field_71466_p.func_78256_a(line) <= textWidth) continue;
                textWidth = FileUtil.MC.field_71466_p.func_78256_a(line);
            }
            NEX.drawButton(mouseX + 6, mouseY - 7 - 10 * lines.size(), mouseX + 12 + textWidth, mouseY - 3, -12961222, -2302756, 2);
            int offset = 0;
            Collections.reverse(lines);
            for (String line : lines) {
                DrawString.drawString(line, mouseX + 9, mouseY - 14 - offset, -12961222, false);
                offset += 10;
            }
            return true;
        }
        return false;
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        this.visible = true;
        if (this.id == 0 && !FileUtil.keys_exists) {
            this.visible = false;
        }
        if (this.id == 1 && !FileUtil.options_exists) {
            this.visible = false;
        }
        if (this.id == 2 && !FileUtil.servers_exists) {
            this.visible = false;
        }
        if (this.visible) {
            if ((double)this.timer <= 1.0471975511965976) {
                this.timer = (float)((double)this.timer + 0.05);
            }
        } else if (this.timer > 0.0f) {
            this.timer = (float)((double)this.timer - 0.05);
        }
        if (this.timer <= 0.0f) {
            return;
        }
        float alpha = (float)((Math.sin((double)(3.0f * this.timer) - 4.71238898038469) + 1.0) / 2.0);
        GL11.glPushMatrix();
        int color = this.isSelected(mouseX, mouseY) ? -4313556 : -2599083;
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3008);
        GL11.glShadeModel((int)7425);
        NEX.drawGradientCircle(this.posX + 2.5f, this.posY + 2.5f, 13.0f, 0.0f, 0, NEX.calcAlpha(-16777216, alpha).getRGB(), 0);
        GL11.glShadeModel((int)7424);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        NEX.drawCircle(this.posX, this.posY, this.width / 2.0f, 0.0f, 0);
        GlStateManager.func_179131_c((float)f, (float)f1, (float)f2, (float)(f3 - alpha));
        NEX.drawCircle(this.posX, this.posY, this.width / 2.0f, 0.0f, 0);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - alpha));
        FileUtil.MC.func_110434_K().func_110577_a(this.icon);
        NEX.drawScaledTex(this.posX - 9.5f, this.posY - 9.5f, (int)this.width, (int)this.height);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isSelected(mouseX, mouseY) && this.visible) {
            this.grabbed = true;
            ((DefaultSettingsGUI)this.gui).resetSelected();
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseDragged(int mouseX, int mouseY, int button) {
        if (!this.isSelected(mouseX, mouseY) && this.visible) {
            this.grabbed = false;
        }
        return super.mouseDragged(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseReleased(int mouseX, int mouseY, int button) {
        if (this.grabbed) {
            if (this.isSelected(mouseX, mouseY) && this.visible) {
                this.grabbed = false;
            }
            if (this.id == 0) {
                FileUtil.deleteKeys();
            } else if (this.id == 1) {
                FileUtil.deleteOptions();
            } else if (this.id == 2) {
                FileUtil.deleteServers();
            }
            this.clickSound();
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }
}

