/*
 * Decompiled with CFR 0.152.
 */
package de.pt400c.defaultsettings.gui;

import de.pt400c.defaultsettings.FileUtil;
import de.pt400c.defaultsettings.GuiConfig;
import de.pt400c.defaultsettings.gui.DefaultSettingsGUI;
import de.pt400c.defaultsettings.gui.Segment;
import de.pt400c.neptunefx.DrawString;
import de.pt400c.neptunefx.NEX;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ExportSwitchSegment
extends Segment {
    private final String hoverMessage = "Switch Export Mode for the modpack";
    protected boolean grabbed;
    public float animTimer = 0.0f;
    private float processFactor;
    public float flickerTimer = 0.0f;

    public ExportSwitchSegment(GuiScreen gui, float posX, float posY) {
        super(gui, posX, posY, 30.0f, 15.0f, false);
    }

    @Override
    public boolean isSelected(int mouseX, int mouseY) {
        return super.isSelected(mouseX, mouseY) || NEX.distanceBetweenPoints(this.getPosX() + 28.0f * (1.0f - this.processFactor), this.getPosY() + 7.0f, mouseX, mouseY) <= 9.4f;
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        DrawString.drawString("Export Mode:", this.getPosX() - 77.0f, this.getPosY() + 3.0f, -10658467, false);
        int on = -16207098;
        int off = -2599083;
        float darken = 0.0f;
        byte exportActive = ((GuiConfig)this.gui).menu.exportActive.getByte();
        boolean inactive = false;
        if (exportActive == 2) {
            if ((double)this.animTimer <= 1.0471975511965976) {
                this.animTimer = (float)((double)this.animTimer + 0.05);
            }
        } else if (exportActive == 1) {
            if (this.animTimer > 0.0f) {
                this.animTimer = (float)((double)this.animTimer - 0.05);
            }
        } else {
            inactive = true;
            this.flickerTimer = (float)((double)this.flickerTimer + 0.05);
            darken = (float)((Math.sin((double)this.flickerTimer - 1.5707963267948966) + 1.0) / 4.0 + 0.5);
        }
        int getRed = NEX.getRed(on);
        int getGreen = NEX.getGreen(on);
        int getBlue = NEX.getBlue(on);
        this.processFactor = (float)((Math.sin((double)(3.0f * this.animTimer) - 1.5707963267948966) + 1.0) / 2.0);
        float red = (float)(NEX.getRed(-2599083) - getRed) * (1.0f - this.processFactor);
        float green = (float)(NEX.getGreen(-2599083) - getGreen) * (1.0f - this.processFactor);
        float blue = (float)(NEX.getBlue(-2599083) - getBlue) * (1.0f - this.processFactor);
        on = new Color((int)((float)getRed + red), (int)((float)getGreen + green), (int)((float)getBlue + blue)).getRGB();
        if (inactive) {
            on = NEX.darkenColor(-10790053, darken).getRGB();
        }
        float f3 = (float)(on >> 24 & 0xFF) / 255.0f;
        float f = (float)(on >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(on >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(on & 0xFF) / 255.0f;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        float radius = 7.0f;
        GL11.glColor4f((float)f, (float)f1, (float)f2, (float)f3);
        NEX.drawCircle(this.getPosX() + 7.0f, this.getPosY() + 7.0f, radius, 90.0f, 50);
        NEX.drawCircle(this.getPosX() + 15.0f + 7.0f, this.getPosY() + 7.0f, radius, 270.0f, 50);
        NEX.drawRect(this.getPosX() + 7.0f, this.getPosY(), this.getPosX() + 7.0f + 15.0f, this.getPosY() + 14.0f, null, false, null, false);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        if (!inactive) {
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glScalef((float)0.65f, (float)0.65f, (float)0.65f);
            DrawString.drawString("ON", this.getPosX() + 110.0f, this.getPosY() + 11.0f, new Color(255, 255, 255, (int)GuiConfig.clamp(255.0f * this.processFactor, 4.0f, 255.0f)).getRGB(), false);
            DrawString.drawString("OFF", this.getPosX() + 95.0f, this.getPosY() + 11.0f, new Color(255, 255, 255, (int)GuiConfig.clamp(255.0f * (1.0f - this.processFactor), 4.0f, 255.0f)).getRGB(), false);
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
        }
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        radius = 9.4f;
        GL11.glColor3f((float)0.5f, (float)0.5f, (float)0.5f);
        NEX.drawCircle(this.getPosX() + 28.0f * (1.0f - this.processFactor), this.getPosY() + 7.0f, radius, 0.0f, 0);
        radius = 8.5f;
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        NEX.drawCircle(this.getPosX() + 28.0f * (1.0f - this.processFactor), this.getPosY() + 7.0f, radius, 0.0f, 0);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    @Override
    public boolean hoverCheck(int mouseX, int mouseY) {
        if (this.isSelected(mouseX, mouseY) && this.hoverMessage != null) {
            ArrayList<String> lines = new ArrayList<String>();
            int textWidth = mouseX + 14 + FileUtil.MC.field_71466_p.func_78256_a(this.hoverMessage);
            if (textWidth > this.gui.field_146294_l) {
                lines.addAll(FileUtil.MC.field_71466_p.func_78271_c(this.hoverMessage, this.gui.field_146294_l - mouseX - 14));
            } else {
                lines.add(this.hoverMessage);
            }
            textWidth = 0;
            for (String line : lines) {
                if (FileUtil.MC.field_71466_p.func_78256_a(line) <= textWidth) continue;
                textWidth = FileUtil.MC.field_71466_p.func_78256_a(line);
            }
            NEX.drawButton(mouseX + 8, mouseY + 7, mouseX + 14 + textWidth, mouseY + 11 + 10 * lines.size(), -12961222, -2302756, 2);
            int offset = 0;
            for (String line : lines) {
                DrawString.drawString(line, mouseX + 11, mouseY + 10 - offset, -12961222, false);
                offset -= 10;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isSelected(mouseX, mouseY)) {
            this.grabbed = true;
            ((DefaultSettingsGUI)this.gui).resetSelected();
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseDragged(int mouseX, int mouseY, int button) {
        if (!this.isSelected(mouseX, mouseY)) {
            this.grabbed = false;
        }
        return super.mouseDragged(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseReleased(int mouseX, int mouseY, int button) {
        if (this.grabbed) {
            if (this.isSelected(mouseX, mouseY)) {
                this.grabbed = false;
            }
            this.clickSound();
            byte exportActive = ((GuiConfig)this.gui).menu.exportActive.getByte();
            if (exportActive == 2) {
                ((GuiConfig)this.gui).copyConfigs();
            } else if (exportActive == 1) {
                ((GuiConfig)this.gui).deleteConfigs();
            }
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }
}

