/*
 * Decompiled with CFR 0.152.
 */
package de.pt400c.defaultsettings.gui;

import de.pt400c.defaultsettings.FileUtil;
import de.pt400c.defaultsettings.GuiConfig;
import de.pt400c.defaultsettings.gui.Segment;
import de.pt400c.neptunefx.DrawString;
import de.pt400c.neptunefx.NEX;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

@SideOnly(value=Side.CLIENT)
public class PopupWindow
extends Segment {
    private List<Segment> children = new ArrayList<Segment>();
    public String title;
    public volatile boolean cleanup;
    private boolean dragging;
    private float distanceX = 0.0f;
    private float distanceY = 0.0f;
    private int bgDPLList = -1;
    private boolean compiled;

    public PopupWindow(GuiScreen gui, float posX, float posY, float width, float height, String title) {
        super(gui, posX, posY, width, height, true);
        this.title = title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        this.compiled = false;
        GL11.glDeleteLists((int)this.bgDPLList, (int)1);
        if (this.compiled) {
            GL11.glCallList((int)this.bgDPLList);
        } else {
            this.bgDPLList = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)this.bgDPLList, (int)4864);
            GL11.glEnable((int)3042);
            GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)0);
            GL11.glDisable((int)3008);
            GL11.glShadeModel((int)7425);
            GL11.glDisable((int)3553);
            NEX.drawGradient(this.getPosX() + this.width - 10.0f, this.getPosY() + 10.0f, this.getPosX() + this.width + 5.0f, this.getPosY() + this.height - 10.0f, -16777216, 0x101010, 0);
            NEX.drawGradient(this.getPosX() - 5.0f, this.getPosY() + 10.0f, this.getPosX() + 10.0f, this.getPosY() + this.height - 10.0f, -16777216, 0x101010, 2);
            NEX.drawGradient(this.getPosX() + 10.0f, this.getPosY() - 5.0f, this.getPosX() + this.width - 10.0f, this.getPosY() + 10.0f, -16777216, 0x101010, 3);
            NEX.drawGradient(this.getPosX() + 10.0f, this.getPosY() + this.height - 10.0f, this.getPosX() + this.width - 10.0f, this.getPosY() + this.height + 5.0f, -16777216, 0x101010, 1);
            NEX.drawGradientCircle(this.getPosX() + 10.0f, this.getPosY() + 10.0f, 15.0f, 180.0f, 75, -16777216, 0x101010);
            NEX.drawGradientCircle(this.getPosX() + this.width - 10.0f, this.getPosY() + 10.0f, 15.0f, 270.0f, 75, -16777216, 0x101010);
            NEX.drawGradientCircle(this.getPosX() + this.width - 10.0f, this.getPosY() + this.height - 10.0f, 15.0f, 0.0f, 75, -16777216, 0x101010);
            NEX.drawGradientCircle(this.getPosX() + 10.0f, this.getPosY() + this.height - 10.0f, 15.0f, 90.0f, 75, -16777216, 0x101010);
            GL11.glEnable((int)3553);
            GL11.glShadeModel((int)7424);
            GL11.glEnable((int)3008);
            GL11.glDisable((int)3042);
            NEX.drawRectRoundedUpper(this.posX, this.posY, this.posX + this.width, this.posY + 24.0f, -7631989);
            NEX.drawRectRoundedLower(this.posX, this.posY + 24.0f, this.posX + this.width, this.posY + this.height, -263173);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)772, (int)771);
            GL11.glDisable((int)3008);
            GL11.glShadeModel((int)7425);
            GL11.glDisable((int)3553);
            NEX.drawGradient(this.getPosX(), this.getPosY() + 24.0f, this.getPosX() + this.width, this.getPosY() + 24.0f + 5.0f, -10461088, 0x404040, 1);
            GL11.glEnable((int)3553);
            GL11.glShadeModel((int)7424);
            GL11.glEnable((int)3008);
            GL11.glDisable((int)3042);
            DrawString.drawString(this.title, this.getPosX() + this.getWidth() / 2.0f + 1.0f - (float)(FileUtil.MC.field_71466_p.func_78256_a(this.title) / 2), this.getPosY() + 9.0f, -15000805, false);
            GL11.glEndList();
            this.compiled = true;
            GL11.glCallList((int)this.bgDPLList);
        }
        List<Segment> list = this.children;
        synchronized (list) {
            this.children.forEach(segment -> segment.render(mouseX, mouseY, partialTicks));
            this.children.forEach(segment -> segment.hoverCheck(mouseX, mouseY));
        }
        if (this.dragging) {
            float origX = this.posX;
            float origY = this.posY;
            this.posX = (float)mouseX - this.distanceX;
            this.posY = (float)mouseY - this.distanceY;
            if (this.posX - origX == 0.0f && this.posY - origY == 0.0f) {
                return;
            }
            this.compiled = false;
            GL11.glDeleteLists((int)this.bgDPLList, (int)1);
            this.children.forEach(segment -> segment.setPos(segment.posX + (this.posX - origX), segment.posY + (this.posY - origY)));
        }
    }

    public boolean isSelectedLower(int mouseX, int mouseY) {
        return (float)mouseX >= this.getPosX() && (float)mouseY >= this.getPosY() + 10.0f && (float)mouseX < this.getPosX() + this.getWidth() && (float)mouseY < this.getPosY() + this.height || (float)mouseX >= this.getPosX() + 10.0f && (float)mouseY >= this.getPosY() && (float)mouseX < this.getPosX() + this.getWidth() - 10.0f && (float)mouseY < this.getPosY() + 10.0f || NEX.distanceBetweenPoints(this.getPosX() + 10.0f, this.getPosY() + 10.0f, mouseX, mouseY) <= 10.0f || NEX.distanceBetweenPoints(this.getPosX() + this.getWidth() - 10.0f, this.getPosY() + 10.0f, mouseX, mouseY) <= 10.0f;
    }

    @Override
    public boolean isSelected(int mouseX, int mouseY) {
        return (float)mouseX >= this.getPosX() && (float)mouseY >= this.getPosY() + 10.0f && (float)mouseX < this.getPosX() + this.getWidth() && (float)mouseY < this.getPosY() + 24.0f || (float)mouseX >= this.getPosX() + 10.0f && (float)mouseY >= this.getPosY() && (float)mouseX < this.getPosX() + this.getWidth() - 10.0f && (float)mouseY < this.getPosY() + 10.0f || NEX.distanceBetweenPoints(this.getPosX() + 10.0f, this.getPosY() + 10.0f, mouseX, mouseY) <= 10.0f || NEX.distanceBetweenPoints(this.getPosX() + this.getWidth() - 10.0f, this.getPosY() + 10.0f, mouseX, mouseY) <= 10.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (!this.isSelectedLower(mouseX, mouseY)) {
            ((GuiConfig)this.gui).popupField.setOpening(false);
        }
        List<Segment> list = this.children;
        synchronized (list) {
            for (Segment segment : this.children) {
                if (!segment.mouseClicked(mouseX, mouseY, mouseButton)) continue;
                return true;
            }
        }
        if (this.isSelected(mouseX, mouseY)) {
            this.dragging = true;
            this.distanceX = (float)mouseX - this.posX;
            this.distanceY = (float)mouseY - this.posY;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean mouseDragged(int p_mouseDragged_1_, int p_mouseDragged_3_, int p_mouseDragged_5_) {
        List<Segment> list = this.children;
        synchronized (list) {
            for (Segment segment : this.children) {
                if (segment.mouseDragged(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_)) break;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean mouseReleased(int p_mouseReleased_1_, int p_mouseReleased_3_, int p_mouseReleased_5_) {
        List<Segment> list = this.children;
        synchronized (list) {
            for (Segment segment : this.children) {
                if (!segment.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_)) continue;
                return true;
            }
        }
        this.dragging = false;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PopupWindow addChild(Segment segment) {
        List<Segment> list = this.children;
        synchronized (list) {
            this.children.add(segment.setPos(this.posX + segment.posX, this.posY + segment.posY));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearChildren() {
        this.cleanup = true;
        List<Segment> list = this.children;
        synchronized (list) {
            this.children.clear();
        }
    }

    public List<Segment> getChildren() {
        return this.children;
    }
}

