/*
 * Decompiled with CFR 0.152.
 */
package de.pt400c.defaultsettings.gui;

import de.pt400c.defaultsettings.DefaultSettings;
import de.pt400c.defaultsettings.FileUtil;
import de.pt400c.defaultsettings.gui.ButtonBulkActionSegment;
import de.pt400c.defaultsettings.gui.ButtonCheckboxSegment;
import de.pt400c.defaultsettings.gui.DefaultSettingsGUI;
import de.pt400c.defaultsettings.gui.RowItem;
import de.pt400c.defaultsettings.gui.ScrollbarSegment;
import de.pt400c.defaultsettings.gui.SearchbarSegment;
import de.pt400c.defaultsettings.gui.Segment;
import de.pt400c.defaultsettings.gui.SettingsButtonSegment;
import de.pt400c.neptunefx.DrawString;
import de.pt400c.neptunefx.NEX;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

@SideOnly(value=Side.CLIENT)
public class ScrollableSegment
extends Segment {
    protected boolean grabbed;
    protected int add = 0;
    protected byte cache_activity;
    public List<RowItem> list = new ArrayList<RowItem>();
    private boolean invisible;
    private final ScrollbarSegment scrollBar;
    private final ButtonBulkActionSegment bulkAction;
    public final SearchbarSegment searchbar;
    private float distanceY = 0.0f;
    private int maxSize = 0;
    private final byte id;
    private float velocity = 0.0f;
    private int bgDPLList = -1;
    private boolean compiled;

    public ScrollableSegment(GuiScreen gui, float posX, float posY, int width, int height, byte id) {
        super(gui, posX, posY, width, height, false);
        this.scrollBar = new ScrollbarSegment(this.gui, posX + (float)width, posY, 10, 20, this);
        this.id = id;
        this.list = this.getRowList(null);
        this.bulkAction = new ButtonBulkActionSegment(this.gui, posX + 82.0f, posY + 5.0f, 6, 6, this);
        this.searchbar = new SearchbarSegment(gui, posX + 112.0f, posY - 1.0f, 45, 18, false, this);
    }

    @Override
    public void init() {
        this.list = this.getRowList(null);
    }

    public List<RowItem> getRowList(final String[] arg) {
        this.add = 0;
        switch (this.id) {
            case 0: {
                ArrayList<RowItem> rows = new ArrayList<RowItem>();
                File fileDir = new File(FileUtil.mcDataDir, "config");
                FileFilter ff = null;
                ff = arg != null && arg.length != 0 ? new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return !file.getName().equals("defaultsettings") && !file.getName().equals("defaultsettings.json") && !file.getName().equals("ds_dont_export.json") && !file.getName().equals("keys.txt") && !file.getName().equals("options.txt") && !file.getName().equals("optionsof.txt") && !file.getName().equals("servers.dat") && file.getName().toLowerCase().startsWith(arg[0].toLowerCase());
                    }
                } : FileUtil.fileFilter;
                File[] files = fileDir.listFiles(ff);
                int activeCount = 0;
                for (int i = 0; i < files.length; ++i) {
                    int yOffTemp = 18 + 20 * i + this.add;
                    boolean active = FileUtil.getActives().contains(files[i].getName());
                    if (active) {
                        ++activeCount;
                    }
                    rows.add(new RowItem(files[i].getName(), new ButtonCheckboxSegment(this.gui, 102.0f, yOffTemp + 43, 6, 6, files[i].getName(), false, this, i, active), new SettingsButtonSegment(this.gui, i, this.getWidth() + this.posX - 12.0f, yOffTemp + 43, files[i].getName(), this, FileUtil.getOverrides().containsKey(files[i].getName()))));
                }
                this.cache_activity = rows.size() != 0 && activeCount == files.length ? (byte)2 : (activeCount > 0 ? (byte)1 : 0);
                return rows;
            }
        }
        return new ArrayList<RowItem>();
    }

    @Override
    public void initSegment() {
        this.compiled = false;
        super.initSegment();
    }

    @Override
    public boolean handleMouseInput() {
        float scroll = Mouse.getEventDWheel();
        this.maxSize = 18 + 20 * (this.list.size() - 1);
        if (!this.invisible) {
            this.velocity += scroll / 120.0f;
        }
        return true;
    }

    @Override
    public void guiContentUpdate(final String ... arg) {
        FileFilter ff = null;
        File fileDir = new File(FileUtil.mcDataDir, "config");
        ff = arg != null && arg.length != 0 ? new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.getName().equals("defaultsettings") && !file.getName().equals("defaultsettings.json") && !file.getName().equals("ds_dont_export.json") && !file.getName().equals("keys.txt") && !file.getName().equals("options.txt") && !file.getName().equals("optionsof.txt") && !file.getName().equals("servers.dat") && file.getName().toLowerCase().startsWith(arg[0].toLowerCase());
            }
        } : FileUtil.fileFilter;
        File[] files = fileDir.listFiles(ff);
        if (files.length != this.list.size()) {
            this.list = this.getRowList(arg);
            this.compiled = false;
        }
    }

    @Override
    public boolean hoverCheck(int mouseX, int mouseY) {
        float offX = this.getWidth() + 58.0f;
        float offY = 53.0f;
        float tempHeight = this.getHeight() + 2.0f;
        float tempWidth = 35.0f;
        if ((float)mouseX >= offX && (float)mouseY >= 53.0f && (float)mouseX < offX + 35.0f && (float)mouseY < 53.0f + tempHeight) {
            for (int i = 0; i < this.list.size(); ++i) {
                int yOffTemp = 18 + 20 * i + this.add;
                if (yOffTemp < -3) continue;
                if ((float)yOffTemp > this.height + 18.0f) break;
                for (Segment segment : this.list.get((int)i).childs) {
                    if (!segment.hoverCheck(mouseX, mouseY)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        this.add += (int)this.velocity;
        if (this.add > 0) {
            this.add = 0;
            this.velocity = 0.0f;
        }
        if (this.add < 0) {
            int fix;
            int yOff = this.maxSize + this.add;
            int movable = (int)(this.getPosY() + (float)yOff);
            if (movable < (fix = (int)(this.getPosY() + this.height - 1.0f))) {
                int tempAdd = (int)(this.getPosY() + this.height - 1.0f - (float)(20 * (this.list.size() - 1)) - this.getPosY() - 18.0f);
                this.velocity = 0.0f;
                this.add = tempAdd;
            }
        }
        if (this.velocity > 0.0f) {
            this.velocity -= 1.0f;
            if (this.velocity - 1.0f == 0.0f) {
                this.velocity -= 1.0f;
            }
        } else if (this.velocity < 0.0f) {
            this.velocity += 1.0f;
            if (this.velocity + 1.0f == 0.0f) {
                this.velocity += 1.0f;
            }
        }
        this.maxSize = 18 + 20 * (this.list.size() - 1);
        int color = -8289919;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        float f3 = 1.0f;
        float f = 0.5058824f;
        float f1 = 0.5058824f;
        float f2 = 0.5058824f;
        this.invisible = (float)this.maxSize <= this.height;
        GL11.glColor4f((float)0.5058824f, (float)0.5058824f, (float)0.5058824f, (float)1.0f);
        if (this.compiled) {
            GL11.glCallList((int)this.bgDPLList);
        } else {
            this.bgDPLList = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)this.bgDPLList, (int)4864);
            NEX.drawCircle(this.getPosX(), this.getPosY(), 5.0f, 180.0f, 75);
            NEX.drawCircle(this.getPosX(), this.getPosY() + this.height, 5.0f, 90.0f, 75);
            NEX.drawCircle(this.getPosX() + (this.invisible ? this.width : this.width + this.scrollBar.getWidth()), this.getPosY() + this.height, 5.0f, 0.0f, 75);
            NEX.drawCircle(this.getPosX() + (this.invisible ? this.width : this.width + this.scrollBar.getWidth()), this.getPosY(), 5.0f, 270.0f, 75);
            NEX.drawRect(this.getPosX(), this.getPosY() - 5.0f, this.getPosX() + this.width + (!this.invisible ? this.scrollBar.getWidth() : 0.0f), this.getPosY() + this.height + 5.0f, null, false, null, false);
            NEX.drawRect(this.getPosX(), this.getPosY(), this.getPosX() + this.width + (!this.invisible ? this.scrollBar.getWidth() : 0.0f), this.getPosY() + this.height, -10790053, false, null, false);
            GL11.glColor4f((float)0.5058824f, (float)0.5058824f, (float)0.5058824f, (float)1.0f);
            NEX.drawRect(this.getPosX() + this.width + (!this.invisible ? this.scrollBar.getWidth() : 0.0f), this.getPosY(), this.getPosX() + this.width + 5.0f + (!this.invisible ? this.scrollBar.getWidth() : 0.0f), this.getPosY() + this.height, null, false, null, false);
            NEX.drawRect(this.getPosX() - 5.0f, this.getPosY(), this.getPosX(), this.getPosY() + this.height, null, false, null, false);
            GL11.glEndList();
            this.compiled = true;
            GL11.glCallList((int)this.bgDPLList);
        }
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3553);
        if (!this.invisible) {
            GL11.glDisable((int)3553);
            GL11.glEnable((int)3042);
            GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)0);
            GL11.glShadeModel((int)7425);
            NEX.drawGradient(this.getPosX() + this.width, this.getPosY(), this.getPosX() + this.width + this.scrollBar.getWidth(), this.getPosY() + 6.0f, -13027015, 0x373737, 1);
            NEX.drawGradient(this.getPosX() + this.width, this.getPosY() + this.height, this.getPosX() + this.width + this.scrollBar.getWidth(), this.getPosY() + this.height - 6.0f, -13027015, 0x373737, 3);
            GL11.glShadeModel((int)7424);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3553);
        }
        NEX.drawRect(this.getPosX(), this.getPosY(), this.getPosX() + this.getWidth(), this.getPosY() + this.getHeight(), -2039584, true, null, false);
        if (this.grabbed) {
            if (this.invisible) {
                this.distanceY = 0.0f;
            } else {
                int factor = (int)((float)mouseY - this.distanceY);
                if (factor > 0) {
                    factor = 0;
                }
                if (factor < 0) {
                    int fix;
                    int yOff = this.maxSize + factor;
                    int movable = (int)(this.getPosY() + (float)yOff);
                    if (movable < (fix = (int)(this.getPosY() + this.height - 1.0f))) {
                        int tempAdd;
                        factor = tempAdd = (int)(this.getPosY() + this.height - 1.0f - (float)(20 * (this.list.size() - 1)) - this.getPosY() - 18.0f);
                    }
                }
                this.add = factor;
            }
        } else {
            this.distanceY = 0.0f;
        }
        ScaledResolution scaledResolution = DefaultSettings.is180 ? new ScaledResolution(FileUtil.MC, FileUtil.MC.field_71443_c, FileUtil.MC.field_71440_d) : new ScaledResolution(FileUtil.MC);
        int scaleFactor = scaledResolution.func_78325_e();
        GL11.glPushMatrix();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((int)(this.getPosX() * (float)scaleFactor)), (int)((int)(((float)scaledResolution.func_78328_b() - this.getPosY() - this.getHeight() + 0.5f) * (float)scaleFactor)), (int)((int)(this.getWidth() * (float)scaleFactor)), (int)((int)((this.getHeight() - 1.0f) * (float)scaleFactor)));
        for (int i = 0; i < this.list.size(); ++i) {
            int yOffTemp = 18 + 20 * i + this.add;
            if (yOffTemp < -3) continue;
            if ((float)yOffTemp > this.height + 18.0f) break;
            String text = this.list.get((int)i).displayString;
            int dots = FileUtil.MC.field_71466_p.func_78256_a("...");
            int widthString = FileUtil.MC.field_71466_p.func_78256_a(text);
            SettingsButtonSegment button = (SettingsButtonSegment)this.list.get((int)i).childs[1];
            float f4 = widthString;
            int n = button.mark ? 55 : 40;
            if (f4 >= this.width - (float)n) {
                DrawString.drawString(FileUtil.MC.field_71466_p.func_78269_a(text, (int)(this.width - (float)(button.mark ? 55 : 40) - 1.0f - (float)dots)) + "...", (int)this.getPosX() + 23, (int)this.getPosY() + yOffTemp - 13, 0, false);
            } else {
                DrawString.drawString(text, (int)this.getPosX() + 23, (int)this.getPosY() + yOffTemp - 13, 0, false);
            }
            for (Segment segment : this.list.get((int)i).childs) {
                segment.customRender(mouseX, mouseY, 0.0f, this.add, partialTicks);
            }
            if (i != this.list.size() - 1) {
                NEX.drawRect(this.getPosX(), this.getPosY() + (float)yOffTemp, this.getPosX() + this.getWidth(), this.getPosY() + (float)yOffTemp + 2.0f, -13158601, true, null, false);
                continue;
            }
            NEX.drawRect(this.getPosX(), this.getPosY() + (float)(this.maxSize + this.add), this.getPosX() + this.getWidth(), this.getPosY() + (float)(this.maxSize + this.add) + 1.0f, -13158601, true, null, false);
        }
        GL11.glDisable((int)3089);
        GL11.glPopMatrix();
        float percentHeight = this.height / (float)this.maxSize;
        this.scrollBar.height = ScrollableSegment.clamp(this.height * percentHeight, 5.0f, 2.1474836E9f);
        int first = (int)((float)this.maxSize - this.height + 1.0f);
        int second = -this.add;
        boolean active = true;
        if (first > second) {
            active = false;
        }
        float posPercentage = -((float)this.add) / ((float)this.maxSize - this.height + (float)(active ? 1 : -1));
        this.scrollBar.setPos(this.posX + this.width, this.posY + (this.height - this.scrollBar.height) * posPercentage);
        NEX.drawRect(this.getPosX() + this.width - 3.0f, this.getPosY(), this.getPosX() + this.width, this.getPosY() + this.getHeight(), -8289919, true, null, false);
        if (!this.invisible) {
            this.scrollBar.render(mouseX, mouseY, partialTicks);
        }
        this.bulkAction.render(mouseX, mouseY, partialTicks);
        this.searchbar.render(mouseX, mouseY, partialTicks);
    }

    public static float clamp(float num, float min, float max) {
        if (num < min) {
            return min;
        }
        return num > max ? max : num;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isSelected(mouseX, mouseY)) {
            ((DefaultSettingsGUI)this.gui).resetSelected();
            for (int i = 0; i < this.list.size(); ++i) {
                int yOffTemp = 18 + 20 * i + this.add;
                if (yOffTemp < -3) continue;
                if ((float)yOffTemp > this.height + 18.0f) break;
                for (Segment segment : this.list.get((int)i).childs) {
                    if (!segment.mouseClicked(mouseX, mouseY, button)) continue;
                    return true;
                }
            }
            this.grabbed = true;
            this.distanceY += (float)(mouseY - this.add);
            return true;
        }
        return this.scrollBar.mouseClicked(mouseX, mouseY, button) ? true : (this.bulkAction.mouseClicked(mouseX, mouseY, button) ? true : this.searchbar.mouseClicked(mouseX, mouseY, button));
    }

    @Override
    public boolean mouseReleased(int mouseX, int mouseY, int button) {
        this.grabbed = false;
        for (int i = 0; i < this.list.size(); ++i) {
            int yOffTemp = 18 + 20 * i + this.add;
            if (yOffTemp < -3) continue;
            if ((float)yOffTemp > this.height + 18.0f) break;
            if (this.scrollBar.mouseReleased(mouseX, mouseY, button)) {
                return true;
            }
            for (Segment segment : this.list.get((int)i).childs) {
                if (!segment.mouseReleased(mouseX, mouseY, button)) continue;
                return true;
            }
        }
        return this.bulkAction.mouseReleased(mouseX, mouseY, button) ? true : this.searchbar.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseDragged(int mouseX, int mouseY, int button) {
        for (int i = 0; i < this.list.size(); ++i) {
            int yOffTemp = 18 + 20 * i + this.add;
            if (yOffTemp < -3) continue;
            if ((float)yOffTemp > this.height + 18.0f) break;
            for (Segment segment : this.list.get((int)i).childs) {
                if (!segment.mouseDragged(mouseX, mouseY, button)) continue;
                return true;
            }
        }
        if (!this.isSelected(mouseX, mouseY)) {
            this.grabbed = false;
        }
        return this.scrollBar.mouseDragged(mouseX, mouseY, button) ? true : (this.bulkAction.mouseDragged(mouseX, mouseY, button) ? true : this.searchbar.mouseDragged(mouseX, mouseY, button));
    }
}

