/*
 * Decompiled with CFR 0.152.
 */
package de.pt400c.defaultsettings.gui;

import de.pt400c.defaultsettings.DefaultSettings;
import de.pt400c.defaultsettings.FileUtil;
import de.pt400c.defaultsettings.GuiConfig;
import de.pt400c.defaultsettings.gui.MenuScreen;
import de.pt400c.defaultsettings.gui.PopupCheckboxSegment;
import de.pt400c.defaultsettings.gui.QuitButtonSegment;
import de.pt400c.defaultsettings.gui.ScrollableSegment;
import de.pt400c.defaultsettings.gui.Segment;
import de.pt400c.defaultsettings.gui.TextSegment;
import de.pt400c.defaultsettings.gui.Vec2f;
import de.pt400c.neptunefx.DrawString;
import de.pt400c.neptunefx.NEX;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import org.lwjgl.opengl.GL11;

class SettingsButtonSegment
extends Segment {
    protected final int id;
    protected final String name;
    protected boolean grabbed;
    private float offX;
    private float offY;
    private final ScrollableSegment parent;
    private boolean active;
    public float timer = 0.0f;
    private static final float BRIGHT_SCALE = 0.85f;
    public boolean mark;

    public SettingsButtonSegment(GuiScreen gui, int id, float posX, float posY, String name, ScrollableSegment parent, boolean mark) {
        super(gui, posX, posY, 6.0f, 6.0f, false);
        this.id = id;
        this.name = name;
        this.parent = parent;
        this.mark = mark;
    }

    @Override
    public boolean hoverCheck(int mouseX, int mouseY) {
        if (this.isSelectedMark(mouseX, mouseY) && this.mark) {
            ArrayList lines = new ArrayList();
            int textWidth = 0;
            lines.addAll(FileUtil.MC.field_71466_p.func_78271_c("Only replaced once on update", this.gui.field_146294_l - mouseX - 12));
            for (String line : lines) {
                if (FileUtil.MC.field_71466_p.func_78256_a(line) <= textWidth) continue;
                textWidth = FileUtil.MC.field_71466_p.func_78256_a(line);
            }
            NEX.drawButton(mouseX + 6, mouseY - 7 - 10 * lines.size(), mouseX + 12 + textWidth, mouseY - 3, -12961222, -2302756, 2);
            int offset = 0;
            Collections.reverse(lines);
            for (String line : lines) {
                DrawString.drawString(line, mouseX + 9, mouseY - 14 - offset, -12961222, false);
                offset += 10;
            }
            return true;
        }
        if (this.isSelected(mouseX, mouseY)) {
            this.active = true;
            return true;
        }
        return false;
    }

    @Override
    public void customRender(int mouseX, int mouseY, float customPosX, float customPosY, float partialTicks) {
        if (this.active && (double)this.timer <= Math.PI) {
            this.timer = (float)((double)this.timer + 0.3);
        } else if (!this.active && this.timer > 0.0f) {
            this.timer = (float)((double)this.timer - 0.3);
        }
        float darken = (float)((Math.sin((double)this.timer + 1.5707963267948966) + 1.0) / 6.0 + 0.67);
        int color = NEX.darkenColor(-2039584, darken).getRGB();
        this.offX = customPosX;
        this.offY = customPosY;
        customPosX += this.getPosX();
        customPosY += this.getPosY();
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)f, (float)f1, (float)f2, (float)f3);
        NEX.drawCircle(customPosX, customPosY + 3.3f, 7.0f, 0.0f, 0);
        color = -14671840;
        f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        f = (float)(color >> 16 & 0xFF) / 255.0f;
        f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        f2 = (float)(color & 0xFF) / 255.0f;
        ScaledResolution scaledResolution = DefaultSettings.is180 ? new ScaledResolution(FileUtil.MC, FileUtil.MC.field_71443_c, FileUtil.MC.field_71440_d) : new ScaledResolution(FileUtil.MC);
        int scaleFactor = scaledResolution.func_78325_e();
        NEX.drawDots(f, f1, f2, f3, scaleFactor, new Vec2f(customPosX, customPosY + 3.3f), new Vec2f(customPosX, customPosY + 4.0f + 3.5f), new Vec2f(customPosX, customPosY - 5.0f + 4.0f));
        if (this.mark) {
            color = -12739296;
            f3 = (float)(color >> 24 & 0xFF) / 255.0f;
            f = (float)(color >> 16 & 0xFF) / 255.0f;
            f1 = (float)(color >> 8 & 0xFF) / 255.0f;
            f2 = (float)(color & 0xFF) / 255.0f;
            GL11.glColor4f((float)f, (float)f1, (float)f2, (float)f3);
            NEX.drawCircle(customPosX - 15.0f, customPosY + 3.3f, 7.0f, 0.0f, 0);
            color = -1;
            f3 = (float)(color >> 24 & 0xFF) / 255.0f;
            f = (float)(color >> 16 & 0xFF) / 255.0f;
            f1 = (float)(color >> 8 & 0xFF) / 255.0f;
            f2 = (float)(color & 0xFF) / 255.0f;
            NEX.drawLine2D_2(f, f1, f2, f3, scaleFactor, 3.0f, new Vec2f(customPosX - 15.0f, customPosY), new Vec2f(customPosX - 15.0f, customPosY + 4.5f));
            NEX.drawDot(f, f1, f2, f3, scaleFactor, 3.0f, new Vec2f(customPosX - 15.0f, customPosY + 7.3f));
        }
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3553);
        this.active = false;
    }

    protected static Color darkenColor(int color) {
        return new Color((int)((float)((color & 0xFF0000) >> 16) * 0.85f), (int)((float)((color & 0xFF00) >> 8) * 0.85f), (int)((float)(color & 0xFF) * 0.85f), 255);
    }

    @Override
    public boolean isSelected(int mouseX, int mouseY) {
        float tempX = this.getPosX() + this.offX;
        float tempY = this.getPosY() + this.offY;
        return (((GuiConfig)this.gui).popupField == null || this.getIsPopupSegment()) && (float)mouseX >= tempX - 8.0f && (float)mouseY >= tempY - 4.0f && (float)mouseX < tempX + this.getWidth() + 2.0f && (float)mouseY < tempY + this.getHeight() + 4.0f;
    }

    public boolean isSelectedMark(int mouseX, int mouseY) {
        float tempX = this.getPosX() + this.offX;
        float tempY = this.getPosY() + this.offY;
        return (((GuiConfig)this.gui).popupField == null || this.getIsPopupSegment()) && (float)mouseX >= tempX - 24.0f && (float)mouseY >= tempY - 4.0f && (float)mouseX < tempX + this.getWidth() - 14.0f && (float)mouseY < tempY + this.getHeight() + 4.0f;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isSelected(mouseX, mouseY)) {
            this.grabbed = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseDragged(int mouseX, int mouseY, int button) {
        if (!this.isSelected(mouseX, mouseY)) {
            this.grabbed = false;
            return false;
        }
        return true;
    }

    @Override
    public boolean mouseReleased(int mouseX, int mouseY, int button) {
        if (this.grabbed) {
            if (this.isSelected(mouseX, mouseY)) {
                this.grabbed = false;
            }
            GuiConfig config = (GuiConfig)this.gui;
            MenuScreen menu = config.menu;
            this.clickSound();
            menu.getVariants().get((int)menu.index).selected = null;
            config.popup.setOpening(true);
            config.popup.getWindow().title = "Config Options";
            config.popup.getWindow().setPos(config.field_146294_l / 2 - 105, config.field_146295_m / 2 - 50);
            config.popupField = config.popup;
            config.popupField.getWindow().clearChildren();
            config.popupField.getWindow().addChild(new TextSegment(config, 5.0f, 30.0f, 0, 0, "Should local configs be persistent?", 0, true));
            config.popupField.getWindow().addChild(new QuitButtonSegment((GuiScreen)config, 190.0f, 5.0f, 14, 14, quitButton -> {
                config.popupField.setOpening(false);
                return true;
            }, 3.0f, true));
            List<String> actives = FileUtil.getActives();
            boolean active = actives.contains(this.name);
            config.popupField.getWindow().addChild(new TextSegment(config, 35.0f, 45.0f, 0, 0, "Always", 0, true));
            config.popupField.getWindow().addChild(new TextSegment(config, 35.0f, 65.0f, 0, 0, "Replaced once", 0, true));
            config.popupField.getWindow().addChild(new TextSegment(config, 35.0f, 85.0f, 0, 0, "Never", 0, true));
            config.popupField.getWindow().addChild(new PopupCheckboxSegment(config, this.id, 15.0f, 45.0f, this.name, this.parent, config.popupField, 0, active && !FileUtil.getOverrides().containsKey(this.name)));
            config.popupField.getWindow().addChild(new PopupCheckboxSegment(config, this.id, 15.0f, 65.0f, this.name, this.parent, config.popupField, 1, active && FileUtil.getOverrides().containsKey(this.name)));
            config.popupField.getWindow().addChild(new PopupCheckboxSegment(config, this.id, 15.0f, 85.0f, this.name, this.parent, config.popupField, 2, !active));
            config.popup.isVisible = true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
    }
}

