/*
 * Decompiled with CFR 0.152.
 */
package link.infra.demagnetize.blocks;

import link.infra.demagnetize.blocks.DemagnetizerContainer;
import link.infra.demagnetize.blocks.DemagnetizerTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;

public class DemagnetizerGui
extends GuiContainer {
    public static final int GUI_ID = 1;
    private static final ResourceLocation background = new ResourceLocation("demagnetize", "textures/gui/demagnetizer.png");
    private DemagnetizerTileEntity te;
    private IconButton rsButton;
    private IconButton whitelistButton;

    public DemagnetizerGui(DemagnetizerTileEntity te, DemagnetizerContainer inventorySlotsIn) {
        super((Container)inventorySlotsIn);
        this.te = te;
        this.field_146999_f = 176;
        this.field_147000_g = 166;
    }

    public void func_73866_w_() {
        int currentRSState;
        super.func_73866_w_();
        this.field_146292_n.add(new RangeSlider(0, this.field_147003_i + 7, this.field_147009_r + 17, this.te.getMaxRange(), this.te.getRange()));
        String[] rsStates = new String[]{"rsignored", "rson", "rsoff"};
        switch (this.te.getRedstoneSetting()) {
            case POWERED: {
                currentRSState = 1;
                break;
            }
            case UNPOWERED: {
                currentRSState = 2;
                break;
            }
            default: {
                currentRSState = 0;
            }
        }
        this.rsButton = new IconButton(1, this.field_147003_i + 124, this.field_147009_r + 17, rsStates, currentRSState, background, 0, 184){

            @Override
            public void updateState(int currentState) {
                switch (currentState) {
                    case 0: {
                        DemagnetizerGui.this.te.setRedstoneSetting(DemagnetizerTileEntity.RedstoneStatus.REDSTONE_DISABLED);
                        break;
                    }
                    case 1: {
                        DemagnetizerGui.this.te.setRedstoneSetting(DemagnetizerTileEntity.RedstoneStatus.POWERED);
                        break;
                    }
                    case 2: {
                        DemagnetizerGui.this.te.setRedstoneSetting(DemagnetizerTileEntity.RedstoneStatus.UNPOWERED);
                    }
                }
            }
        };
        this.field_146292_n.add(this.rsButton);
        String[] whitelistStates = new String[]{"blacklist", "whitelist"};
        int currentWhitelistState = this.te.isWhitelist() ? 1 : 0;
        this.whitelistButton = new IconButton(2, this.field_147003_i + 148, this.field_147009_r + 17, whitelistStates, currentWhitelistState, background, 0, 204){

            @Override
            public void updateState(int currentState) {
                DemagnetizerGui.this.te.setWhitelist(currentState == 1);
            }
        };
        this.field_146292_n.add(this.whitelistButton);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.field_146297_k.func_110434_K().func_110577_a(background);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, 176, 166);
        for (int i = 0; i < this.te.getFilterSize(); ++i) {
            this.func_73729_b(this.field_147003_i + 7 + i * 18, this.field_147009_r + 52, 0, 166, 18, 18);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String demagName = I18n.func_135052_a((String)(this.te.func_145838_q().func_149739_a() + ".name"), (Object[])new Object[0]);
        int centeredPos = (this.field_146999_f - this.field_146289_q.func_78256_a(demagName)) / 2;
        this.field_146289_q.func_78276_b(demagName, centeredPos, 6, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.field_147000_g - 96 + 3, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"label.demagnetize.demagnetizer.filter.name", (Object[])new Object[0]), 8, 42, 0x404040);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        super.func_191948_b(mouseX, mouseY);
        this.rsButton.renderTooltip(mouseX, mouseY);
        this.whitelistButton.renderTooltip(mouseX, mouseY);
    }

    public void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 0: {
                this.te.setRange(((RangeSlider)button).getValue());
                break;
            }
            case 1: 
            case 2: {
                ((IconButton)button).handleClick();
            }
        }
    }

    public void func_146281_b() {
        this.te.sendSettingsToServer();
    }

    public abstract class IconButton
    extends GuiButton {
        private final String[] stateList;
        private int currentState;
        private final ResourceLocation location;
        private final int resourceX;
        private final int resourceY;

        public IconButton(int buttonId, int x, int y, String[] stateList, int currentState, ResourceLocation location, int resourceX, int resourceY) {
            super(buttonId, x, y, 20, 20, "");
            this.stateList = stateList;
            this.currentState = currentState;
            this.location = location;
            this.resourceX = resourceX;
            this.resourceY = resourceY;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            super.func_191745_a(mc, mouseX, mouseY, partialTicks);
            if (this.field_146125_m) {
                mc.func_110434_K().func_110577_a(this.location);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.func_73729_b(this.field_146128_h, this.field_146129_i, this.resourceX + this.currentState * this.field_146120_f, this.resourceY, this.field_146120_f, this.field_146121_g);
            }
        }

        public void renderTooltip(int mouseX, int mouseY) {
            if (this.func_146115_a()) {
                DemagnetizerGui.this.func_146279_a(I18n.func_135052_a((String)("label.demagnetize.demagnetizer." + this.stateList[this.currentState] + ".name"), (Object[])new Object[0]), mouseX, mouseY);
            }
        }

        public void handleClick() {
            ++this.currentState;
            if (this.currentState >= this.stateList.length) {
                this.currentState = 0;
            }
            this.updateState(this.currentState);
        }

        public abstract void updateState(int var1);
    }

    private class RangeSlider
    extends GuiButton {
        private int sliderValue;
        public boolean dragging;
        private final int maxValue;
        private final int minValue = 1;

        public RangeSlider(int buttonId, int x, int y, int maxRange, int value) {
            super(buttonId, x, y, 113, 20, "");
            this.minValue = 1;
            this.sliderValue = value;
            this.maxValue = maxRange;
            this.setDisplayString();
        }

        protected int func_146114_a(boolean mouseOver) {
            return 0;
        }

        protected void func_146119_b(Minecraft mc, int mouseX, int mouseY) {
            if (this.field_146125_m) {
                if (this.dragging) {
                    float mouseValue = (float)(mouseX - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
                    if (mouseValue > 1.0f) {
                        mouseValue = 1.0f;
                    } else if (mouseValue < 0.0f) {
                        mouseValue = 0.0f;
                    }
                    this.sliderValue = Math.round(mouseValue * (float)(this.maxValue - 1)) + 1;
                    this.setDisplayString();
                    DemagnetizerGui.this.te.setRange(this.sliderValue);
                }
                mc.func_110434_K().func_110577_a(field_146122_a);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                float flValue = ((float)this.sliderValue - 1.0f) / (float)(this.maxValue - 1);
                this.func_73729_b(this.field_146128_h + (int)(flValue * (float)(this.field_146120_f - 8)), this.field_146129_i, 0, 66, 4, 20);
                this.func_73729_b(this.field_146128_h + (int)(flValue * (float)(this.field_146120_f - 8)) + 4, this.field_146129_i, 196, 66, 4, 20);
            }
        }

        public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
            if (super.func_146116_c(mc, mouseX, mouseY)) {
                float mouseValue = (float)(mouseX - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
                this.sliderValue = Math.round(mouseValue * (float)(this.maxValue - 1)) + 1;
                this.setDisplayString();
                DemagnetizerGui.this.te.setRange(this.sliderValue);
                this.dragging = true;
                return true;
            }
            return false;
        }

        public void func_146118_a(int mouseX, int mouseY) {
            this.dragging = false;
        }

        public void setDisplayString() {
            String rangeText = I18n.func_135052_a((String)"label.demagnetize.demagnetizer.range.name", (Object[])new Object[0]);
            this.field_146126_j = rangeText + ": " + this.sliderValue;
        }

        public int getValue() {
            return this.sliderValue;
        }
    }
}

