/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.draw_bridge.data.provider;

import com.google.gson.JsonElement;
import info.u_team.u_team_core.data.CommonProvider;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public abstract class CommonRecipesProvider
extends CommonProvider {
    public CommonRecipesProvider(DataGenerator generator) {
        super("Recipes", generator);
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        Consumer<IFinishedRecipe> consumer = recipe -> {
            try {
                ResourceLocation recipeID = recipe.func_200442_b();
                this.write(cache, (JsonElement)recipe.func_200441_a(), this.path.resolve(recipeID.func_110624_b()).resolve("recipes").resolve(recipe.func_200442_b().func_110623_a() + ".json"));
                if (recipe.func_200440_c() != null) {
                    this.write(cache, (JsonElement)recipe.func_200440_c(), this.path.resolve(recipeID.func_110624_b()).resolve("advancements").resolve("recipes").resolve(recipeID.func_110623_a() + ".json"));
                }
            }
            catch (IOException ex) {
                LOGGER.error(this.marker, "Could not write data.", (Throwable)ex);
            }
        };
        this.addRecipes(consumer);
    }

    protected abstract void addRecipes(Consumer<IFinishedRecipe> var1);

    protected Path resolvePath(Path outputFolder) {
        return outputFolder.resolve("data");
    }

    protected InventoryChangeTrigger.Instance hasItem(Tag<Item> tag) {
        return this.hasItem(ItemPredicate.Builder.func_200309_a().func_200307_a(tag).func_200310_b());
    }

    protected InventoryChangeTrigger.Instance hasItem(IItemProvider item) {
        return this.hasItem(ItemPredicate.Builder.func_200309_a().func_200308_a(item).func_200310_b());
    }

    protected InventoryChangeTrigger.Instance hasItem(ItemPredicate ... predicates) {
        return new InventoryChangeTrigger.Instance(MinMaxBounds.IntBound.field_211347_e, MinMaxBounds.IntBound.field_211347_e, MinMaxBounds.IntBound.field_211347_e, predicates);
    }

    protected Ingredient getIngredientOfTag(Tag<Item> tag) {
        return Ingredient.func_209357_a(Stream.of(new Ingredient.TagList(tag){

            public Collection<ItemStack> func_199799_a() {
                return Arrays.asList(new ItemStack((IItemProvider)Items.field_185153_aK));
            }
        }));
    }
}

