/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.draw_bridge.screen;

import info.u_team.draw_bridge.container.DrawBridgeContainer;
import info.u_team.draw_bridge.tileentity.DrawBridgeTileEntity;
import info.u_team.u_team_core.gui.UContainerScreen;
import info.u_team.u_team_core.gui.elements.BetterFontSlider;
import net.minecraft.client.gui.widget.ToggleWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DrawBridgeScreen
extends UContainerScreen<DrawBridgeContainer> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("drawbridge", "textures/gui/draw_bridge.png");
    private BetterFontSlider slider;

    public DrawBridgeScreen(DrawBridgeContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, title, BACKGROUND);
        this.field_147000_g = 184;
    }

    protected void init() {
        super.init();
        final DrawBridgeTileEntity drawBridge = (DrawBridgeTileEntity)((DrawBridgeContainer)this.field_147002_h).getTileEntity();
        ToggleWidget button = (ToggleWidget)this.addButton((Widget)new ToggleWidget(this.field_147003_i + 132, this.field_147009_r + 62, 20, 20, drawBridge.isNeedRedstone()){

            public void onClick(double mouseX, double mouseY) {
                boolean newState = !drawBridge.isNeedRedstone();
                drawBridge.setNeedRedstone(newState);
                this.func_191753_b(newState);
                drawBridge.sendDataToServer();
            }

            public void renderToolTip(int mouseX, int mouseY) {
                if (this.isHovered()) {
                    DrawBridgeScreen.this.renderTooltip(I18n.func_135052_a((String)"container.drawbridge.draw_bridge.need_redstone", (Object[])new Object[0]), mouseX, mouseY);
                }
            }
        });
        button.func_191751_a(this.field_146999_f, 0, 20, 20, BACKGROUND);
        this.slider = new BetterFontSlider(this.field_147003_i + 7, this.field_147009_r + 62, 90, 20, I18n.func_135052_a((String)"container.drawbridge.draw_bridge.speed", (Object[])new Object[0]) + " ", " " + I18n.func_135052_a((String)"container.drawbridge.draw_bridge.ticks", (Object[])new Object[0]), 0.0, 100.0, drawBridge.getSpeed(), false, true, 1.0f, null){

            public void onRelease(double mouseX, double mouseY) {
                super.onRelease(mouseX, mouseY);
                drawBridge.setSpeed(DrawBridgeScreen.this.slider.getValueInt());
                drawBridge.sendDataToServer();
            }
        };
        this.addButton((Widget)this.slider);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.buttons.forEach(button -> button.renderToolTip(mouseX, mouseY));
        this.func_191948_b(mouseX, mouseY);
    }

    public void func_146979_b(int mouseX, int mouseY) {
        this.font.func_211126_b(this.title.func_150254_d(), 8.0f, 6.0f, 0x404040);
        this.font.func_211126_b(this.field_213127_e.func_145748_c_().func_150254_d(), 8.0f, (float)(this.field_147000_g - 94), 0x404040);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        if (this.slider != null) {
            this.slider.mouseReleased(mouseX, mouseY, mouseButton);
        }
        return super.mouseReleased(mouseX, mouseY, mouseButton);
    }
}

