/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.draw_bridge.tileentity;

import info.u_team.draw_bridge.block.DrawBridgeBlock;
import info.u_team.draw_bridge.container.DrawBridgeContainer;
import info.u_team.draw_bridge.init.DrawBridgeBlocks;
import info.u_team.draw_bridge.init.DrawBridgeTileEntityTypes;
import info.u_team.draw_bridge.util.InventoryStackHandler;
import info.u_team.draw_bridge.util.SingleStackInventoryStackHandler;
import info.u_team.u_team_core.api.sync.IAutoSyncedTileEntity;
import info.u_team.u_team_core.container.USyncedTileEntityContainer;
import info.u_team.u_team_core.tileentity.UTileEntity;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.util.LazyOptional;

public class DrawBridgeTileEntity
extends UTileEntity
implements ITickableTileEntity,
IAutoSyncedTileEntity {
    public static final ModelProperty<BlockState> BLOCKSTATE_PROPERTY = new ModelProperty();
    private final LazyOptional<InventoryStackHandler> slots = LazyOptional.of(() -> new SingleStackInventoryStackHandler(10));
    private final LazyOptional<InventoryStackHandler> renderSlot = LazyOptional.of(() -> new SingleStackInventoryStackHandler(1){

        @Override
        public boolean isItemValid(int index, ItemStack stack) {
            Item item = stack.func_77973_b();
            if (!(item instanceof BlockItem) || item == DrawBridgeBlocks.DRAW_BRIDGE.func_199767_j()) {
                return false;
            }
            Block block = ((BlockItem)item).func_179223_d();
            return block.func_176223_P().func_200132_m();
        }

        @Override
        protected void onLoaded() {
            this.setRenderState();
        }

        @Override
        protected void slotChanged(int index) {
            if (!DrawBridgeTileEntity.this.func_145830_o() || DrawBridgeTileEntity.this.field_145850_b.func_201670_d()) {
                return;
            }
            this.setRenderState();
            DrawBridgeTileEntity.this.sendChangesToClient();
        }

        private void setRenderState() {
            ItemStack stack = this.getStackInSlot(0);
            if (stack.func_190926_b()) {
                DrawBridgeTileEntity.this.renderBlockState = null;
                return;
            }
            Item item = stack.func_77973_b();
            if (!(item instanceof BlockItem) || item == DrawBridgeBlocks.DRAW_BRIDGE.func_199767_j()) {
                return;
            }
            DrawBridgeTileEntity.this.renderBlockState = ((BlockItem)item).func_179223_d().func_176223_P();
        }
    });
    private boolean powered;
    private int speed;
    private boolean needRedstone = true;
    private int extendState;
    private boolean extended;
    private boolean[] ourBlocks = new boolean[10];
    private int localSpeed;
    private BlockState renderBlockState;

    public DrawBridgeTileEntity() {
        super(DrawBridgeTileEntityTypes.DRAW_BRIDGE);
    }

    public void neighborChanged() {
        boolean newPowered = this.field_145850_b.func_175640_z(this.field_174879_c);
        this.updatePoweredState(newPowered);
        HashSet<DrawBridgeTileEntity> drawBridges = new HashSet<DrawBridgeTileEntity>();
        this.collect(drawBridges, this, 0);
        boolean newPoweredState = drawBridges.stream().anyMatch(drawBridge -> this.field_145850_b.func_175640_z(drawBridge.field_174879_c)) | newPowered;
        drawBridges.stream().forEach(drawBridge -> drawBridge.updatePoweredState(newPoweredState));
    }

    private void updatePoweredState(boolean newPowered) {
        this.powered = this.needRedstone ? newPowered : !newPowered;
    }

    private void collect(Set<DrawBridgeTileEntity> tileEntites, DrawBridgeTileEntity callerTileEntity, int depth) {
        if (depth >= 20) {
            return;
        }
        this.getNeighbors(callerTileEntity.field_174879_c).stream().forEach(neighbor -> {
            TileEntity tileEntity = this.field_145850_b.func_175625_s(neighbor);
            if (!(tileEntity instanceof DrawBridgeTileEntity)) {
                return;
            }
            DrawBridgeTileEntity drawBridge = (DrawBridgeTileEntity)tileEntity;
            if (tileEntites.add(drawBridge)) {
                drawBridge.collect(tileEntites, drawBridge, depth + 1);
            }
        });
    }

    private List<BlockPos> getNeighbors(BlockPos except) {
        return this.getPosExcept(this.field_174879_c, except).filter(pos -> this.field_145850_b.func_180495_p(pos).func_177230_c() == DrawBridgeBlocks.DRAW_BRIDGE).collect(Collectors.toList());
    }

    private Stream<BlockPos> getPosExcept(BlockPos start, BlockPos except) {
        return Stream.of(Direction.values()).map(arg_0 -> ((BlockPos)start).func_177972_a(arg_0)).filter(pos -> !pos.equals((Object)except));
    }

    public void func_73660_a() {
        if (this.field_145850_b.func_201670_d()) {
            return;
        }
        if (this.localSpeed <= 1) {
            this.localSpeed = this.speed;
            if (this.powered && this.extendState < 10) {
                if (this.localSpeed == 0) {
                    for (int i = this.extendState; i < 10; ++i) {
                        this.extend();
                    }
                } else {
                    this.extend();
                }
                this.func_70296_d();
            } else if (!this.powered && this.extendState > 0) {
                if (this.localSpeed == 0) {
                    for (int i = this.extendState; i > 0; --i) {
                        this.retract();
                    }
                } else {
                    this.retract();
                }
                this.func_70296_d();
            }
        }
        --this.localSpeed;
    }

    private void extend() {
        Direction facing = (Direction)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(DrawBridgeBlock.FACING);
        this.trySetBlock(facing);
        this.extended = ++this.extendState > 0;
    }

    private void trySetBlock(Direction facing) {
        BlockPos newPos = this.field_174879_c.func_177967_a(facing, this.extendState + 1);
        if (this.slots.isPresent() && this.field_145850_b.func_175623_d(newPos)) {
            this.slots.ifPresent(inventory -> {
                ItemStack itemstack = inventory.getStackInSlot(this.extendState);
                Block block = Block.func_149634_a((Item)itemstack.func_77973_b());
                this.field_145850_b.func_180501_a(newPos, block.func_176223_P(), 2);
                inventory.getInventory().func_70304_b(this.extendState);
                this.ourBlocks[this.extendState] = true;
            });
        } else {
            this.ourBlocks[this.extendState] = false;
        }
    }

    private void retract() {
        Direction facing = (Direction)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(DrawBridgeBlock.FACING);
        this.extended = --this.extendState > 0;
        this.tryRemoveBlock(facing);
    }

    private void tryRemoveBlock(Direction facing) {
        BlockPos newPos;
        if (this.ourBlocks[this.extendState] && this.slots.isPresent() && !this.field_145850_b.func_175623_d(newPos = this.field_174879_c.func_177967_a(facing, this.extendState + 1))) {
            this.slots.ifPresent(inventory -> {
                BlockState state = this.field_145850_b.func_180495_p(newPos);
                Block block = state.func_177230_c();
                ItemStack stack = new ItemStack((IItemProvider)block);
                inventory.getInventory().func_70299_a(this.extendState, stack);
                this.field_145850_b.func_180501_a(newPos, Blocks.field_150350_a.func_176223_P(), 2);
            });
        }
    }

    public void readNBT(CompoundNBT compound) {
        this.slots.ifPresent(inventory -> inventory.deserializeNBT(compound.func_74775_l("slots")));
        this.renderSlot.ifPresent(inventory -> inventory.deserializeNBT(compound.func_74775_l("render_slot")));
        this.powered = compound.func_74767_n("powered");
        this.extendState = compound.func_74762_e("extend");
        this.extended = this.extendState > 0;
        this.speed = compound.func_74762_e("speed");
        this.needRedstone = compound.func_74767_n("need_redstone");
        CompoundNBT ourBlocksTag = compound.func_74775_l("our_blocks");
        for (int i = 0; i < this.ourBlocks.length; ++i) {
            this.ourBlocks[i] = ourBlocksTag.func_74764_b("" + i) ? ourBlocksTag.func_74767_n("" + i) : false;
        }
    }

    public void writeNBT(CompoundNBT compound) {
        this.slots.ifPresent(inventory -> compound.func_218657_a("slots", (INBT)inventory.serializeNBT()));
        this.renderSlot.ifPresent(inventory -> compound.func_218657_a("render_slot", (INBT)inventory.serializeNBT()));
        compound.func_74757_a("powered", this.powered);
        compound.func_74768_a("extend", this.extendState);
        compound.func_74768_a("speed", this.speed);
        compound.func_74757_a("need_redstone", this.needRedstone);
        CompoundNBT ourBlocksTag = new CompoundNBT();
        for (int i = 0; i < this.ourBlocks.length; ++i) {
            ourBlocksTag.func_74757_a("" + i, this.ourBlocks[i]);
        }
        compound.func_218657_a("our_blocks", (INBT)ourBlocksTag);
    }

    public USyncedTileEntityContainer<?> createMenu(int id, PlayerInventory playerInventory, PlayerEntity player) {
        return new DrawBridgeContainer(id, playerInventory, this);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.drawbridge.draw_bridge", new Object[0]);
    }

    public LazyOptional<InventoryStackHandler> getSlots() {
        return this.slots;
    }

    public LazyOptional<InventoryStackHandler> getRenderSlot() {
        return this.renderSlot;
    }

    public void sendToClient(PacketBuffer buffer) {
        buffer.writeBoolean(this.extended);
        buffer.func_150787_b(this.speed);
        buffer.writeBoolean(this.needRedstone);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleFromServer(PacketBuffer buffer) {
        this.extended = buffer.readBoolean();
        this.speed = buffer.func_150792_a();
        this.needRedstone = buffer.readBoolean();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void sendToServer(PacketBuffer buffer) {
        buffer.func_150787_b(this.speed);
        buffer.writeBoolean(this.needRedstone);
    }

    public void handleFromClient(PacketBuffer buffer) {
        this.speed = buffer.func_150792_a();
        this.needRedstone = buffer.readBoolean();
        this.neighborChanged();
    }

    public boolean isExtended() {
        return this.extended;
    }

    public int getSpeed() {
        return this.speed;
    }

    public void setSpeed(int speed) {
        this.speed = speed;
    }

    public boolean isNeedRedstone() {
        return this.needRedstone;
    }

    public void setNeedRedstone(boolean needRedstone) {
        this.needRedstone = needRedstone;
    }

    public boolean hasRenderBlockState() {
        return this.renderBlockState != null;
    }

    public BlockState getRenderBlockState() {
        return this.renderBlockState;
    }

    private void writeRenderState(CompoundNBT compound) {
        if (this.renderBlockState != null) {
            compound.func_218657_a("render", (INBT)NBTUtil.func_190009_a((BlockState)this.renderBlockState));
        }
    }

    private void readRenderState(CompoundNBT compound) {
        this.renderBlockState = compound.func_74764_b("render") ? NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("render")) : null;
    }

    public void sendChunkLoadData(CompoundNBT compound) {
        this.writeRenderState(compound);
    }

    public void handleChunkLoadData(CompoundNBT compound) {
        this.readRenderState(compound);
    }

    public void sendUpdateStateData(CompoundNBT compound) {
        this.writeRenderState(compound);
    }

    public void handleUpdateStateData(CompoundNBT compound) {
        this.readRenderState(compound);
        this.requestModelDataUpdate();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 0);
    }

    public IModelData getModelData() {
        if (this.renderBlockState != null) {
            return new ModelDataMap.Builder().withInitial(BLOCKSTATE_PROPERTY, (Object)this.renderBlockState).build();
        }
        return EmptyModelData.INSTANCE;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT compound = new CompoundNBT();
        this.sendUpdateStateData(compound);
        return new SUpdateTileEntityPacket(this.field_174879_c, -1, compound);
    }
}

