/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.draw_bridge.util;

import java.util.stream.IntStream;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class InventoryStackHandler
implements IItemHandlerModifiable,
INBTSerializable<CompoundNBT> {
    private final NonNullList<ItemStack> stacks;
    private final IInventory inventory;

    public InventoryStackHandler(int size) {
        this.stacks = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
        this.inventory = this.createInventory(this.stacks);
    }

    protected IInventory createInventory(NonNullList<ItemStack> stacks) {
        return new Inventory(stacks, this);
    }

    public IInventory getInventory() {
        return this.inventory;
    }

    public ItemStack getStackInSlot(int index) {
        return (ItemStack)this.stacks.get(index);
    }

    public int getSlots() {
        return this.stacks.size();
    }

    public void setStackInSlot(int index, ItemStack stack) {
        this.inventory.func_70299_a(index, stack);
    }

    public ItemStack insertItem(int index, ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (!this.isItemValid(index, stack)) {
            return stack;
        }
        ItemStack existing = (ItemStack)this.stacks.get(index);
        int limit = this.getStackLimit(index, stack);
        if (!existing.func_190926_b()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.func_190916_E();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.func_190916_E() > limit;
        if (!simulate) {
            if (existing.func_190926_b()) {
                this.stacks.set(index, (Object)(reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack));
            } else {
                existing.func_190917_f(reachedLimit ? limit : stack.func_190916_E());
            }
            this.slotChanged(index);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - limit)) : ItemStack.field_190927_a;
    }

    public ItemStack extractItem(int index, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack existing = (ItemStack)this.stacks.get(index);
        if (existing.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int toExtract = Math.min(amount, existing.func_77976_d());
        if (existing.func_190916_E() <= toExtract) {
            if (!simulate) {
                this.stacks.set(index, (Object)ItemStack.field_190927_a);
                this.slotChanged(index);
            }
            return existing;
        }
        if (!simulate) {
            this.stacks.set(index, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.func_190916_E() - toExtract)));
            this.slotChanged(index);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    public int getSlotLimit(int index) {
        return this.inventory.func_70297_j_();
    }

    public boolean isItemValid(int index, ItemStack stack) {
        return true;
    }

    protected int getStackLimit(int index, ItemStack stack) {
        return Math.min(this.getSlotLimit(index), stack.func_77976_d());
    }

    public CompoundNBT serializeNBT() {
        return ItemStackHelper.func_191281_a((CompoundNBT)new CompoundNBT(), this.stacks, (boolean)false);
    }

    public void deserializeNBT(CompoundNBT compound) {
        ItemStackHelper.func_191283_b((CompoundNBT)compound, this.stacks);
        this.onLoaded();
    }

    protected void slotChanged(int index) {
    }

    protected void onLoaded() {
    }

    protected static class Inventory
    implements IInventory {
        private final NonNullList<ItemStack> stacks;
        private final InventoryStackHandler handler;

        protected Inventory(NonNullList<ItemStack> stacks, InventoryStackHandler handler) {
            this.stacks = stacks;
            this.handler = handler;
        }

        public void func_174888_l() {
            this.stacks.clear();
            IntStream.range(0, this.stacks.size()).forEach(this.handler::slotChanged);
        }

        public void func_70299_a(int index, ItemStack stack) {
            this.stacks.set(index, (Object)stack);
            int limit = this.handler.getStackLimit(index, stack);
            if (stack.func_190916_E() > limit) {
                stack.func_190920_e(limit);
            }
            this.handler.slotChanged(index);
        }

        public ItemStack func_70304_b(int index) {
            ItemStack stack = ItemStackHelper.func_188383_a(this.stacks, (int)index);
            this.handler.slotChanged(index);
            return stack;
        }

        public void func_70296_d() {
        }

        public boolean func_70300_a(PlayerEntity player) {
            return true;
        }

        public boolean func_191420_l() {
            return this.stacks.stream().allMatch(ItemStack::func_190926_b);
        }

        public ItemStack func_70301_a(int index) {
            return (ItemStack)this.stacks.get(index);
        }

        public int func_70302_i_() {
            return this.stacks.size();
        }

        public ItemStack func_70298_a(int index, int count) {
            ItemStack stack = ItemStackHelper.func_188382_a(this.stacks, (int)index, (int)count);
            this.handler.slotChanged(index);
            return stack;
        }
    }
}

