/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.minecraft.ducky;

import com.blackducksoftware.integration.minecraft.DuckyModSounds;
import com.blackducksoftware.integration.minecraft.ducky.ai.DuckyAIFlyTowardsTargetAndAttack;
import com.blackducksoftware.integration.minecraft.ducky.ai.DuckyAIFollowOwnerFlying;
import com.blackducksoftware.integration.minecraft.ducky.ai.DuckyAILookIdle;
import com.blackducksoftware.integration.minecraft.ducky.ai.DuckyAIMoveTowardsTargetAndAttack;
import com.blackducksoftware.integration.minecraft.ducky.ai.DuckyAIPanic;
import com.blackducksoftware.integration.minecraft.ducky.ai.DuckyAIWander;
import com.blackducksoftware.integration.minecraft.ducky.pathfinding.DuckyFlyHelper;
import com.blackducksoftware.integration.minecraft.ducky.pathfinding.DuckyPathNavigateFlying;
import com.blackducksoftware.integration.minecraft.ducky.tamed.EntityTamedDucky;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityDucky
extends EntityTameable {
    public static final double GIANT_HEALTH = 128.0;
    public static final double TAMED_HEALTH = 64.0;
    public static final double TAMED_DAMAGE = 15.0;
    public static final double BASE_HEALTH = 15.0;
    public static final double BASE_DAMAGE = 6.0;
    public static final double BASE_SPEED = 0.35;
    public static final double INCREASED_DAMAGE = 40.0;
    public static final double FAST_SPEED = 0.65;
    public static final String DUCKY_NAME = "bd_ducky";
    public float wingRotation;
    public float destPos;
    public float oFlapSpeed;
    public float oFlap;
    public float wingRotDelta = 1.0f;
    protected static final DataParameter<Byte> IS_FIRE_PROOF = EntityDataManager.func_187226_a(EntityDucky.class, (DataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Byte> CAN_FLY = EntityDataManager.func_187226_a(EntityDucky.class, (DataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Byte> STRENGTH = EntityDataManager.func_187226_a(EntityDucky.class, (DataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Byte> SPEED = EntityDataManager.func_187226_a(EntityDucky.class, (DataSerializer)DataSerializers.field_187191_a);
    private boolean isFlying;
    private boolean isAttacking;
    protected final DuckyAIFlyTowardsTargetAndAttack duckyAIFlyTowardsTargetAndAttack;
    protected final DuckyAIFollowOwnerFlying duckyAIFollowOwnerFlying;
    protected final PathNavigateGround groundNavigator;
    protected final DuckyPathNavigateFlying flyingNavigator;
    protected final EntityMoveHelper groundMoveHelper;
    protected final DuckyFlyHelper flyingMoveHelper;

    public EntityDucky(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.4f, 0.7f);
        this.func_98055_j(1.0f);
        this.duckyAIFlyTowardsTargetAndAttack = new DuckyAIFlyTowardsTargetAndAttack(this, 32.0f, 32L);
        this.duckyAIFollowOwnerFlying = new DuckyAIFollowOwnerFlying(this, 3.0f, 12.0f);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.groundNavigator = new PathNavigateGround((EntityLiving)this, worldIn);
        this.groundNavigator.func_179693_d(true);
        this.groundNavigator.func_179691_c(true);
        this.field_70699_by = this.groundNavigator;
        this.flyingNavigator = new DuckyPathNavigateFlying(this, worldIn);
        this.flyingNavigator.setCanSwim(true);
        this.flyingNavigator.setCanEnterDoors(true);
        this.field_70765_h = this.groundMoveHelper = new EntityMoveHelper((EntityLiving)this);
        this.flyingMoveHelper = new DuckyFlyHelper(this);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_FIRE_PROOF, (Object)0);
        this.field_70180_af.func_187214_a(CAN_FLY, (Object)0);
        this.field_70180_af.func_187214_a(STRENGTH, (Object)0);
        this.field_70180_af.func_187214_a(SPEED, (Object)0);
    }

    protected void func_184651_r() {
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new DuckyAIPanic(this, 1.4));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new DuckyAIWander(this, 1.0, 100));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new DuckyAILookIdle(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new DuckyAIMoveTowardsTargetAndAttack(this, 32.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityMob.class, true, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntitySlime.class, true, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityShulker.class, true, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityGhast.class, true, false));
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{EntityMob.class, EntitySlime.class, EntityShulker.class, EntityGhast.class}));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(15.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.35);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_193334_e).func_111128_a(0.35);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
    }

    public boolean func_70686_a(Class<? extends EntityLivingBase> cls) {
        return true;
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.oFlap = this.wingRotation;
        this.oFlapSpeed = this.destPos;
        this.destPos = (float)((double)this.destPos + (double)(this.field_70122_E ? -1 : 4) * 0.3);
        this.destPos = MathHelper.func_76131_a((float)this.destPos, (float)0.0f, (float)1.0f);
        if (!this.field_70122_E && this.wingRotDelta < 1.0f) {
            this.wingRotDelta = 1.0f;
        }
        this.wingRotDelta = (float)((double)this.wingRotDelta * 0.9);
        this.wingRotation += this.wingRotDelta * 2.0f;
        if (!this.field_70122_E && this.field_70181_x < 0.0 && !this.isFlying() && this.isTooHigh()) {
            this.field_70181_x *= 0.6;
        }
    }

    public boolean isTooHigh() {
        BlockPos loc = null;
        double y = this.func_180425_c().func_177956_o();
        boolean isTooHigh = true;
        for (double i = y; i >= y - 3.0; i -= 1.0) {
            loc = new BlockPos((double)this.func_180425_c().func_177958_n(), i, (double)this.func_180425_c().func_177952_p());
            IBlockState blockstate = this.field_70170_p.func_180495_p(loc);
            if (blockstate.func_185904_a() == Material.field_151579_a && !blockstate.func_185917_h()) continue;
            isTooHigh = false;
        }
        return isTooHigh;
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean canAttackFrom = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (canAttackFrom) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return canAttackFrom;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (this.func_70877_b(itemstack)) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            if (!this.field_70170_p.field_72995_K) {
                EntityTamedDucky entityTamedDucky = new EntityTamedDucky(this.field_70170_p);
                entityTamedDucky.func_184754_b(player.func_110124_au());
                entityTamedDucky.func_70903_f(true);
                this.spawnTamedDucky(player, entityTamedDucky);
                entityTamedDucky.func_70908_e(true);
            }
            return true;
        }
        return false;
    }

    public void setAttributesFromOriginal(EntityDucky originalDucky, UUID ownerId) {
        this.func_70904_g(originalDucky.func_70906_o());
        this.func_174828_a(originalDucky.func_180425_c(), 0.0f, 0.0f);
        this.field_70699_by.func_75499_g();
        this.func_70624_b(null);
        if (ownerId != null) {
            this.func_184754_b(ownerId);
            this.func_70903_f(true);
        }
    }

    protected void spawnTamedDucky(EntityPlayer player, EntityTamedDucky entityTamedDucky) {
        if (!ForgeEventFactory.onAnimalTame((EntityAnimal)entityTamedDucky, (EntityPlayer)player)) {
            entityTamedDucky.setAttributesFromOriginal(this, player.func_110124_au());
            entityTamedDucky.func_180482_a(entityTamedDucky.field_70170_p.func_175649_E(this.func_180425_c()), null);
            this.func_70106_y();
            entityTamedDucky.field_70170_p.func_72838_d((Entity)entityTamedDucky);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (this.field_70911_d != null) {
            this.func_70904_g(false);
        }
        return super.func_70097_a(source, amount);
    }

    public boolean canMove() {
        return !this.func_70906_o() && !this.func_110167_bD();
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151025_P;
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        return false;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected SoundEvent func_184639_G() {
        return DuckyModSounds.duckQuack;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return DuckyModSounds.duckHurt;
    }

    protected SoundEvent func_184615_bR() {
        return DuckyModSounds.duckDeath;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187538_aa, 0.15f, 1.0f);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return null;
    }

    public boolean func_70906_o() {
        byte tamedByte = (Byte)this.field_70180_af.func_187225_a(field_184755_bv);
        boolean sitting = (tamedByte & 1) != 0;
        return sitting;
    }

    public void func_70904_g(boolean sitting) {
        this.field_70911_d.func_75270_a(sitting);
        byte tamedByte = (Byte)this.field_70180_af.func_187225_a(field_184755_bv);
        if (sitting) {
            this.field_70180_af.func_187227_b(field_184755_bv, (Object)((byte)(tamedByte | 1)));
        } else {
            this.field_70180_af.func_187227_b(field_184755_bv, (Object)((byte)(tamedByte & 0xFFFFFFFE)));
        }
    }

    private boolean getManagedByteBoolean(DataParameter<Byte> dataParameter) {
        byte managedByte = (Byte)this.field_70180_af.func_187225_a(dataParameter);
        boolean value = (managedByte & 1) != 0;
        return value;
    }

    private void setManagedByteBoolean(DataParameter<Byte> dataParameter, boolean value) {
        byte managedByte = (Byte)this.field_70180_af.func_187225_a(dataParameter);
        if (value) {
            this.field_70180_af.func_187227_b(dataParameter, (Object)((byte)(managedByte | 1)));
        } else {
            this.field_70180_af.func_187227_b(dataParameter, (Object)((byte)(managedByte & 0xFFFFFFFE)));
        }
    }

    public boolean isFireProof() {
        return this.getManagedByteBoolean(IS_FIRE_PROOF);
    }

    public void setFireProof(boolean fireProof) {
        this.field_70178_ae = fireProof;
        this.setManagedByteBoolean(IS_FIRE_PROOF, fireProof);
    }

    public boolean isCanFly() {
        return this.getManagedByteBoolean(CAN_FLY);
    }

    public void setCanFly(boolean canFly) {
        this.setManagedByteBoolean(CAN_FLY, canFly);
        if (canFly) {
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.duckyAIFlyTowardsTargetAndAttack);
            this.field_70714_bg.func_75776_a(7, (EntityAIBase)this.duckyAIFollowOwnerFlying);
        } else {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.duckyAIFlyTowardsTargetAndAttack);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.duckyAIFollowOwnerFlying);
        }
    }

    public boolean isStrong() {
        return this.getManagedByteBoolean(STRENGTH);
    }

    public void setStrong(boolean strong) {
        this.setManagedByteBoolean(STRENGTH, strong);
        if (strong) {
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(40.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
        }
    }

    public boolean isFast() {
        return this.getManagedByteBoolean(SPEED);
    }

    public void setFast(boolean fast) {
        this.setManagedByteBoolean(SPEED, fast);
        if (fast) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.65);
            this.func_110148_a(SharedMonsterAttributes.field_193334_e).func_111128_a(0.65);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.35);
            this.func_110148_a(SharedMonsterAttributes.field_193334_e).func_111128_a(0.35);
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("FireProof", this.isFireProof());
        compound.func_74757_a("CanFly", this.isCanFly());
        compound.func_74757_a("Strong", this.isStrong());
        compound.func_74757_a("Fast", this.isFast());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setFireProof(compound.func_74767_n("FireProof"));
        this.setCanFly(compound.func_74767_n("CanFly"));
        this.setStrong(compound.func_74767_n("Strong"));
        this.setFast(compound.func_74767_n("Fast"));
    }

    protected int func_70693_a(EntityPlayer player) {
        return 10;
    }

    public boolean func_70601_bi() {
        return false;
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }

    public void func_98054_a(boolean child) {
        this.func_98055_j(1.0f);
    }

    public boolean isFlying() {
        return this.isFlying;
    }

    public void setFlying(boolean isFlying) {
        this.isFlying = isFlying;
        if (isFlying) {
            this.field_70699_by = this.flyingNavigator;
            this.field_70765_h = this.flyingMoveHelper;
        } else {
            this.field_70699_by = this.groundNavigator;
            this.field_70765_h = this.groundMoveHelper;
        }
    }

    public boolean isAttacking() {
        return this.isAttacking;
    }

    public void setAttacking(boolean isAttacking) {
        this.isAttacking = isAttacking;
    }

    public PathNavigate getGroundNavigator() {
        return this.groundNavigator;
    }

    public PathNavigate getFlyingNavigator() {
        return this.groundNavigator;
    }
}

