/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.minecraft.ducky.ai;

import com.blackducksoftware.integration.minecraft.ducky.EntityDucky;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;

public abstract class AbstractDuckyMoveAttack
extends EntityAIBase {
    protected static final double TELEPORT_RANGE = 24.0;
    private final EntityDucky ducky;
    private Entity targetToFollow;
    protected int attackTick;
    protected final int attackInterval = 20;
    protected float oldWaterCost;
    protected double distanceToTarget;
    protected double attackReach;
    protected int stuckTick;
    protected Vec3d lastPostion = null;

    public AbstractDuckyMoveAttack(EntityDucky ducky) {
        this.ducky = ducky;
    }

    public EntityDucky getDucky() {
        return this.ducky;
    }

    public Entity getTargetToFollow() {
        return this.targetToFollow;
    }

    public void setTargetToFollow(Entity targetToFollow) {
        this.targetToFollow = targetToFollow;
    }

    public void func_75249_e() {
        this.oldWaterCost = this.getDucky().func_184643_a(PathNodeType.WATER);
        this.getDucky().func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public void func_75251_c() {
        this.targetToFollow = null;
        this.getDucky().func_184644_a(PathNodeType.WATER, this.oldWaterCost);
    }

    protected boolean updateCalc(double distanceToTarget) {
        this.attackTick = Math.max(this.attackTick - 1, 0);
        ++this.stuckTick;
        return this.getTargetToFollow().func_70089_S();
    }

    protected double getSpeedModifier(double distanceToTarget) {
        double speedModifier = 1.0;
        if (this.attackReach > 0.0 && distanceToTarget < this.attackReach * 4.0) {
            speedModifier = 0.75;
        }
        return speedModifier;
    }

    public boolean isEmptyBlock(BlockPos pos) {
        IBlockState iblockstate = this.getDucky().field_70170_p.func_180495_p(pos);
        return iblockstate.func_185904_a() == Material.field_151579_a ? true : !iblockstate.func_185917_h();
    }

    public boolean needToFly(Entity target) {
        if (target == null) {
            return false;
        }
        PathNavigate navigator = this.ducky.getGroundNavigator();
        Path path = navigator.func_75505_d();
        boolean shouldFly = false;
        if (path == null) {
            path = navigator.func_75494_a(target);
        }
        if (path != null) {
            PathPoint pathpoint = path.func_75870_c();
            if (pathpoint == null) {
                shouldFly = true;
            } else {
                int i = MathHelper.func_76128_c((double)target.field_70163_u) - pathpoint.field_75837_b;
                shouldFly = !target.field_70122_E || (double)i > 1.5;
            }
        } else {
            shouldFly = true;
        }
        if (shouldFly) {
            navigator.func_75499_g();
        }
        return shouldFly;
    }

    protected double getAttackReachSqr(Entity target) {
        return 1.0f + this.ducky.field_70130_N * 2.0f * this.ducky.field_70130_N * 2.0f + target.field_70130_N / 4.0f;
    }

    protected void checkAndPerformAttack(Entity target, double distance) {
        if (target == null) {
            return;
        }
        double attackReach = this.getAttackReachSqr(target);
        if (distance <= attackReach && this.attackTick <= 0) {
            this.attackTick = 20;
            this.ducky.func_184609_a(EnumHand.MAIN_HAND);
            this.ducky.func_70652_k(target);
        }
    }

    protected boolean isDuckyStuck() {
        if (this.lastPostion == null) {
            this.lastPostion = this.getDucky().func_174791_d();
        } else if (this.stuckTick > 20) {
            this.stuckTick = 0;
            if (this.lastPostion.func_72436_e(this.getDucky().func_174791_d()) < 2.25) {
                return true;
            }
            this.lastPostion = this.getDucky().func_174791_d();
        }
        return false;
    }

    protected boolean relocateDuckyNearTarget() {
        int startingX = MathHelper.func_76128_c((double)this.getTargetToFollow().field_70165_t) - 2;
        int startingZ = MathHelper.func_76128_c((double)this.getTargetToFollow().field_70161_v) - 2;
        int startingY = MathHelper.func_76128_c((double)this.getTargetToFollow().func_174813_aQ().field_72338_b);
        for (int xAdjustment = 0; xAdjustment <= 4; ++xAdjustment) {
            for (int zAdjustment = 0; zAdjustment <= 4; ++zAdjustment) {
                if (xAdjustment >= 1 && zAdjustment >= 1 && xAdjustment <= 3 && zAdjustment <= 3) continue;
                BlockPos pos = new BlockPos(startingX + xAdjustment, startingY - 1, startingZ + zAdjustment);
                boolean isBlockBelowSolid = this.getDucky().field_70170_p.func_180495_p(pos).isSideSolid((IBlockAccess)this.getDucky().field_70170_p, pos, EnumFacing.UP);
                boolean isBlockEmpty = this.isEmptyBlock(new BlockPos(startingX + xAdjustment, startingY, startingZ + zAdjustment));
                boolean isBlockAboveEmpty = this.isEmptyBlock(new BlockPos(startingX + xAdjustment, startingY + 1, startingZ + zAdjustment));
                if (!isBlockBelowSolid || !isBlockEmpty || !isBlockAboveEmpty) continue;
                this.getDucky().func_70012_b((float)(startingX + xAdjustment) + 0.5f, startingY, (float)(startingZ + zAdjustment) + 0.5f, this.getDucky().field_70177_z, this.getDucky().field_70125_A);
                return true;
            }
        }
        return false;
    }

    public BlockPos getPositionBelowTarget() {
        BlockPos location = null;
        if (this.getTargetToFollow().field_70122_E) {
            location = new BlockPos(this.getTargetToFollow().field_70165_t, this.getTargetToFollow().field_70163_u, this.getTargetToFollow().field_70161_v);
        } else {
            for (double i = this.getTargetToFollow().field_70163_u; i > 0.0; i -= 1.0) {
                BlockPos currentLocation = new BlockPos(this.getTargetToFollow().field_70165_t, i, this.getTargetToFollow().field_70161_v);
                IBlockState blockstate = this.getDucky().field_70170_p.func_180495_p(currentLocation);
                if (blockstate.func_185904_a() == Material.field_151579_a && !blockstate.func_185917_h()) continue;
                location = currentLocation;
                break;
            }
        }
        return location;
    }
}

