/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.minecraft.ducky.ai;

import com.blackducksoftware.integration.minecraft.ducky.EntityDucky;
import com.blackducksoftware.integration.minecraft.ducky.ai.AbstractDuckyMoveAttack;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;

public class DuckyAIFlyTowardsTargetAndAttack
extends AbstractDuckyMoveAttack {
    private final float maxTargetDistance;
    private final long memoryLength;
    private long targetLastSeen = 0L;

    public DuckyAIFlyTowardsTargetAndAttack(EntityDucky creature, float targetMaxDistance, long memoryLength) {
        super(creature);
        this.maxTargetDistance = targetMaxDistance;
        this.func_75248_a(3);
        this.memoryLength = memoryLength;
    }

    public boolean func_75250_a() {
        EntityLivingBase target = this.getDucky().func_70638_az();
        if (target == null || !this.getDucky().canMove()) {
            return false;
        }
        this.setTargetToFollow((Entity)target);
        this.distanceToTarget = this.getDucky().func_70068_e((Entity)target);
        this.attackReach = this.getAttackReachSqr((Entity)target);
        this.checkAndPerformAttack((Entity)target, this.distanceToTarget);
        if (this.distanceToTarget < (double)(this.maxTargetDistance * this.maxTargetDistance) && this.needToFly((Entity)target)) {
            this.getDucky().setFlying(true);
            this.getDucky().setAttacking(true);
            return true;
        }
        return false;
    }

    public boolean func_75253_b() {
        if (!this.getTargetToFollow().func_70089_S() || !this.getDucky().canMove()) {
            this.getDucky().setFlying(false);
            this.getDucky().setAttacking(false);
            return false;
        }
        if (this.getDucky().func_70068_e(this.getTargetToFollow()) < (double)(this.maxTargetDistance * this.maxTargetDistance) && this.needToFly(this.getTargetToFollow())) {
            this.distanceToTarget = this.getDucky().func_70068_e(this.getTargetToFollow());
            this.checkAndPerformAttack(this.getTargetToFollow(), this.distanceToTarget);
            if (this.targetLastSeen < this.memoryLength) {
                return true;
            }
        }
        this.getDucky().setFlying(false);
        this.getDucky().setAttacking(false);
        return false;
    }

    public void func_75246_d() {
        if (!this.updateCalc(this.distanceToTarget)) {
            return;
        }
        this.targetLastSeen = !this.getDucky().func_70685_l(this.getTargetToFollow()) ? ++this.targetLastSeen : 0L;
        double speedModifier = this.getSpeedModifier(this.distanceToTarget);
        this.getDucky().func_70661_as().func_75497_a(this.getTargetToFollow(), speedModifier);
        this.getDucky().func_70625_a(this.getTargetToFollow(), this.getDucky().func_184649_cE(), this.getDucky().func_70646_bf());
        this.getDucky().func_70671_ap().func_75651_a(this.getTargetToFollow(), (float)this.getDucky().func_184649_cE(), (float)this.getDucky().func_70646_bf());
        this.checkAndPerformAttack(this.getTargetToFollow(), this.distanceToTarget);
    }
}

