/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.minecraft.ducky.ai;

import com.blackducksoftware.integration.minecraft.ducky.EntityDucky;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class DuckyAIPanic
extends EntityAIBase {
    protected final EntityDucky ducky;
    protected final double speed;
    protected double randPosX;
    protected double randPosY;
    protected double randPosZ;

    public DuckyAIPanic(EntityDucky ducky, double speedIn) {
        this.ducky = ducky;
        this.speed = speedIn;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        if (this.ducky.func_70027_ad()) {
            BlockPos blockpos = this.getRandomWaterPosition(this.ducky.field_70170_p, (Entity)this.ducky, 15, 6);
            if (blockpos != null) {
                this.randPosX = blockpos.func_177958_n();
                this.randPosY = blockpos.func_177956_o();
                this.randPosZ = blockpos.func_177952_p();
                this.ducky.func_70661_as().func_75492_a(this.randPosX, this.randPosY, this.randPosZ, this.speed);
                return true;
            }
            if (this.findAndSetRandomPosition()) {
                this.ducky.func_70661_as().func_75492_a(this.randPosX, this.randPosY, this.randPosZ, this.speed);
            }
        }
        return false;
    }

    protected boolean findAndSetRandomPosition() {
        Vec3d vec3d = RandomPositionGenerator.func_75463_a((EntityCreature)this.ducky, (int)5, (int)4);
        if (vec3d == null) {
            return false;
        }
        this.randPosX = vec3d.field_72450_a;
        this.randPosY = vec3d.field_72448_b;
        this.randPosZ = vec3d.field_72449_c;
        return true;
    }

    public void func_75249_e() {
        this.ducky.func_70661_as().func_75492_a(this.randPosX, this.randPosY, this.randPosZ, this.speed);
    }

    public boolean func_75253_b() {
        return !this.ducky.func_70661_as().func_75500_f();
    }

    @Nullable
    private BlockPos getRandomWaterPosition(World worldIn, Entity entityIn, int horizontalRange, int verticalRange) {
        BlockPos blockpos = new BlockPos(entityIn);
        int x = blockpos.func_177958_n();
        int y = blockpos.func_177956_o();
        int z = blockpos.func_177952_p();
        float f = horizontalRange * horizontalRange * verticalRange * 2;
        BlockPos randomPosition = null;
        BlockPos.MutableBlockPos mutablePosition = new BlockPos.MutableBlockPos();
        for (int l = x - horizontalRange; l <= x + horizontalRange; ++l) {
            block1: for (int i1 = y - verticalRange; i1 <= y + verticalRange; ++i1) {
                for (int j1 = z - horizontalRange; j1 <= z + horizontalRange; ++j1) {
                    float f1;
                    mutablePosition.func_181079_c(l, i1, j1);
                    IBlockState iblockstate = worldIn.func_180495_p((BlockPos)mutablePosition);
                    if (iblockstate.func_185904_a() != Material.field_151586_h || !((f1 = (float)((l - x) * (l - x) + (i1 - y) * (i1 - y) + (j1 - z) * (j1 - z))) < f)) continue;
                    f = f1;
                    randomPosition = new BlockPos((Vec3i)mutablePosition);
                    continue block1;
                }
            }
        }
        return randomPosition;
    }
}

