/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.minecraft.ducky.ai;

import com.google.common.base.Predicate;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.util.math.AxisAlignedBB;

public class DuckyAIWatchTarget
extends EntityAIBase {
    protected EntityLiving theWatcher;
    protected Entity closestEntity;
    protected float maxDistance;
    private int lookTime;
    private final float chance;
    protected Predicate<EntityLivingBase> watchedClassSelector;
    protected EntityAINearestAttackableTarget.Sorter theNearestAttackableTargetSorter;

    public DuckyAIWatchTarget(EntityLiving theWatcher, @Nullable Predicate<EntityLivingBase> watchedClassSelector, float maxDistance, int lookTime) {
        this(theWatcher, watchedClassSelector, maxDistance, lookTime, 0.02f);
    }

    public DuckyAIWatchTarget(EntityLiving theWatcher, @Nullable Predicate<EntityLivingBase> watchedClassSelector, float maxDistance, int lookTime, float chanceIn) {
        this.theWatcher = theWatcher;
        this.watchedClassSelector = watchedClassSelector;
        this.maxDistance = maxDistance;
        this.chance = chanceIn;
        this.func_75248_a(5);
        this.lookTime = lookTime;
        this.theNearestAttackableTargetSorter = new EntityAINearestAttackableTarget.Sorter((Entity)theWatcher);
    }

    public boolean func_75250_a() {
        List list;
        if (this.theWatcher.func_70681_au().nextFloat() >= this.chance) {
            return false;
        }
        if (this.theWatcher.func_70638_az() != null) {
            this.closestEntity = this.theWatcher.func_70638_az();
        }
        if ((list = this.theWatcher.field_70170_p.func_175647_a(EntityLiving.class, this.getTargetableArea(this.maxDistance), this.watchedClassSelector)).isEmpty()) {
            return false;
        }
        Collections.sort(list, this.theNearestAttackableTargetSorter);
        this.closestEntity = (Entity)list.get(0);
        return true;
    }

    protected AxisAlignedBB getTargetableArea(double targetDistance) {
        return this.theWatcher.func_174813_aQ().func_72321_a(targetDistance, 4.0, targetDistance);
    }

    public boolean func_75253_b() {
        return !this.closestEntity.func_70089_S() ? false : (this.theWatcher.func_70068_e(this.closestEntity) > (double)(this.maxDistance * this.maxDistance) ? false : this.lookTime > 0);
    }

    public void func_75249_e() {
        if (this.lookTime == 0) {
            this.lookTime = 40 + this.theWatcher.func_70681_au().nextInt(40);
        }
    }

    public void func_75251_c() {
        this.closestEntity = null;
    }

    public void func_75246_d() {
        this.theWatcher.func_70671_ap().func_75650_a(this.closestEntity.field_70165_t, this.closestEntity.field_70163_u + (double)this.closestEntity.func_70047_e(), this.closestEntity.field_70161_v, (float)this.theWatcher.func_184649_cE(), (float)this.theWatcher.func_70646_bf());
        --this.lookTime;
    }
}

