/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.minecraft.ducky.pathfinding;

import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.pathfinding.FlyingNodeProcessor;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class DuckyFlyingNodeProcessor
extends FlyingNodeProcessor {
    public boolean isDirectPathBetweenPoints(EntityLiving entity, double currentPositionX, double currentPositionY, double currentPositionZ, double targetPositionX, double targetPositionY, double targetPositionZ) {
        Vec3d currentPosition = new Vec3d(currentPositionX, currentPositionY, currentPositionZ);
        Vec3d targetPosition = new Vec3d(targetPositionX, targetPositionY, targetPositionZ);
        return this.isDirectPathBetweenPoints(entity, currentPosition, targetPosition);
    }

    public boolean isDirectPathBetweenPoints(EntityLiving entity, Vec3d currentPosition, Vec3d targetPosition) {
        double xDifference = targetPosition.field_72450_a - currentPosition.field_72450_a;
        double yDifference = targetPosition.field_72448_b - currentPosition.field_72448_b;
        double zDifference = targetPosition.field_72449_c - currentPosition.field_72449_c;
        double distanceToTargetSquared = xDifference * xDifference + yDifference * yDifference + zDifference * zDifference;
        if (distanceToTargetSquared < 1.0) {
            return true;
        }
        Vec3d vectorToTarget = targetPosition.func_178788_d(currentPosition);
        double increment = 1.0 / distanceToTargetSquared;
        for (double f = 0.0; f < 1.0; f += increment) {
            Vec3d vectorToAdd = new Vec3d(vectorToTarget.field_72450_a * f, vectorToTarget.field_72448_b * f, vectorToTarget.field_72449_c * f);
            Vec3d currentAdjusted = currentPosition.func_178787_e(vectorToAdd);
            BlockPos position = new BlockPos(currentAdjusted.field_72450_a, currentAdjusted.field_72448_b, currentAdjusted.field_72449_c);
            IBlockState iblockstate = entity.field_70170_p.func_180495_p(position);
            if (iblockstate.func_185904_a() == Material.field_151579_a && !iblockstate.func_185917_h()) continue;
            return false;
        }
        return true;
    }

    public int func_186320_a(PathPoint[] pathOptions, PathPoint currentPoint, PathPoint targetPoint, float maxDistance) {
        if (this.isDirectPathBetweenPoints(this.field_186326_b, currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c, targetPoint.field_75839_a, targetPoint.field_75837_b, targetPoint.field_75838_c)) {
            int i = 0;
            Vec3d currentPosition = new Vec3d((double)currentPoint.field_75839_a, (double)currentPoint.field_75837_b, (double)currentPoint.field_75838_c);
            Vec3d targetPosition = new Vec3d((double)targetPoint.field_75839_a, (double)targetPoint.field_75837_b, (double)targetPoint.field_75838_c);
            Vec3d vector = targetPosition.func_178788_d(currentPosition);
            vector = vector.func_72432_b().func_186678_a(1.5);
            Vec3d pathPointVector = currentPosition.func_178787_e(vector);
            PathPoint pathpoint = this.func_176159_a((int)pathPointVector.field_72450_a, (int)pathPointVector.field_72448_b, (int)pathPointVector.field_72449_c);
            if (pathpoint != null && !pathpoint.field_75842_i && pathpoint.func_75829_a(targetPoint) < maxDistance) {
                pathOptions[i++] = pathpoint;
            }
            return i;
        }
        return super.func_186320_a(pathOptions, currentPoint, targetPoint, maxDistance);
    }
}

