/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.minecraft.ducky.tamed;

import com.blackducksoftware.integration.minecraft.ducky.AbstractCommonModel;
import com.blackducksoftware.integration.minecraft.ducky.EntityDucky;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelTamedDucky
extends AbstractCommonModel {
    public ModelRenderer head = this.createNewModelRenderer(0, 0, -2.0f, -6.0f, -2.0f, 4, 6, 3, 0.0f, 15.0f, -4.0f);
    public ModelRenderer hatTop = this.createNewModelRenderer(40, 1, -2.5f, -7.0f, -2.0f, 5, 1, 4, 0.0f, 15.0f, -4.0f);
    public ModelRenderer hatBottom = this.createNewModelRenderer(39, 0, -2.5f, -6.0f, -3.0f, 5, 1, 5, 0.0f, 15.0f, -4.0f);
    public ModelRenderer fireProofHatTop = this.createNewModelRenderer(40, 8, -2.5f, -7.0f, -2.0f, 5, 1, 4, 0.0f, 15.0f, -4.0f);
    public ModelRenderer fireProofHatBottom = this.createNewModelRenderer(39, 7, -2.5f, -6.0f, -3.0f, 5, 1, 5, 0.0f, 15.0f, -4.0f);
    public ModelRenderer body;
    public ModelRenderer rightLeg;
    public ModelRenderer leftLeg;
    public ModelRenderer fastRightLeg;
    public ModelRenderer fastLeftLeg;
    public ModelRenderer rightWing;
    public ModelRenderer leftWing;
    public ModelRenderer flyingRightWing;
    public ModelRenderer flyingLeftWing;
    public ModelRenderer bill = this.createNewModelRenderer(14, 0, -2.0f, -4.0f, -4.0f, 4, 2, 2, 0.0f, 15.0f, -4.0f);
    public ModelRenderer strongBill = this.createNewModelRenderer(12, 24, -2.0f, -4.0f, -4.0f, 4, 2, 2, 0.0f, 15.0f, -4.0f);
    public ModelRenderer tail;

    public ModelTamedDucky() {
        super(64, 32);
        this.body = this.createNewModelRenderer(0, 9, -3.0f, -4.0f, -3.0f, 6, 8, 6, 0.0f, 16.0f, 0.0f);
        this.tail = this.createNewModelRenderer(14, 4, -1.0f, 3.0f, 2.5f, 2, 2, 2, 0.0f, 16.0f, 0.0f);
        this.rightWing = this.createNewModelRenderer(24, 13, 0.0f, 0.0f, -3.0f, 1, 4, 6, -4.0f, 13.0f, 0.0f);
        this.leftWing = this.createNewModelRenderer(24, 13, -1.0f, 0.0f, -3.0f, 1, 4, 6, 4.0f, 13.0f, 0.0f);
        this.flyingRightWing = this.createNewModelRenderer(39, 13, 0.0f, 0.0f, -3.0f, 1, 4, 6, -4.0f, 13.0f, 0.0f);
        this.flyingLeftWing = this.createNewModelRenderer(39, 13, -1.0f, 0.0f, -3.0f, 1, 4, 6, 4.0f, 13.0f, 0.0f);
        this.rightLeg = this.createNewModelRenderer(26, 0, -1.0f, 0.0f, -3.0f, 3, 5, 3, -2.0f, 19.0f, 1.0f);
        this.leftLeg = this.createNewModelRenderer(26, 0, -1.0f, 0.0f, -3.0f, 3, 5, 3, 1.0f, 19.0f, 1.0f);
        this.fastRightLeg = this.createNewModelRenderer(0, 24, -1.0f, 0.0f, -3.0f, 3, 5, 3, -2.0f, 19.0f, 1.0f);
        this.fastLeftLeg = this.createNewModelRenderer(0, 24, -1.0f, 0.0f, -3.0f, 3, 5, 3, 1.0f, 19.0f, 1.0f);
        this.hideModelRenderers(this.fireProofHatTop, this.fireProofHatBottom, this.flyingLeftWing, this.flyingRightWing, this.strongBill, this.fastLeftLeg, this.fastRightLeg);
    }

    public void func_78088_a(Entity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        EntityDucky entityDucky = (EntityDucky)entityIn;
        if (entityDucky.isFireProof()) {
            this.showModelRenderers(this.fireProofHatTop, this.fireProofHatBottom);
            this.hideModelRenderers(this.hatTop, this.hatBottom);
        } else {
            this.showModelRenderers(this.hatTop, this.hatBottom);
            this.hideModelRenderers(this.fireProofHatTop, this.fireProofHatBottom);
        }
        if (entityDucky.isCanFly()) {
            this.showModelRenderers(this.flyingLeftWing, this.flyingRightWing);
            this.hideModelRenderers(this.rightWing, this.leftWing);
        } else {
            this.showModelRenderers(this.rightWing, this.leftWing);
            this.hideModelRenderers(this.flyingLeftWing, this.flyingRightWing);
        }
        if (entityDucky.isStrong()) {
            this.showModelRenderers(this.strongBill);
            this.hideModelRenderers(this.bill);
        } else {
            this.showModelRenderers(this.bill);
            this.hideModelRenderers(this.strongBill);
        }
        if (entityDucky.isFast()) {
            this.showModelRenderers(this.fastLeftLeg, this.fastRightLeg);
            this.hideModelRenderers(this.rightLeg, this.leftLeg);
        } else {
            this.showModelRenderers(this.rightLeg, this.leftLeg);
            this.hideModelRenderers(this.fastLeftLeg, this.fastRightLeg);
        }
        this.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale, entityIn);
        this.head.func_78785_a(scale);
        this.hatTop.func_78785_a(scale);
        this.hatBottom.func_78785_a(scale);
        this.fireProofHatTop.func_78785_a(scale);
        this.fireProofHatBottom.func_78785_a(scale);
        this.bill.func_78785_a(scale);
        this.strongBill.func_78785_a(scale);
        this.body.func_78785_a(scale);
        this.tail.func_78785_a(scale);
        this.rightLeg.func_78785_a(scale);
        this.leftLeg.func_78785_a(scale);
        this.fastLeftLeg.func_78785_a(scale);
        this.fastRightLeg.func_78785_a(scale);
        this.rightWing.func_78785_a(scale);
        this.leftWing.func_78785_a(scale);
        this.flyingLeftWing.func_78785_a(scale);
        this.flyingRightWing.func_78785_a(scale);
    }

    public void func_78086_a(EntityLivingBase entitylivingbaseIn, float limbSwingAmount, float ageInTicks, float partialTickTime) {
        EntityDucky entityDucky = (EntityDucky)entitylivingbaseIn;
        if (entityDucky.func_70906_o()) {
            this.setRotationPoint(0.0f, 20.0f, -4.0f, this.head, this.hatTop, this.hatBottom, this.fireProofHatTop, this.fireProofHatBottom, this.bill, this.strongBill);
            this.setRotationPoint(0.0f, 21.0f, 0.0f, this.tail, this.body);
            this.setRotationPoint(-4.0f, 18.0f, 0.0f, this.rightWing, this.flyingRightWing);
            this.setRotationPoint(4.0f, 18.0f, 0.0f, this.leftWing, this.flyingLeftWing);
            this.setRotationPoint(-2.0f, 18.9f, 1.0f, this.rightLeg, this.fastRightLeg);
            this.setRotationPoint(1.0f, 18.9f, 1.0f, this.leftLeg, this.fastLeftLeg);
        } else {
            this.setRotationPoint(0.0f, 15.0f, -4.0f, this.head, this.hatTop, this.hatBottom, this.fireProofHatTop, this.fireProofHatBottom, this.bill, this.strongBill);
            this.setRotationPoint(0.0f, 16.0f, 0.0f, this.tail, this.body);
            this.setRotationPoint(-4.0f, 13.0f, 0.0f, this.rightWing, this.flyingRightWing);
            this.setRotationPoint(4.0f, 13.0f, 0.0f, this.leftWing, this.flyingLeftWing);
            this.setRotationPoint(-2.0f, 19.0f, 1.0f, this.rightLeg, this.fastRightLeg);
            this.setRotationPoint(1.0f, 19.0f, 1.0f, this.leftLeg, this.fastLeftLeg);
        }
    }

    public void func_78087_a(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, Entity entityIn) {
        this.head.field_78795_f = headPitch * ((float)Math.PI / 180);
        this.head.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
        this.duplicateModelRotationAngles(this.head, this.hatTop, this.hatBottom, this.bill, this.strongBill, this.fireProofHatBottom, this.fireProofHatTop);
        this.body.field_78795_f = 1.5707964f;
        this.duplicateModelRotationAngles(this.body, this.tail);
        this.rightLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.duplicateModelRotationAngles(this.rightLeg, this.fastRightLeg);
        this.duplicateModelRotationAngles(this.leftLeg, this.fastLeftLeg);
        this.rightWing.field_78808_h = ageInTicks;
        this.leftWing.field_78808_h = -ageInTicks;
        this.duplicateModelRotationAngles(this.rightWing, this.flyingRightWing);
        this.duplicateModelRotationAngles(this.leftWing, this.flyingLeftWing);
    }
}

