/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.render;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class IconUtil {
    public static IconUtil instance = new IconUtil();
    private ArrayList<IIconProvider> iconProviders = new ArrayList();
    public TextureAtlasSprite whiteTexture;
    public TextureAtlasSprite blankTexture;
    public TextureAtlasSprite errorTexture;
    private boolean doneInit = false;

    public static void addIconProvider(IIconProvider registrar) {
        IconUtil.instance.iconProviders.add(registrar);
    }

    private IconUtil() {
    }

    public void init() {
        if (this.doneInit) {
            return;
        }
        this.doneInit = true;
        MinecraftForge.EVENT_BUS.register((Object)this);
        IconUtil.addIconProvider(new IIconProvider(){

            @Override
            public void registerIcons(TextureMap register) {
                IconUtil.this.whiteTexture = register.func_174942_a(new ResourceLocation("endercore", "white"));
                IconUtil.this.errorTexture = register.func_174942_a(new ResourceLocation("endercore", "error"));
                IconUtil.this.blankTexture = register.func_174942_a(new ResourceLocation("endercore", "blank"));
            }
        });
    }

    @SubscribeEvent
    public void onIconLoad(TextureStitchEvent.Pre event) {
        for (IIconProvider reg : this.iconProviders) {
            reg.registerIcons(event.getMap());
        }
    }

    public static TextureAtlasSprite getIconForItem(int itemId, int meta) {
        Item item = Item.func_150899_d((int)itemId);
        if (item == null) {
            return null;
        }
        return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178087_a(item, meta);
    }

    public static interface IIconProvider {
        public void registerIcons(TextureMap var1);
    }
}

