/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.config.ConfigHandler;
import com.integral.enigmaticlegacy.entities.UltimateWitherSkullEntity;
import com.integral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.integral.enigmaticlegacy.helpers.IPerhaps;
import com.integral.enigmaticlegacy.helpers.LoreHelper;
import com.integral.enigmaticlegacy.helpers.Vector3;
import com.integral.enigmaticlegacy.packets.clients.PacketPlayerMotion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.ControlsScreen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.entity.projectile.WitherSkullEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.PacketDistributor;
import top.theillusivec4.curios.api.capability.ICurio;

public class AngelBlessing
extends Item
implements ICurio,
IPerhaps {
    public static Item.Properties integratedProperties = new Item.Properties();
    public static List<String> immunityList = new ArrayList<String>();
    public static HashMap<String, Float> resistanceList = new HashMap();
    public static double range = 4.0;

    public AngelBlessing(Item.Properties properties) {
        super(properties);
        immunityList.add(DamageSource.field_76379_h.field_76373_n);
        immunityList.add(DamageSource.field_188406_j.field_76373_n);
    }

    public static Item.Properties setupIntegratedProperties() {
        integratedProperties.func_200916_a(EnigmaticLegacy.enigmaticTab);
        integratedProperties.func_200917_a(1);
        integratedProperties.func_208103_a(Rarity.RARE);
        return integratedProperties;
    }

    @Override
    public boolean isForMortals() {
        return ConfigHandler.ANGEL_BLESSING_ENABLED.getValue();
    }

    public boolean canEquip(String identifier, LivingEntity living) {
        return !SuperpositionHandler.hasCurio(living, EnigmaticLegacy.angelBlessing);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        if (ControlsScreen.hasShiftDown()) {
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.angelBlessing1");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.angelBlessing2");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.angelBlessingCooldown", Float.valueOf((float)ConfigHandler.ANGEL_BLESSING_COOLDOWN.getValue() / 20.0f));
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.angelBlessing3");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.angelBlessing4");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.angelBlessing5");
        } else {
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
        try {
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.currentKeybind", ((String)KeyBinding.func_193626_b((String)"key.spellstoneAbility").get()).toUpperCase());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void triggerActiveAbility(World world, PlayerEntity player, ItemStack stack) {
        if (SuperpositionHandler.hasSpellstoneCooldown(player)) {
            return;
        }
        Vector3 accelerationVec = new Vector3(player.func_70040_Z());
        Vector3 motionVec = new Vector3(player.func_213322_ci());
        if (player.func_184613_cA()) {
            accelerationVec = accelerationVec.multiply(ConfigHandler.ANGEL_BLESSING_ACCELERATION_MODIFIER_ELYTRA.getValue());
            accelerationVec = accelerationVec.multiply(1.0 / (motionVec.mag() * 2.25));
        } else {
            accelerationVec = accelerationVec.multiply(ConfigHandler.ANGEL_BLESSING_ACCELERATION_MODIFIER.getValue());
        }
        Vector3 finalMotion = new Vector3(motionVec.x + accelerationVec.x, motionVec.y + accelerationVec.y, motionVec.z + accelerationVec.z);
        EnigmaticLegacy.packetInstance.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new PacketPlayerMotion(finalMotion.x, finalMotion.y, finalMotion.z));
        player.func_213293_j(finalMotion.x, finalMotion.y, finalMotion.z);
        world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187528_aR, SoundCategory.NEUTRAL, 1.0f, (float)((double)0.6f + Math.random() * 0.1));
        SuperpositionHandler.setSpellstoneCooldown(player, ConfigHandler.ANGEL_BLESSING_COOLDOWN.getValue());
    }

    public void onCurioTick(String identifier, LivingEntity living) {
        List projectileEntities = living.field_70170_p.func_217357_a(DamagingProjectileEntity.class, new AxisAlignedBB(living.field_70165_t - range, living.field_70163_u - range, living.field_70161_v - range, living.field_70165_t + range, living.field_70163_u + range, living.field_70161_v + range));
        List arrowEntities = living.field_70170_p.func_217357_a(AbstractArrowEntity.class, new AxisAlignedBB(living.field_70165_t - range, living.field_70163_u - range, living.field_70161_v - range, living.field_70165_t + range, living.field_70163_u + range, living.field_70161_v + range));
        List potionEntities = living.field_70170_p.func_217357_a(PotionEntity.class, new AxisAlignedBB(living.field_70165_t - range, living.field_70163_u - range, living.field_70161_v - range, living.field_70165_t + range, living.field_70163_u + range, living.field_70161_v + range));
        for (DamagingProjectileEntity entity : projectileEntities) {
            this.redirect(living, (Entity)entity);
        }
        for (DamagingProjectileEntity entity : arrowEntities) {
            this.redirect(living, (Entity)entity);
        }
        for (DamagingProjectileEntity entity : potionEntities) {
            this.redirect(living, (Entity)entity);
        }
    }

    public void redirect(LivingEntity bearer, Entity redirected) {
        if (redirected instanceof UltimateWitherSkullEntity || redirected instanceof WitherSkullEntity) {
            return;
        }
        Vector3 entityPos = Vector3.fromEntityCenter(redirected);
        Vector3 bearerPos = Vector3.fromEntityCenter((Entity)bearer);
        Vector3 redirection = entityPos.subtract(bearerPos);
        redirection = redirection.normalize();
        redirected.func_213293_j(redirection.x, redirection.y, redirection.z);
        if (redirected instanceof DamagingProjectileEntity) {
            DamagingProjectileEntity redirectedProjectile = (DamagingProjectileEntity)redirected;
            redirectedProjectile.field_70232_b = redirection.x / 4.0;
            redirectedProjectile.field_70233_c = redirection.y / 4.0;
            redirectedProjectile.field_70230_d = redirection.z / 4.0;
        }
    }

    public boolean canRightClickEquip() {
        return true;
    }

    public void onEquipped(String identifier, LivingEntity entityLivingBase) {
    }

    public void onUnequipped(String identifier, LivingEntity entityLivingBase) {
    }
}

