/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.config.ConfigHandler;
import com.integral.enigmaticlegacy.helpers.IPerhaps;
import com.integral.enigmaticlegacy.helpers.LoreHelper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.ControlsScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EtheriumArmor
extends ArmorItem
implements IPerhaps {
    public EtheriumArmor(IArmorMaterial materialIn, EquipmentSlotType slot, Item.Properties builder) {
        super(materialIn, slot, builder);
    }

    public static Item.Properties setupIntegratedProperties() {
        Item.Properties properties = new Item.Properties();
        properties.func_200916_a(EnigmaticLegacy.enigmaticTab);
        properties.func_208103_a(Rarity.RARE);
        return properties;
    }

    public static boolean hasFullSet(@Nonnull PlayerEntity player) {
        if (player == null) {
            return false;
        }
        for (ItemStack stack : player.func_184193_aE()) {
            if (stack.func_77973_b() instanceof EtheriumArmor) continue;
            return false;
        }
        return true;
    }

    public static boolean hasShield(@Nonnull PlayerEntity player) {
        return player != null && EtheriumArmor.hasFullSet(player) && (double)(player.func_110143_aJ() / player.func_110138_aP()) <= ConfigHandler.ETHERIUM_ARMOR_SHIELD_THRESHOLD.getValue().asMultiplier(false);
    }

    @Override
    public boolean isForMortals() {
        return ConfigHandler.ETHERIUM_ARMOR_ENABLED.getValue();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        if (ControlsScreen.hasShiftDown()) {
            if (stack.func_77973_b().equals(EnigmaticLegacy.etheriumHelmet)) {
                LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumHelmet1");
            } else if (stack.func_77973_b().equals(EnigmaticLegacy.etheriumChestplate)) {
                LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumChestplate1");
            } else if (stack.func_77973_b().equals(EnigmaticLegacy.etheriumLeggings)) {
                LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumLeggings1");
            } else if (stack.func_77973_b().equals(EnigmaticLegacy.etheriumBoots)) {
                LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumBoots1");
            }
        } else {
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
        if (EtheriumArmor.hasFullSet((PlayerEntity)Minecraft.func_71410_x().field_71439_g)) {
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumArmorSetBonus1");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumArmorSetBonus2", ConfigHandler.ETHERIUM_ARMOR_SHIELD_THRESHOLD.getValue().asPercentage() + "%");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumArmorSetBonus3");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumArmorSetBonus4", ConfigHandler.ETHERIUM_ARMOR_SHIELD_REDUCTION.getValue().asPercentage() + "%");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumArmorSetBonus5");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumArmorSetBonus6");
        }
        if (stack.func_77948_v()) {
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        }
    }
}

