/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.config.ConfigHandler;
import com.integral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.integral.enigmaticlegacy.helpers.IPerhaps;
import com.integral.enigmaticlegacy.helpers.LoreHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.ControlsScreen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import top.theillusivec4.curios.api.capability.ICurio;

public class GolemHeart
extends Item
implements ICurio,
IPerhaps {
    public static Item.Properties integratedProperties = new Item.Properties();
    public static List<String> immunityList = new ArrayList<String>();
    public static HashMap<String, Supplier<Float>> resistanceList = new HashMap();
    public static Multimap<String, AttributeModifier> attributesDefault = HashMultimap.create();
    public static Multimap<String, AttributeModifier> attributesNoArmor = HashMultimap.create();

    public GolemHeart(Item.Properties properties) {
        super(properties);
        immunityList.add(DamageSource.field_76367_g.field_76373_n);
        immunityList.add(DamageSource.field_191291_g.field_76373_n);
        immunityList.add(DamageSource.field_76368_d.field_76373_n);
        immunityList.add(DamageSource.field_82729_p.field_76373_n);
        immunityList.add(DamageSource.field_220302_v.field_76373_n);
        resistanceList.put(DamageSource.field_76377_j.field_76373_n, () -> Float.valueOf(ConfigHandler.GOLEM_HEART_MELEE_RESISTANCE.getValue().asModifierInverted()));
        resistanceList.put("mob", () -> Float.valueOf(ConfigHandler.GOLEM_HEART_MELEE_RESISTANCE.getValue().asModifierInverted()));
        resistanceList.put("explosion", () -> Float.valueOf(ConfigHandler.GOLEM_HEART_EXPLOSION_RESISTANCE.getValue().asModifierInverted()));
        resistanceList.put("explosion.player", () -> Float.valueOf(ConfigHandler.GOLEM_HEART_EXPLOSION_RESISTANCE.getValue().asModifierInverted()));
        resistanceList.put("player", () -> Float.valueOf(ConfigHandler.GOLEM_HEART_MELEE_RESISTANCE.getValue().asModifierInverted()));
        resistanceList.put(DamageSource.field_76376_m.field_76373_n, () -> Float.valueOf((float)ConfigHandler.GOLEM_HEART_VULNERABILITY_MODIFIER.getValue()));
        resistanceList.put(DamageSource.field_188407_q.field_76373_n, () -> Float.valueOf((float)ConfigHandler.GOLEM_HEART_VULNERABILITY_MODIFIER.getValue()));
    }

    public static Item.Properties setupIntegratedProperties() {
        integratedProperties.func_200916_a(EnigmaticLegacy.enigmaticTab);
        integratedProperties.func_200917_a(1);
        integratedProperties.func_208103_a(Rarity.UNCOMMON);
        return integratedProperties;
    }

    public boolean canEquip(String identifier, LivingEntity living) {
        return !SuperpositionHandler.hasCurio(living, EnigmaticLegacy.golemHeart);
    }

    public static void initAttributes() {
        attributesDefault.put((Object)SharedMonsterAttributes.field_188791_g.func_111108_a(), (Object)new AttributeModifier(UUID.fromString("15faf191-bf21-4654-b359-cc1f4f1243bf"), "GolemHeart DAB", ConfigHandler.GOLEM_HEART_DEFAULT_ARMOR.getValue(), AttributeModifier.Operation.ADDITION));
        attributesDefault.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)new AttributeModifier(UUID.fromString("10faf191-bf21-4554-b359-cc1f4f1233bf"), "GolemHeart KR", (double)ConfigHandler.GOLEM_HEART_KNOCKBACK_RESISTANCE.getValue().asModifier(false), AttributeModifier.Operation.ADDITION));
        attributesNoArmor.put((Object)SharedMonsterAttributes.field_188791_g.func_111108_a(), (Object)new AttributeModifier(UUID.fromString("14faf191-bf23-4654-b359-cc1f4f1243bf"), "GolemHeart SAB", ConfigHandler.GOLEM_HEART_SUPER_ARMOR.getValue(), AttributeModifier.Operation.ADDITION));
        attributesNoArmor.put((Object)SharedMonsterAttributes.field_189429_h.func_111108_a(), (Object)new AttributeModifier(UUID.fromString("11faf181-bf23-4354-b359-cc1f5f1253bf"), "GolemHeart STB", ConfigHandler.GOLEM_HEART_SUPER_ARMOR_TOUGHNESS.getValue(), AttributeModifier.Operation.ADDITION));
        attributesNoArmor.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)new AttributeModifier(UUID.fromString("12faf181-bf21-4554-b359-cc1f4f1254bf"), "GolemHeart KR", (double)ConfigHandler.GOLEM_HEART_KNOCKBACK_RESISTANCE.getValue().asModifier(false), AttributeModifier.Operation.ADDITION));
    }

    @Override
    public boolean isForMortals() {
        return ConfigHandler.GOLEM_HEART_ENABLED.getValue();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        if (ControlsScreen.hasShiftDown()) {
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.golemHeart1");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.golemHeart2");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.golemHeartCooldown", Float.valueOf((float)ConfigHandler.GOLEM_HEART_COOLDOWN.getValue() / 20.0f));
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.golemHeart3");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.golemHeart4", (int)ConfigHandler.GOLEM_HEART_DEFAULT_ARMOR.getValue());
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.golemHeart5");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.golemHeart6", (int)ConfigHandler.GOLEM_HEART_SUPER_ARMOR.getValue(), (int)ConfigHandler.GOLEM_HEART_SUPER_ARMOR_TOUGHNESS.getValue());
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.golemHeart7", ConfigHandler.GOLEM_HEART_KNOCKBACK_RESISTANCE.getValue().asPercentage() + "%");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.golemHeart8", ConfigHandler.GOLEM_HEART_MELEE_RESISTANCE.getValue().asPercentage() + "%");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.golemHeart9", ConfigHandler.GOLEM_HEART_EXPLOSION_RESISTANCE.getValue().asPercentage() + "%");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.golemHeart10");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.golemHeart11");
        } else {
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
        try {
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.currentKeybind", ((String)KeyBinding.func_193626_b((String)"key.spellstoneAbility").get()).toUpperCase());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void triggerActiveAbility(World world, ServerPlayerEntity player, ItemStack stack) {
        if (SuperpositionHandler.hasSpellstoneCooldown((PlayerEntity)player)) {
            return;
        }
    }

    public boolean canRightClickEquip() {
        return true;
    }

    public void onEquipped(String identifier, LivingEntity living) {
    }

    public void onUnequipped(String identifier, LivingEntity living) {
        if (living instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)living;
            AbstractAttributeMap map = player.func_110140_aT();
            map.func_111148_a(attributesDefault);
            map.func_111148_a(attributesNoArmor);
        }
    }

    public void onCurioTick(String identifier, LivingEntity living) {
        if (living instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)living;
            AbstractAttributeMap map = player.func_110140_aT();
            int armorAmount = 0;
            for (ItemStack stack : player.func_184193_aE()) {
                if (stack.func_190926_b()) continue;
                ++armorAmount;
            }
            if (armorAmount != 0) {
                map.func_111148_a(attributesDefault);
                map.func_111148_a(attributesNoArmor);
                map.func_111147_b(attributesDefault);
            } else {
                map.func_111148_a(attributesDefault);
                map.func_111148_a(attributesNoArmor);
                map.func_111147_b(attributesNoArmor);
            }
        }
    }
}

