/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.config.ConfigHandler;
import com.integral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.integral.enigmaticlegacy.helpers.IPerhaps;
import com.integral.enigmaticlegacy.helpers.ItemNBTHelper;
import com.integral.enigmaticlegacy.helpers.LoreHelper;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.ControlsScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import top.theillusivec4.curios.api.capability.ICurio;

public class MiningCharm
extends Item
implements ICurio,
IPerhaps {
    public static Item.Properties integratedProperties = new Item.Properties();

    public MiningCharm(Item.Properties properties) {
        super(properties);
    }

    public static Item.Properties setupIntegratedProperties() {
        integratedProperties.func_200916_a(EnigmaticLegacy.enigmaticTab);
        integratedProperties.func_200917_a(1);
        integratedProperties.func_208103_a(Rarity.RARE);
        return integratedProperties;
    }

    @Override
    public boolean isForMortals() {
        return ConfigHandler.MINING_CHARM_ENABLED.getValue();
    }

    public boolean canEquip(String identifier, LivingEntity living) {
        return !SuperpositionHandler.hasCurio(living, EnigmaticLegacy.miningCharm);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        TranslationTextComponent mode = new TranslationTextComponent("tooltip.enigmaticlegacy.enabled", new Object[0]);
        if (ItemNBTHelper.verifyExistance(stack, "nightVisionEnabled") && !ItemNBTHelper.getBoolean(stack, "nightVisionEnabled", true)) {
            mode = new TranslationTextComponent("tooltip.enigmaticlegacy.disabled", new Object[0]);
        }
        LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        if (ControlsScreen.hasShiftDown()) {
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.miningCharm1", ConfigHandler.MINING_CHARM_BREAK_BOOST.getValue().asPercentage() + "%");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.miningCharm2");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.miningCharm3");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.miningCharm4");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.miningCharm5");
        } else {
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
        LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.miningCharmNightVision", mode.func_150254_d());
    }

    public void onCurioTick(String identifier, LivingEntity living) {
        PlayerEntity player;
        ItemStack stack;
        if (living instanceof PlayerEntity & !living.field_70170_p.field_72995_K && SuperpositionHandler.hasCurio(living, EnigmaticLegacy.miningCharm) && ItemNBTHelper.getBoolean(stack = SuperpositionHandler.getCurioStack((LivingEntity)(player = (PlayerEntity)living), EnigmaticLegacy.miningCharm), "nightVisionEnabled", true) && player.field_70163_u < 50.0 & player.field_71093_bK.func_186068_a() != -1 & player.field_71093_bK.func_186068_a() != 1 & !player.func_213290_a(FluidTags.field_206959_a, true) & !player.field_70170_p.func_175710_j(player.func_180425_c()) && player.field_70170_p.func_205049_d(player.func_180425_c(), 0) < 3) {
            player.func_195064_c(new EffectInstance(Effects.field_76439_r, 4, 0, true, false));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand handIn) {
        ItemStack stack = player.func_184586_b(handIn);
        if (ItemNBTHelper.getBoolean(stack, "nightVisionEnabled", true)) {
            ItemNBTHelper.setBoolean(stack, "nightVisionEnabled", false);
            world.func_184133_a(null, player.func_180425_c(), EnigmaticLegacy.HHOFF, SoundCategory.NEUTRAL, (float)((double)0.8f + Math.random() * (double)0.2f), (float)((double)0.8f + Math.random() * (double)0.2f));
        } else {
            ItemNBTHelper.setBoolean(stack, "nightVisionEnabled", true);
            world.func_184133_a(null, player.func_180425_c(), EnigmaticLegacy.HHON, SoundCategory.NEUTRAL, (float)((double)0.8f + Math.random() * (double)0.2f), (float)((double)0.8f + Math.random() * (double)0.2f));
        }
        player.func_184609_a(handIn);
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public boolean canRightClickEquip() {
        return false;
    }

    public void onEquipped(String identifier, LivingEntity entityLivingBase) {
    }

    public void onUnequipped(String identifier, LivingEntity entityLivingBase) {
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(String identifier) {
        HashMultimap atts = HashMultimap.create();
        if (ConfigHandler.MINING_CHARM_BONUS_LUCK.getValue()) {
            atts.put((Object)SharedMonsterAttributes.field_188792_h.func_111108_a(), (Object)new AttributeModifier(UUID.fromString("03c3c89d-7037-4b42-880f-b146bcb64d2e"), "Fortune bonus", 1.0, AttributeModifier.Operation.ADDITION));
        }
        atts.put((Object)PlayerEntity.REACH_DISTANCE.func_111108_a(), (Object)new AttributeModifier(UUID.fromString("08c3c83d-7137-4b42-880f-b146bcb64d2e"), "Reach bonus", ConfigHandler.MINING_CHARM_REACH_BOOST.getValue(), AttributeModifier.Operation.ADDITION));
        return atts;
    }
}

