/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.config.ConfigHandler;
import com.integral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.integral.enigmaticlegacy.helpers.IPerhaps;
import com.integral.enigmaticlegacy.helpers.ItemNBTHelper;
import com.integral.enigmaticlegacy.helpers.LoreHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.ControlsScreen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import top.theillusivec4.curios.api.capability.ICurio;

public class OceanStone
extends Item
implements ICurio,
IPerhaps {
    public static Item.Properties integratedProperties = new Item.Properties();
    public static List<String> immunityList = new ArrayList<String>();
    public static int xpCostBase = 150;

    public OceanStone(Item.Properties properties) {
        super(properties);
        immunityList.add(DamageSource.field_76369_e.field_76373_n);
    }

    public static Item.Properties setupIntegratedProperties() {
        integratedProperties.func_200916_a(EnigmaticLegacy.enigmaticTab);
        integratedProperties.func_200917_a(1);
        integratedProperties.func_208103_a(Rarity.RARE);
        return integratedProperties;
    }

    @Override
    public boolean isForMortals() {
        return ConfigHandler.OCEAN_STONE_ENABLED.getValue();
    }

    public boolean canEquip(String identifier, LivingEntity living) {
        return !SuperpositionHandler.hasCurio(living, EnigmaticLegacy.oceanStone);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        if (ControlsScreen.hasShiftDown()) {
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oceanStone1");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oceanStone2");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oceanStone3");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oceanStoneCooldown", Float.valueOf((float)ConfigHandler.OCEAN_STONE_COOLDOWN.getValue() / 20.0f));
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oceanStone4");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oceanStone5", ConfigHandler.OCEAN_STONE_UNDERWATER_CREATURES_RESISTANCE.getValue().asPercentage() + "%");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oceanStone6");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oceanStone7");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oceanStone8");
        } else {
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
        try {
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.currentKeybind", ((String)KeyBinding.func_193626_b((String)"key.spellstoneAbility").get()).toUpperCase());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void triggerActiveAbility(World world, PlayerEntity player, ItemStack stack) {
        if (SuperpositionHandler.hasSpellstoneCooldown(player)) {
            return;
        }
        if (player.field_70170_p.func_201675_m().func_186058_p().func_186068_a() != 1 & player.field_70170_p.func_201675_m().func_186058_p().func_186068_a() != -1 && !world.func_72912_H().func_76061_m()) {
            boolean paybackReceived = false;
            ItemStack scroll = SuperpositionHandler.getCurioStack((LivingEntity)player, EnigmaticLegacy.xpScroll);
            if (scroll != null && ItemNBTHelper.getInt(scroll, "XPStored", 0) >= xpCostBase * 2) {
                ItemNBTHelper.setInt(scroll, "XPStored", ItemNBTHelper.getInt(scroll, "XPStored", 0) - (int)(((double)xpCostBase + Math.random() * (double)xpCostBase) * ConfigHandler.OCEAN_STONE_XP_COST_MODIFIER.getValue()));
                paybackReceived = true;
            } else if (player.field_71067_cb >= xpCostBase * 2) {
                player.func_195068_e((int)(-(((double)xpCostBase + Math.random() * (double)xpCostBase) * ConfigHandler.OCEAN_STONE_XP_COST_MODIFIER.getValue())));
                paybackReceived = true;
            }
            if (paybackReceived) {
                int thunderstormTime = (int)(10000.0 + Math.random() * 20000.0);
                world.func_72912_H().func_176142_i(0);
                world.func_72912_H().func_76080_g(thunderstormTime);
                world.func_72912_H().func_76090_f(thunderstormTime);
                world.func_72912_H().func_76084_b(true);
                world.func_72912_H().func_76069_a(true);
                world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187754_de, SoundCategory.NEUTRAL, 2.0f, (float)((double)0.7f + Math.random() * 0.3));
                SuperpositionHandler.setSpellstoneCooldown(player, ConfigHandler.OCEAN_STONE_COOLDOWN.getValue());
            }
        }
    }

    public boolean canRightClickEquip() {
        return true;
    }

    public void onEquipped(String identifier, LivingEntity entityLivingBase) {
    }

    public void onUnequipped(String identifier, LivingEntity entityLivingBase) {
    }

    public void onCurioTick(String identifier, LivingEntity living) {
        PlayerEntity player;
        if (living instanceof PlayerEntity & !living.field_70170_p.field_72995_K && SuperpositionHandler.hasCurio(living, EnigmaticLegacy.oceanStone) && (player = (PlayerEntity)living).func_213290_a(FluidTags.field_206959_a, true)) {
            player.func_195064_c(new EffectInstance(Effects.field_76439_r, 4, 0, true, false));
            player.func_70050_g(300);
        }
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(String identifier) {
        HashMultimap atts = HashMultimap.create();
        atts.put((Object)PlayerEntity.SWIM_SPEED.func_111108_a(), (Object)new AttributeModifier(UUID.fromString("13faf191-bf38-4654-b369-cc1f4f1143bf"), "Swim speed bonus", ConfigHandler.OCEAN_STONE_SWIMMING_SPEED_BOOST.getValue().asMultiplier(false), AttributeModifier.Operation.MULTIPLY_BASE));
        return atts;
    }
}

