/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excore.utils.client.render.model.vertex;

import code.elix_x.excore.utils.client.render.model.vertex.DefaultUnpackedVertices;
import code.elix_x.excore.utils.client.render.model.vertex.PackedVertex;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.renderer.vertex.VertexFormat;

public class PackedVertices
implements Iterable<PackedVertex> {
    private final int mode;
    private final VertexFormat format;
    private final ImmutableList<PackedVertex> vertices;

    public PackedVertices(int mode, VertexFormat format, PackedVertex ... vertices) {
        this.mode = mode;
        this.format = format;
        this.vertices = ImmutableList.copyOf((Object[])vertices);
    }

    public PackedVertices(int mode, VertexFormat format, List<PackedVertex> vertices) {
        this.mode = mode;
        this.format = format;
        this.vertices = ImmutableList.copyOf(vertices);
    }

    public PackedVertices(int mode, VertexFormat format, float[][][] vertexData) {
        this.mode = mode;
        this.format = format;
        ImmutableList.Builder verticesBuilder = ImmutableList.builder();
        for (float[][] vertex : vertexData) {
            verticesBuilder.add((Object)new PackedVertex(format, vertex));
        }
        this.vertices = verticesBuilder.build();
    }

    public int getMode() {
        return this.mode;
    }

    public VertexFormat getFormat() {
        return this.format;
    }

    public List<PackedVertex> getVertices() {
        return this.vertices;
    }

    @Override
    public Iterator<PackedVertex> iterator() {
        return this.vertices.iterator();
    }

    public float[][][] getData() {
        float[][][] data = new float[this.vertices.size()][][];
        for (int v = 0; v < data.length; ++v) {
            data[v] = ((PackedVertex)this.vertices.get(v)).getData();
        }
        return data;
    }

    public DefaultUnpackedVertices unpack() {
        return new DefaultUnpackedVertices(this.format, (List<PackedVertex>)this.vertices);
    }
}

