/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excore.utils.client.render.world;

import code.elix_x.excore.utils.client.render.IVertexBuffer;
import code.elix_x.excore.utils.client.render.OpenGLHelper;
import code.elix_x.excore.utils.client.render.vbo.VertexBufferSingleVBO;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;

public class SingleChunkBlockAccessRenderer {
    protected final IBlockAccess world;
    protected final AxisAlignedBB shape;
    protected final AxisAlignedBB shapeResult;
    protected final IVertexBuffer[] vertexBuffers = new IVertexBuffer[BlockRenderLayer.values().length];
    protected boolean needsUpdate = true;
    protected boolean[] layers = new boolean[BlockRenderLayer.values().length];

    public SingleChunkBlockAccessRenderer(IBlockAccess world, AxisAlignedBB shape, AxisAlignedBB shapeResult) {
        this.world = world;
        this.shape = shape;
        this.shapeResult = shapeResult;
    }

    public SingleChunkBlockAccessRenderer(IBlockAccess world, AxisAlignedBB shape, Vec3d posResult) {
        this(world, shape, shape.func_191194_a(posResult.func_178788_d(shape.func_189972_c())));
    }

    public SingleChunkBlockAccessRenderer(IBlockAccess world, AxisAlignedBB shape) {
        this(world, shape, shape);
    }

    public boolean doRenderLayer(BlockRenderLayer layer) {
        return this.layers[layer.ordinal()];
    }

    public boolean isEmpty() {
        boolean notEmpty = false;
        for (BlockRenderLayer layer : BlockRenderLayer.values()) {
            notEmpty |= this.doRenderLayer(layer);
        }
        return !notEmpty;
    }

    public void markDirty() {
        this.needsUpdate = true;
    }

    public void render() {
        this.updateCheck();
        if (!this.isEmpty()) {
            this.renderSetup();
            this.renderPre();
            for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                if (!this.doRenderLayer(layer)) continue;
                this.renderLayerSetup(layer);
                this.renderLayer(layer);
                this.renderLayerCleanup(layer);
            }
            this.renderPost();
            this.renderCleanup();
        }
    }

    protected boolean updateCheck() {
        if (this.needsUpdate) {
            this.rebuildBuffers();
            this.needsUpdate = false;
            return true;
        }
        return false;
    }

    protected void renderSetup() {
        OpenGLHelper.enableClientState(DefaultVertexFormats.field_176600_a);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        RenderHelper.func_74518_a();
        Minecraft.func_71410_x().field_71460_t.func_180436_i();
    }

    protected void renderPre() {
        GlStateManager.func_179094_E();
        double scaleX = (this.shapeResult.field_72336_d - this.shapeResult.field_72340_a) / (this.shape.field_72336_d + 1.0 - this.shape.field_72340_a);
        double scaleY = (this.shapeResult.field_72337_e - this.shapeResult.field_72338_b) / (this.shape.field_72337_e + 1.0 - this.shape.field_72338_b);
        double scaleZ = (this.shapeResult.field_72334_f - this.shapeResult.field_72339_c) / (this.shape.field_72334_f + 1.0 - this.shape.field_72339_c);
        GlStateManager.func_179139_a((double)scaleX, (double)scaleY, (double)scaleZ);
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
        GlStateManager.func_179137_b((double)(this.shapeResult.func_189972_c().field_72450_a / scaleX), (double)(this.shapeResult.func_189972_c().field_72448_b / scaleY), (double)(this.shapeResult.func_189972_c().field_72449_c / scaleZ));
    }

    protected void renderLayerSetup(BlockRenderLayer layer) {
        switch (layer) {
            case SOLID: {
                GlStateManager.func_179118_c();
                break;
            }
            case CUTOUT_MIPPED: {
                GlStateManager.func_179141_d();
                break;
            }
            case CUTOUT: {
                GlStateManager.func_179141_d();
                Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
            }
            case TRANSLUCENT: {
                GlStateManager.func_179141_d();
                GlStateManager.func_179147_l();
            }
        }
    }

    protected void renderLayer(BlockRenderLayer layer) {
        this.vertexBuffers[layer.ordinal()].draw();
    }

    protected void renderLayerCleanup(BlockRenderLayer layer) {
        switch (layer) {
            case SOLID: {
                break;
            }
            case CUTOUT_MIPPED: {
                break;
            }
            case CUTOUT: {
                Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
                break;
            }
            case TRANSLUCENT: {
                GlStateManager.func_179084_k();
            }
        }
    }

    protected void renderPost() {
        GlStateManager.func_179121_F();
    }

    protected void renderCleanup() {
        Minecraft.func_71410_x().field_71460_t.func_175072_h();
        RenderHelper.func_74519_b();
        OpenGLHelper.disableClientState(DefaultVertexFormats.field_176600_a);
    }

    protected void rebuildBuffers() {
        this.cleanUp();
        this.layers = new boolean[BlockRenderLayer.values().length];
        BlockRenderLayer prev = MinecraftForgeClient.getRenderLayer();
        for (BlockRenderLayer layer : BlockRenderLayer.values()) {
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
            BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            buffer.func_178969_c(-this.shape.func_189972_c().field_72450_a, -this.shape.func_189972_c().field_72448_b, -this.shape.func_189972_c().field_72449_c);
            BlockRendererDispatcher blockRenderer = Minecraft.func_71410_x().func_175602_ab();
            int x = (int)Math.floor(this.shape.field_72340_a);
            while ((double)x <= this.shape.field_72336_d) {
                int y = (int)Math.floor(this.shape.field_72338_b);
                while ((double)y <= this.shape.field_72337_e) {
                    int z = (int)Math.floor(this.shape.field_72339_c);
                    while ((double)z <= this.shape.field_72334_f) {
                        BlockPos pos = new BlockPos(x, y, z);
                        IBlockState state = this.world.func_180495_p(pos);
                        if (state.func_185904_a() != Material.field_151579_a && state.func_185901_i() != EnumBlockRenderType.INVISIBLE && state.func_185901_i() != EnumBlockRenderType.ENTITYBLOCK_ANIMATED && state.func_177230_c().canRenderInLayer(state, layer)) {
                            this.layers[layer.ordinal()] = true;
                            blockRenderer.func_175018_a(state, pos, this.world, buffer);
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
            buffer.func_178977_d();
            buffer.func_178969_c(0.0, 0.0, 0.0);
            if (this.layers[layer.ordinal()]) {
                this.vertexBuffers[layer.ordinal()] = new VertexBufferSingleVBO(buffer).setModifyClientStates(false);
                continue;
            }
            buffer.func_178965_a();
        }
        ForgeHooksClient.setRenderLayer((BlockRenderLayer)prev);
    }

    public void cleanUp() {
        for (IVertexBuffer buffer : this.vertexBuffers) {
            if (buffer == null) continue;
            buffer.cleanUp();
        }
    }
}

