/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excore.utils.client.resource;

import code.elix_x.excore.utils.client.resource.ExternalDefaultRP;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.client.resources.data.MetadataSerializer;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.mutable.MutableObject;

public class PrecacheResourcePack
extends ExternalDefaultRP {
    protected IResourcePack delegate;
    protected Map<ResourceLocation, File> cached = new HashMap<ResourceLocation, File>();

    public PrecacheResourcePack(String name, Set<String> domains, IResourcePack delegate) {
        super(name, domains);
        this.delegate = delegate;
    }

    public PrecacheResourcePack(String name, String domain, IResourcePack delegate) {
        super(name, domain);
        this.delegate = delegate;
    }

    public PrecacheResourcePack(ExternalDefaultRP delegate) {
        this(delegate.name, delegate.domains, (IResourcePack)delegate);
    }

    public void precache(Stream<ResourceLocation> resources) throws IOException {
        MutableObject e = new MutableObject();
        resources.filter(this::func_110589_b).forEach(rl -> {
            block6: {
                if (e.getValue() != null) {
                    return;
                }
                InputStream in = null;
                BufferedOutputStream out = null;
                try {
                    File file = File.createTempFile(UUID.randomUUID().toString(), ".tmp");
                    in = this.func_110590_a((ResourceLocation)rl);
                    out = new BufferedOutputStream(new FileOutputStream(file));
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    file.deleteOnExit();
                    this.cached.put((ResourceLocation)rl, file);
                    IOUtils.closeQuietly((InputStream)in);
                }
                catch (IOException eio) {
                    e.setValue((Object)eio);
                    break block6;
                }
                finally {
                    IOUtils.closeQuietly(in);
                    IOUtils.closeQuietly(out);
                }
                IOUtils.closeQuietly((OutputStream)out);
            }
        });
        if (e.getValue() != null) {
            throw (IOException)e.getValue();
        }
    }

    public boolean func_110589_b(ResourceLocation location) {
        return this.delegate.func_110589_b(location);
    }

    public InputStream func_110590_a(ResourceLocation location) throws IOException {
        File cached = this.cached.get(location);
        return cached != null ? new BufferedInputStream(new FileInputStream(cached)) : this.delegate.func_110590_a(location);
    }

    @Override
    @Nullable
    public <T extends IMetadataSection> T func_135058_a(MetadataSerializer metadataSerializer, String metadataSectionName) throws IOException {
        return (T)this.delegate.func_135058_a(metadataSerializer, metadataSectionName);
    }
}

