/*
 * Decompiled with CFR 0.152.
 */
package exnihiloadscensio.barrel.modes.fluid;

import exnihiloadscensio.barrel.BarrelFluidHandler;
import exnihiloadscensio.barrel.modes.mobspawn.BarrelModeMobSpawn;
import exnihiloadscensio.items.ItemDoll;
import exnihiloadscensio.networking.MessageBarrelModeUpdate;
import exnihiloadscensio.networking.PacketHandler;
import exnihiloadscensio.registries.FluidBlockTransformerRegistry;
import exnihiloadscensio.tiles.TileBarrel;
import exnihiloadscensio.util.ItemInfo;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;

public class BarrelItemHandlerFluid
extends ItemStackHandler {
    private TileBarrel barrel;

    public BarrelItemHandlerFluid(TileBarrel barrel) {
        super(1);
        this.barrel = barrel;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        ItemInfo info;
        BarrelFluidHandler tank = this.barrel.getTank();
        if (tank.getFluid() == null) {
            return stack;
        }
        if (FluidBlockTransformerRegistry.canBlockBeTransformedWithThisFluid(tank.getFluid().getFluid(), stack) && tank.getFluidAmount() == tank.getCapacity() && (info = FluidBlockTransformerRegistry.getBlockForTransformation(tank.getFluid().getFluid(), stack)) != null) {
            if (!simulate) {
                tank.drain(tank.getCapacity(), true);
                this.barrel.setMode("block");
                PacketHandler.sendToAllAround(new MessageBarrelModeUpdate("block", this.barrel.func_174877_v()), this.barrel);
                this.barrel.getMode().addItem(info.getItemStack(), this.barrel);
            }
            if (stack.func_77973_b().hasContainerItem(stack)) {
                // empty if block
            }
            ItemStack ret = stack.func_77946_l();
            --ret.field_77994_a;
            return ret.field_77994_a == 0 ? null : ret;
        }
        if (stack != null && tank.getFluidAmount() == tank.getCapacity() && stack.func_77973_b() instanceof ItemDoll && ((ItemDoll)stack.func_77973_b()).getSpawnFluid(stack) == tank.getFluid().getFluid()) {
            if (!simulate) {
                this.barrel.getTank().drain(1000, true);
                this.barrel.setMode("mobspawn");
                ((BarrelModeMobSpawn)this.barrel.getMode()).setDollStack(stack);
                PacketHandler.sendNBTUpdate(this.barrel);
            }
            ItemStack ret = stack.func_77946_l();
            --ret.field_77994_a;
            return ret;
        }
        return stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return null;
    }

    public void setBarrel(TileBarrel barrel) {
        this.barrel = barrel;
    }
}

