/*
 * Decompiled with CFR 0.152.
 */
package exnihiloadscensio.barrel.modes.transform;

import exnihiloadscensio.barrel.IBarrelMode;
import exnihiloadscensio.networking.PacketHandler;
import exnihiloadscensio.registries.FluidTransformRegistry;
import exnihiloadscensio.registries.types.FluidTransformer;
import exnihiloadscensio.texturing.Color;
import exnihiloadscensio.tiles.TileBarrel;
import exnihiloadscensio.util.BlockInfo;
import exnihiloadscensio.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.items.ItemStackHandler;

public class BarrelModeFluidTransform
implements IBarrelMode {
    private FluidStack inputStack;
    private FluidStack outputStack;
    private float progress = 0.0f;
    private FluidTransformer transformer;

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        NBTTagCompound inputTag = new NBTTagCompound();
        NBTTagCompound outputTag = new NBTTagCompound();
        if (this.inputStack != null) {
            inputTag = this.inputStack.writeToNBT(new NBTTagCompound());
        }
        if (this.outputStack != null) {
            outputTag = this.outputStack.writeToNBT(new NBTTagCompound());
        }
        tag.func_74782_a("inputTag", (NBTBase)inputTag);
        tag.func_74782_a("outputTag", (NBTBase)outputTag);
        tag.func_74776_a("progress", this.progress);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("inputTag")) {
            NBTTagCompound inputTag = (NBTTagCompound)tag.func_74781_a("inputTag");
            this.inputStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)inputTag);
        }
        if (tag.func_74764_b("outputTag")) {
            NBTTagCompound outputTag = (NBTTagCompound)tag.func_74781_a("outputTag");
            this.outputStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)outputTag);
        }
        if (tag.func_74764_b("progress")) {
            this.progress = tag.func_74760_g("progress");
        }
    }

    @Override
    public boolean isTriggerItemStack(ItemStack stack) {
        return false;
    }

    @Override
    public boolean isTriggerFluidStack(FluidStack stack) {
        return false;
    }

    @Override
    public String getName() {
        return "fluidTransform";
    }

    @Override
    public boolean onBlockActivated(World world, TileBarrel barrel, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public TextureAtlasSprite getTextureForRender(TileBarrel barrel) {
        if ((double)this.progress < 0.5) {
            return Util.getTextureFromFluidStack(this.inputStack);
        }
        return Util.getTextureFromFluidStack(this.outputStack);
    }

    @Override
    public Color getColorForRender() {
        return Color.average(Util.blackColor, Util.whiteColor, 2.0f * Math.abs(this.progress - 0.5f));
    }

    @Override
    public float getFilledLevelForRender(TileBarrel barrel) {
        return 1.0f;
    }

    @Override
    public void update(TileBarrel barrel) {
        if (this.transformer == null) {
            this.transformer = FluidTransformRegistry.getFluidTransformer(this.inputStack.getFluid().getName(), this.outputStack.getFluid().getName());
        }
        if (this.transformer == null) {
            return;
        }
        if (this.progress < 1.0f) {
            int numberOfBlocks = Util.getNumSurroundingBlocksAtLeastOneOf(this.transformer.getTransformingBlocks(), barrel.func_174877_v().func_177982_a(0, -1, 0), barrel.func_145831_w()) + Util.getNumSurroundingBlocksAtLeastOneOf(this.transformer.getTransformingBlocks(), barrel.func_174877_v(), barrel.func_145831_w());
            if (numberOfBlocks > 0) {
                this.progress = (float)((double)this.progress + (double)numberOfBlocks * 1.0 / (double)this.transformer.getDuration());
                if (barrel.func_145831_w().field_73012_v.nextDouble() < 0.005) {
                    boolean spawned = false;
                    ArrayList<BlockInfo> blockList = new ArrayList<BlockInfo>(Arrays.asList(this.transformer.getTransformingBlocks()));
                    for (int xShift = -1; xShift <= 1; ++xShift) {
                        for (int zShift = -1; zShift <= 1; ++zShift) {
                            BlockInfo[] toSpawn;
                            if (spawned) continue;
                            BlockPos testPos = barrel.func_174877_v().func_177982_a(xShift, -1, zShift);
                            if (!blockList.contains(new BlockInfo(barrel.func_145831_w().func_180495_p(testPos))) || !barrel.func_145831_w().func_175623_d(testPos.func_177982_a(0, 1, 0)) || (toSpawn = this.transformer.getBlocksToSpawn()) == null || toSpawn.length <= 0) continue;
                            barrel.func_145831_w().func_175656_a(testPos.func_177982_a(0, 1, 0), toSpawn[barrel.func_145831_w().field_73012_v.nextInt(toSpawn.length)].getBlockState());
                            spawned = true;
                        }
                    }
                }
            }
            PacketHandler.sendNBTUpdate(barrel);
        }
        if (this.progress >= 1.0f) {
            barrel.setMode("fluid");
            FluidTank tank = barrel.getMode().getFluidHandler(barrel);
            Fluid fluid = FluidRegistry.getFluid((String)this.transformer.getOutputFluid());
            tank.setFluid(new FluidStack(fluid, 1000));
            PacketHandler.sendNBTUpdate(barrel);
        }
    }

    @Override
    public boolean addItem(ItemStack stack, TileBarrel barrel) {
        return false;
    }

    @Override
    public ItemStackHandler getHandler(TileBarrel barrel) {
        return null;
    }

    @Override
    public FluidTank getFluidHandler(TileBarrel barrel) {
        return null;
    }

    @Override
    public boolean canFillWithFluid(TileBarrel barrel) {
        return false;
    }

    @Override
    public List<String> getWailaTooltip(TileBarrel barrel, List<String> currenttip) {
        currenttip.add("Transforming: " + Math.round(this.progress * 100.0f) + "%");
        return currenttip;
    }

    public void setInputStack(FluidStack inputStack) {
        this.inputStack = inputStack;
    }

    public void setOutputStack(FluidStack outputStack) {
        this.outputStack = outputStack;
    }

    public FluidStack getInputStack() {
        return this.inputStack;
    }

    public FluidStack getOutputStack() {
        return this.outputStack;
    }

    public float getProgress() {
        return this.progress;
    }

    public void setTransformer(FluidTransformer transformer) {
        this.transformer = transformer;
    }

    public FluidTransformer getTransformer() {
        return this.transformer;
    }
}

