/*
 * Decompiled with CFR 0.152.
 */
package exnihiloadscensio.blocks;

import exnihiloadscensio.blocks.BlockBase;
import exnihiloadscensio.compatibility.theoneprobe.ITOPInfoProvider;
import exnihiloadscensio.config.Config;
import exnihiloadscensio.items.ItemMesh;
import exnihiloadscensio.networking.PacketHandler;
import exnihiloadscensio.tiles.TileSieve;
import exnihiloadscensio.util.Util;
import java.util.ArrayList;
import java.util.Map;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;

public class BlockSieve
extends BlockBase
implements ITileEntityProvider,
ITOPInfoProvider {
    public static final PropertyEnum<MeshType> MESH = PropertyEnum.func_177709_a((String)"mesh", MeshType.class);

    public BlockSieve() {
        super(Material.field_151575_d, "blockSieve");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(MESH, (Comparable)((Object)MeshType.NONE)));
        this.func_149711_c(2.0f);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (player instanceof FakePlayer && !Config.fakePlayersCanSieve) {
            return false;
        }
        TileSieve te = (TileSieve)world.func_175625_s(pos);
        if (te != null) {
            if (heldItem != null && heldItem.func_77973_b() instanceof ItemMesh) {
                ItemStack meshStack = heldItem.func_77946_l();
                meshStack.field_77994_a = 1;
                MeshType type = MeshType.getMeshTypeByID(heldItem.func_77952_i());
                boolean done = te.setMesh(meshStack, false);
                if (done) {
                    if (!player.func_184812_l_()) {
                        --heldItem.field_77994_a;
                    }
                    world.func_175656_a(pos, state.func_177226_a(MESH, (Comparable)((Object)type)));
                    PacketHandler.sendNBTUpdate(te);
                    return true;
                }
            }
            if (player.func_184614_ca() == null && te.getMeshStack() != null && player.func_70093_af() && te.setMesh(null, true)) {
                Util.dropItemInWorld(te, player, te.getMeshStack(), 0.02f);
                te.setMesh(null);
                PacketHandler.sendNBTUpdate(te);
                world.func_175656_a(pos, state.func_177226_a(MESH, (Comparable)((Object)MeshType.NONE)));
                return true;
            }
            if (te.addBlock(heldItem)) {
                if (!player.func_184812_l_()) {
                    --heldItem.field_77994_a;
                }
                for (int xOffset = -1 * Config.sieveSimilarRadius; xOffset <= 1 * Config.sieveSimilarRadius; ++xOffset) {
                    for (int zOffset = -1 * Config.sieveSimilarRadius; zOffset <= 1 * Config.sieveSimilarRadius; ++zOffset) {
                        TileEntity entity = world.func_175625_s(pos.func_177982_a(xOffset, 0, zOffset));
                        if (entity == null || !(entity instanceof TileSieve)) continue;
                        TileSieve sieve = (TileSieve)entity;
                        if (heldItem.field_77994_a <= 0 || !te.isSieveSimilarToInput(sieve) || !sieve.addBlock(heldItem) || player.func_184812_l_()) continue;
                        --heldItem.field_77994_a;
                    }
                }
                return true;
            }
            ArrayList<BlockPos> toSift = new ArrayList<BlockPos>();
            for (int xOffset = -1 * Config.sieveSimilarRadius; xOffset <= Config.sieveSimilarRadius; ++xOffset) {
                for (int zOffset = -1 * Config.sieveSimilarRadius; zOffset <= 1 * Config.sieveSimilarRadius; ++zOffset) {
                    TileSieve sieve;
                    TileEntity entity = world.func_175625_s(pos.func_177982_a(xOffset, 0, zOffset));
                    if (entity == null || !(entity instanceof TileSieve) || !te.isSieveSimilar(sieve = (TileSieve)entity)) continue;
                    toSift.add(pos.func_177982_a(xOffset, 0, zOffset));
                }
            }
            for (BlockPos posIter : toSift) {
                if (posIter == null) continue;
                TileSieve sieve = (TileSieve)world.func_175625_s(posIter);
                sieve.doSieving(player);
            }
            return true;
        }
        return true;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{MESH});
    }

    public IBlockState func_176203_a(int meta) {
        MeshType type;
        switch (meta) {
            case 0: {
                type = MeshType.NONE;
                break;
            }
            case 1: {
                type = MeshType.STRING;
                break;
            }
            case 2: {
                type = MeshType.FLINT;
                break;
            }
            case 3: {
                type = MeshType.IRON;
                break;
            }
            case 4: {
                type = MeshType.DIAMOND;
                break;
            }
            default: {
                type = MeshType.STRING;
            }
        }
        return this.func_176223_P().func_177226_a(MESH, (Comparable)((Object)type));
    }

    public int func_176201_c(IBlockState state) {
        MeshType type = (MeshType)((Object)state.func_177229_b(MESH));
        return type.getID();
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileSieve sieve;
        TileEntity te = world.func_175625_s(pos);
        if (te != null && (sieve = (TileSieve)te).getMeshStack() != null) {
            Util.dropItemInWorld(sieve, null, sieve.getMeshStack(), 0.02f);
        }
        super.func_180663_b(world, pos, state);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileSieve();
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileSieve sieve = (TileSieve)world.func_175625_s(data.getPos());
        if (sieve == null) {
            return;
        }
        if (sieve.getMeshStack() == null) {
            probeInfo.text("Mesh: None");
            return;
        }
        probeInfo.text("Mesh: " + I18n.func_135052_a((String)(sieve.getMeshStack().func_77977_a() + ".name"), (Object[])new Object[0]));
        if (mode == ProbeMode.EXTENDED) {
            Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)sieve.getMeshStack());
            for (Enchantment enchantment : enchantments.keySet()) {
                probeInfo.text(TextFormatting.BLUE + enchantment.func_77316_c(((Integer)enchantments.get(enchantment)).intValue()));
            }
        }
    }

    public static enum MeshType implements IStringSerializable
    {
        NONE(0, "none"),
        STRING(1, "string"),
        FLINT(2, "flint"),
        IRON(3, "iron"),
        DIAMOND(4, "diamond");

        private int id;
        private String name;

        private MeshType(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getID() {
            return this.id;
        }

        public String toString() {
            return this.func_176610_l();
        }

        public static MeshType getMeshTypeByID(int meta) {
            switch (meta) {
                case 1: {
                    return STRING;
                }
                case 2: {
                    return FLINT;
                }
                case 3: {
                    return IRON;
                }
                case 4: {
                    return DIAMOND;
                }
            }
            return NONE;
        }
    }
}

