/*
 * Decompiled with CFR 0.152.
 */
package exnihiloadscensio.compatibility.jei;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import exnihiloadscensio.ExNihiloAdscensio;
import exnihiloadscensio.blocks.BlockSieve;
import exnihiloadscensio.blocks.ENBlocks;
import exnihiloadscensio.compatibility.jei.barrel.compost.CompostRecipe;
import exnihiloadscensio.compatibility.jei.barrel.compost.CompostRecipeCategory;
import exnihiloadscensio.compatibility.jei.barrel.compost.CompostRecipeHandler;
import exnihiloadscensio.compatibility.jei.barrel.fluidblocktransform.FluidBlockTransformRecipe;
import exnihiloadscensio.compatibility.jei.barrel.fluidblocktransform.FluidBlockTransformRecipeCategory;
import exnihiloadscensio.compatibility.jei.barrel.fluidblocktransform.FluidBlockTransformRecipeHandler;
import exnihiloadscensio.compatibility.jei.barrel.fluidontop.FluidOnTopRecipe;
import exnihiloadscensio.compatibility.jei.barrel.fluidontop.FluidOnTopRecipeCategory;
import exnihiloadscensio.compatibility.jei.barrel.fluidontop.FluidOnTopRecipeHandler;
import exnihiloadscensio.compatibility.jei.barrel.fluidtransform.FluidTransformRecipe;
import exnihiloadscensio.compatibility.jei.barrel.fluidtransform.FluidTransformRecipeCategory;
import exnihiloadscensio.compatibility.jei.barrel.fluidtransform.FluidTransformRecipeHandler;
import exnihiloadscensio.compatibility.jei.hammer.HammerRecipe;
import exnihiloadscensio.compatibility.jei.hammer.HammerRecipeCategory;
import exnihiloadscensio.compatibility.jei.hammer.HammerRecipeHandler;
import exnihiloadscensio.compatibility.jei.sieve.SieveRecipe;
import exnihiloadscensio.compatibility.jei.sieve.SieveRecipeCategory;
import exnihiloadscensio.compatibility.jei.sieve.SieveRecipeHandler;
import exnihiloadscensio.items.ENItems;
import exnihiloadscensio.registries.CompostRegistry;
import exnihiloadscensio.registries.FluidBlockTransformerRegistry;
import exnihiloadscensio.registries.FluidOnTopRegistry;
import exnihiloadscensio.registries.FluidTransformRegistry;
import exnihiloadscensio.registries.HammerRegistry;
import exnihiloadscensio.registries.SieveRegistry;
import exnihiloadscensio.registries.types.Compostable;
import exnihiloadscensio.registries.types.FluidBlockTransformer;
import exnihiloadscensio.registries.types.FluidFluidBlock;
import exnihiloadscensio.registries.types.FluidTransformer;
import exnihiloadscensio.util.BlockInfo;
import exnihiloadscensio.util.ItemInfo;
import exnihiloadscensio.util.LogUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;

@JEIPlugin
public class CompatJEI
implements IModPlugin {
    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
    }

    public void registerIngredients(IModIngredientRegistration registry) {
    }

    public void register(IModRegistry registry) {
        Object recipe;
        LogUtil.info("Config Loaded: " + ExNihiloAdscensio.configsLoaded);
        if (!ExNihiloAdscensio.configsLoaded) {
            ExNihiloAdscensio.loadConfigs();
        }
        registry.addRecipeCategories(new IRecipeCategory[]{new SieveRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeHandlers(new IRecipeHandler[]{new SieveRecipeHandler()});
        ArrayList sieveRecipes = Lists.newArrayList();
        for (BlockInfo blockInfo : SieveRegistry.getRegistry().keySet()) {
            for (BlockSieve.MeshType type : BlockSieve.MeshType.values()) {
                if (type.getID() == 0 || blockInfo.getBlockState() == null || ((SieveRecipe)(recipe = new SieveRecipe(blockInfo.getBlockState(), type))).getInputs().size() != 2 || ((SieveRecipe)recipe).getOutputs().size() <= 0) continue;
                sieveRecipes.add(recipe);
            }
        }
        registry.addRecipes((List)sieveRecipes);
        registry.addRecipeCategoryCraftingItem(new ItemStack((Block)ENBlocks.sieve), new String[]{"exnihiloadscensio:sieve"});
        registry.addRecipeCategories(new IRecipeCategory[]{new HammerRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeHandlers(new IRecipeHandler[]{new HammerRecipeHandler()});
        ArrayList hammerRecipes = Lists.newArrayList();
        for (ItemInfo itemInfo : HammerRegistry.getRegistry().keySet()) {
            IBlockState block;
            HammerRecipe recipe2;
            if (itemInfo.getItem() == null || (recipe2 = new HammerRecipe(block = Block.func_149634_a((Item)itemInfo.getItem()).func_176203_a(itemInfo.getMeta()))).getInputs().size() != 1 || recipe2.getOutputs().size() <= 0) continue;
            hammerRecipes.add(recipe2);
        }
        registry.addRecipes((List)hammerRecipes);
        registry.addRecipeCategoryCraftingItem(new ItemStack((Item)ENItems.hammerWood), new String[]{"exnihiloadscensio:hammer"});
        registry.addRecipeCategoryCraftingItem(new ItemStack((Item)ENItems.hammerGold), new String[]{"exnihiloadscensio:hammer"});
        registry.addRecipeCategoryCraftingItem(new ItemStack((Item)ENItems.hammerStone), new String[]{"exnihiloadscensio:hammer"});
        registry.addRecipeCategoryCraftingItem(new ItemStack((Item)ENItems.hammerIron), new String[]{"exnihiloadscensio:hammer"});
        registry.addRecipeCategoryCraftingItem(new ItemStack((Item)ENItems.hammerDiamond), new String[]{"exnihiloadscensio:hammer"});
        registry.addRecipeCategories(new IRecipeCategory[]{new FluidTransformRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeHandlers(new IRecipeHandler[]{new FluidTransformRecipeHandler()});
        ArrayList arrayList = Lists.newArrayList();
        for (FluidTransformer transformer : FluidTransformRegistry.getRegistry()) {
            FluidTransformRecipe recipe3;
            if (!FluidRegistry.isFluidRegistered((String)transformer.getInputFluid()) || !FluidRegistry.isFluidRegistered((String)transformer.getOutputFluid()) || (recipe3 = new FluidTransformRecipe(transformer)).getInputs().size() < 2 || recipe3.getOutputs().size() != 1) continue;
            arrayList.add(new FluidTransformRecipe(transformer));
        }
        registry.addRecipes((List)arrayList);
        registry.addRecipeCategoryCraftingItem(new ItemStack((Block)ENBlocks.barrelWood), new String[]{"exnihiloadscensio:fluid_transform"});
        registry.addRecipeCategoryCraftingItem(new ItemStack((Block)ENBlocks.barrelStone), new String[]{"exnihiloadscensio:fluid_transform"});
        registry.addRecipeCategories(new IRecipeCategory[]{new FluidOnTopRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeHandlers(new IRecipeHandler[]{new FluidOnTopRecipeHandler()});
        ArrayList arrayList2 = Lists.newArrayList();
        for (FluidFluidBlock transformer : FluidOnTopRegistry.getRegistry()) {
            FluidOnTopRecipe recipe4;
            if (!FluidRegistry.isFluidRegistered((String)transformer.getFluidInBarrel()) || !FluidRegistry.isFluidRegistered((String)transformer.getFluidOnTop()) || transformer.getResult().getItem() == null || (recipe4 = new FluidOnTopRecipe(transformer)).getInputs().size() != 2 || recipe4.getOutputs().size() != 1) continue;
            arrayList2.add(new FluidOnTopRecipe(transformer));
        }
        registry.addRecipes((List)arrayList2);
        registry.addRecipeCategoryCraftingItem(new ItemStack((Block)ENBlocks.barrelWood), new String[]{"exnihiloadscensio:fluid_on_top"});
        registry.addRecipeCategoryCraftingItem(new ItemStack((Block)ENBlocks.barrelStone), new String[]{"exnihiloadscensio:fluid_on_top"});
        registry.addRecipeCategories(new IRecipeCategory[]{new FluidBlockTransformRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeHandlers(new IRecipeHandler[]{new FluidBlockTransformRecipeHandler()});
        ArrayList fluidBlockTransformRecipes = Lists.newArrayList();
        for (FluidBlockTransformer transformer : FluidBlockTransformerRegistry.getRegistry()) {
            if (!FluidRegistry.isFluidRegistered((String)transformer.getFluidName()) || transformer.getInput().getItem() == null || transformer.getOutput().getItem() == null || ((FluidBlockTransformRecipe)(recipe = new FluidBlockTransformRecipe(transformer))).getInputs().size() != 2 || ((FluidBlockTransformRecipe)recipe).getOutputs().size() != 1) continue;
            fluidBlockTransformRecipes.add(new FluidBlockTransformRecipe(transformer));
        }
        registry.addRecipes((List)fluidBlockTransformRecipes);
        registry.addRecipeCategoryCraftingItem(new ItemStack((Block)ENBlocks.barrelWood), new String[]{"exnihiloadscensio:fluid_block_transform"});
        registry.addRecipeCategoryCraftingItem(new ItemStack((Block)ENBlocks.barrelStone), new String[]{"exnihiloadscensio:fluid_block_transform"});
        registry.addRecipeCategories(new IRecipeCategory[]{new CompostRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeHandlers(new IRecipeHandler[]{new CompostRecipeHandler()});
        ArrayList compostRecipes = Lists.newArrayList();
        Map<ItemInfo, Compostable> compostRegistry = CompostRegistry.getRegistry();
        HashMap compostEntries = Maps.newHashMap();
        for (Map.Entry<ItemInfo, Compostable> entry : compostRegistry.entrySet()) {
            ItemInfo compostBlock = entry.getValue().getCompostBlock();
            List compostables = (List)compostEntries.get(compostBlock);
            if (compostables == null) {
                compostables = Lists.newArrayList();
                compostEntries.put(compostBlock, compostables);
            }
            Item compostItem = entry.getKey().getItem();
            int compostCount = (int)Math.ceil(1.0f / entry.getValue().getValue());
            int compostMeta = entry.getKey().getMeta();
            if (compostMeta == -1) {
                ArrayList subItems = Lists.newArrayList();
                compostItem.func_150895_a(compostItem, null, (List)subItems);
                for (ItemStack subItem : subItems) {
                    subItem.field_77994_a = compostCount;
                    compostables.add(subItem);
                }
                continue;
            }
            compostables.add(new ItemStack(compostItem, compostCount, compostMeta));
        }
        for (Map.Entry<ItemInfo, Compostable> entry : compostEntries.entrySet()) {
            ArrayList splitList = Lists.newArrayList((Iterable)ImmutableList.of((Object)Lists.newArrayList()));
            for (ItemStack stack : (List)((Object)entry.getValue())) {
                if (((List)splitList.get(0)).size() >= 45) {
                    splitList.add(0, Lists.newArrayList());
                }
                ((List)splitList.get(0)).add(stack);
            }
            for (List compostInputs : Lists.reverse((List)splitList)) {
                compostRecipes.add(new CompostRecipe(entry.getKey().getItemStack(), compostInputs));
            }
        }
        registry.addRecipes((List)compostRecipes);
        registry.addRecipeCategoryCraftingItem(new ItemStack((Block)ENBlocks.barrelWood), new String[]{"exnihiloadscensio:compost"});
        registry.addRecipeCategoryCraftingItem(new ItemStack((Block)ENBlocks.barrelStone), new String[]{"exnihiloadscensio:compost"});
        LogUtil.info("Hammer Recipes Loaded:             " + hammerRecipes.size());
        LogUtil.info("Sieve Recipes Loaded:              " + sieveRecipes.size());
        LogUtil.info("Fluid Transform Recipes Loaded:    " + arrayList.size());
        LogUtil.info("Fluid On Top Recipes Loaded:       " + arrayList2.size());
        LogUtil.info("Compost Recipes Loaded:            " + compostRecipes.size());
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
    }
}

