/*
 * Decompiled with CFR 0.152.
 */
package exnihiloadscensio.compatibility.jei.barrel.fluidblocktransform;

import com.google.common.collect.ImmutableList;
import exnihiloadscensio.registries.types.FluidBlockTransformer;
import exnihiloadscensio.util.Util;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class FluidBlockTransformRecipe
implements IRecipeWrapper {
    private FluidStack inputFluid;
    private ItemStack inputBucket;
    private ItemStack inputStack;
    private ItemStack outputStack;

    public FluidBlockTransformRecipe(FluidBlockTransformer recipe) {
        this.inputFluid = new FluidStack(FluidRegistry.getFluid((String)recipe.getFluidName()), 1000);
        this.inputBucket = Util.getBucketStack(this.inputFluid.getFluid());
        this.inputStack = recipe.getInput().getItemStack();
        this.outputStack = recipe.getOutput().getItemStack();
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputs(ItemStack.class, this.getInputs());
        ingredients.setInputs(FluidStack.class, this.getFluidInputs());
        ingredients.setOutput(ItemStack.class, (Object)this.outputStack);
    }

    public List<ItemStack> getInputs() {
        return ImmutableList.of((Object)this.inputBucket, (Object)this.inputStack);
    }

    public List<ItemStack> getOutputs() {
        return ImmutableList.of((Object)this.outputStack);
    }

    public List<FluidStack> getFluidInputs() {
        return ImmutableList.of((Object)this.inputFluid);
    }

    public List<FluidStack> getFluidOutputs() {
        return ImmutableList.of();
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
    }

    public void drawAnimations(Minecraft minecraft, int recipeWidth, int recipeHeight) {
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        return null;
    }

    public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        return false;
    }
}

