/*
 * Decompiled with CFR 0.152.
 */
package exnihiloadscensio.compatibility.jei.barrel.fluidtransform;

import com.google.common.collect.ImmutableList;
import exnihiloadscensio.blocks.ENBlocks;
import exnihiloadscensio.compatibility.jei.barrel.fluidtransform.FluidTransformRecipe;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class FluidTransformRecipeCategory
implements IRecipeCategory<FluidTransformRecipe> {
    public static final String UID = "exnihiloadscensio:fluid_transform";
    private static final ResourceLocation texture = new ResourceLocation("exnihiloadscensio", "textures/gui/jei_fluid_transform.png");
    private final IDrawableStatic background;
    private final IDrawableStatic slotHighlight;
    private boolean hasHighlight;
    private int highlightX;
    private int highlightY;

    public FluidTransformRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(texture, 0, 0, 166, 63);
        this.slotHighlight = helper.createDrawable(texture, 166, 0, 18, 18);
    }

    public String getUid() {
        return UID;
    }

    public String getTitle() {
        return "Fluid Transform";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(Minecraft minecraft) {
        if (this.hasHighlight) {
            this.slotHighlight.draw(minecraft, this.highlightX, this.highlightY);
        }
    }

    public void drawAnimations(Minecraft minecraft) {
    }

    public void setRecipe(IRecipeLayout recipeLayout, FluidTransformRecipe recipeWrapper) {
        recipeLayout.getItemStacks().init(0, true, 74, 9);
        recipeLayout.getItemStacks().init(1, true, 47, 9);
        recipeLayout.getItemStacks().init(2, true, 74, 36);
        recipeLayout.getItemStacks().init(3, false, 101, 9);
        boolean noCycle = false;
        ImmutableList focusStack = null;
        IFocus focus = recipeLayout.getFocus();
        if (focus.getMode() == IFocus.Mode.INPUT && focus.getValue() instanceof ItemStack) {
            ItemStack stack = (ItemStack)focus.getValue();
            for (ItemStack inputStack : recipeWrapper.getInputs().subList(1, recipeWrapper.getInputs().size())) {
                if (!stack.func_77969_a(inputStack)) continue;
                noCycle = true;
                focusStack = ImmutableList.of((Object)inputStack);
            }
        }
        recipeLayout.getItemStacks().set(0, new ItemStack((Block)ENBlocks.barrelStone, 1, 0));
        recipeLayout.getItemStacks().set(1, recipeWrapper.getInputs().get(0));
        recipeLayout.getItemStacks().set(2, noCycle ? focusStack : ImmutableList.copyOf(recipeWrapper.getInputs().subList(1, recipeWrapper.getInputs().size())));
        recipeLayout.getItemStacks().set(3, recipeWrapper.getOutputs().get(0));
    }

    public void setRecipe(IRecipeLayout recipeLayout, FluidTransformRecipe recipeWrapper, IIngredients ingredients) {
        this.setRecipe(recipeLayout, recipeWrapper);
    }

    public IDrawable getIcon() {
        return null;
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        return Collections.emptyList();
    }
}

