/*
 * Decompiled with CFR 0.152.
 */
package exnihiloadscensio.compatibility.jei.hammer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import exnihiloadscensio.compatibility.jei.hammer.HammerRecipe;
import exnihiloadscensio.registries.HammerRegistry;
import exnihiloadscensio.registries.HammerReward;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class HammerRecipeCategory
implements IRecipeCategory<HammerRecipe> {
    public static final String UID = "exnihiloadscensio:hammer";
    private static final ResourceLocation texture = new ResourceLocation("exnihiloadscensio", "textures/gui/jei_hammer.png");
    private final IDrawableStatic background;
    private final IDrawableStatic slotHighlight;
    private boolean hasHighlight;
    private int highlightX;
    private int highlightY;

    public HammerRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(texture, 0, 0, 166, 128);
        this.slotHighlight = helper.createDrawable(texture, 166, 0, 18, 18);
    }

    public String getUid() {
        return UID;
    }

    public String getTitle() {
        return "Hammer";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(Minecraft minecraft) {
        if (this.hasHighlight) {
            this.slotHighlight.draw(minecraft, this.highlightX, this.highlightY);
        }
    }

    public void drawAnimations(Minecraft minecraft) {
    }

    public void setRecipe(IRecipeLayout recipeLayout, HammerRecipe recipeWrapper) {
        recipeLayout.getItemStacks().init(0, true, 74, 9);
        recipeLayout.getItemStacks().set(0, recipeWrapper.getInputs().get(0));
        IFocus focus = recipeLayout.getFocus();
        this.hasHighlight = focus.getMode() == IFocus.Mode.OUTPUT;
        int slotIndex = 1;
        for (int i = 0; i < recipeWrapper.getOutputs().size(); ++i) {
            int slotX = 2 + i % 9 * 18;
            int slotY = 36 + i / 9 * 18;
            ItemStack outputStack = recipeWrapper.getOutputs().get(i);
            recipeLayout.getItemStacks().init(slotIndex + i, false, slotX, slotY);
            recipeLayout.getItemStacks().set(slotIndex + i, outputStack);
            ItemStack focusStack = (ItemStack)focus.getValue();
            if (focus.getMode() != IFocus.Mode.OUTPUT || focusStack == null || focusStack.func_77973_b() != outputStack.func_77973_b() || focusStack.func_77952_i() != outputStack.func_77952_i()) continue;
            this.highlightX = slotX;
            this.highlightY = slotY;
        }
        recipeLayout.getItemStacks().addTooltipCallback((ITooltipCallback)new HammerTooltipCallback(recipeWrapper));
    }

    public void setRecipe(IRecipeLayout recipeLayout, HammerRecipe recipeWrapper, IIngredients ingredients) {
        this.setRecipe(recipeLayout, recipeWrapper);
    }

    public IDrawable getIcon() {
        return null;
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        return Collections.emptyList();
    }

    private class HammerTooltipCallback
    implements ITooltipCallback<ItemStack> {
        private HammerRecipe recipe;

        private HammerTooltipCallback(HammerRecipe recipeWrapper) {
            this.recipe = recipeWrapper;
        }

        public void onTooltip(int slotIndex, boolean input, ItemStack ingredient, List<String> tooltip) {
            if (!input) {
                ItemStack blockStack = this.recipe.getInputs().get(0);
                Block blockBase = Block.func_149634_a((Item)blockStack.func_77973_b());
                IBlockState block = blockBase.func_176203_a(blockStack.func_77960_j());
                List<HammerReward> allRewards = HammerRegistry.getRewards(block);
                allRewards.removeIf(reward -> !reward.getStack().func_77973_b().equals(ingredient.func_77973_b()) || reward.getStack().func_77960_j() != ingredient.func_77960_j());
                HashMap tieredOutputs = Maps.newHashMap();
                for (HammerReward reward2 : allRewards) {
                    List stacks = (List)tieredOutputs.get(reward2.getMiningLevel());
                    if (stacks == null) {
                        stacks = Lists.newArrayList((Object[])new HammerReward[]{reward2});
                        tieredOutputs.put(reward2.getMiningLevel(), stacks);
                        continue;
                    }
                    stacks.add(reward2);
                }
                tieredOutputs.forEach((level, rewards) -> rewards.sort((rewardA, rewardB) -> Float.compare(rewardB.getChance(), rewardA.getChance())));
                ArrayList levelOrder = Lists.newArrayList(tieredOutputs.keySet());
                levelOrder.sort((levelA, levelB) -> Integer.compare(levelB, levelA));
                Iterator iterator = levelOrder.iterator();
                while (iterator.hasNext()) {
                    int level2 = (Integer)iterator.next();
                    tooltip.add(I18n.func_135052_a((String)("jei.hammer.hammerLevel." + level2), (Object[])new Object[0]));
                    List rewards2 = (List)tieredOutputs.get(level2);
                    for (HammerReward reward3 : rewards2) {
                        float chance = 100.0f * reward3.getChance();
                        String format = chance >= 10.0f ? " - %3.0f%% (x%d)" : "%1.1f%% - (x%d)";
                        tooltip.add(String.format(format, Float.valueOf(chance), reward3.getStack().field_77994_a));
                    }
                }
            }
        }
    }
}

