/*
 * Decompiled with CFR 0.152.
 */
package exnihiloadscensio.registries;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import exnihiloadscensio.json.CustomItemInfoJson;
import exnihiloadscensio.registries.manager.IFluidBlockDefaultRegistryProvider;
import exnihiloadscensio.registries.manager.RegistryManager;
import exnihiloadscensio.registries.types.FluidBlockTransformer;
import exnihiloadscensio.util.ItemInfo;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;

public class FluidBlockTransformerRegistry {
    private static ArrayList<FluidBlockTransformer> registry = new ArrayList();
    private static List<FluidBlockTransformer> externalRegistry = new ArrayList<FluidBlockTransformer>();
    private static Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(ItemInfo.class, (Object)new CustomItemInfoJson()).create();

    public static void register(Fluid fluid, ItemInfo inputBlock, ItemInfo outputBlock) {
        FluidBlockTransformerRegistry.registerInternal(fluid, inputBlock, outputBlock);
        externalRegistry.add(new FluidBlockTransformer(fluid.getName(), inputBlock, outputBlock));
    }

    private static void registerInternal(Fluid fluid, ItemInfo inputBlock, ItemInfo outputBlock) {
        registry.add(new FluidBlockTransformer(fluid.getName(), inputBlock, outputBlock));
    }

    private static void registerInternal(String fluid, ItemInfo inputBlock, ItemInfo outputBlock) {
        registry.add(new FluidBlockTransformer(fluid, inputBlock, outputBlock));
    }

    public static boolean canBlockBeTransformedWithThisFluid(Fluid fluid, ItemStack stack) {
        ItemInfo info = ItemInfo.getItemInfoFromStack(stack);
        for (FluidBlockTransformer transformer : registry) {
            if (!fluid.getName().equals(transformer.getFluidName()) || !info.equals(transformer.getInput())) continue;
            return true;
        }
        return false;
    }

    public static ItemInfo getBlockForTransformation(Fluid fluid, ItemStack stack) {
        ItemInfo info = ItemInfo.getItemInfoFromStack(stack);
        for (FluidBlockTransformer transformer : registry) {
            if (!fluid.getName().equals(transformer.getFluidName()) || !info.equals(transformer.getInput())) continue;
            return transformer.getOutput();
        }
        return null;
    }

    public static void loadJson(File file) {
        registry.clear();
        if (file.exists()) {
            try {
                FileReader fr = new FileReader(file);
                List gsonInput = (List)gson.fromJson((Reader)fr, new TypeToken<List<FluidBlockTransformer>>(){}.getType());
                registry.addAll(gsonInput);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            FluidBlockTransformerRegistry.registerDefaults();
            FluidBlockTransformerRegistry.saveJson(file);
        }
        registry.addAll(externalRegistry);
    }

    public static void saveJson(File file) {
        try {
            FileWriter fw = new FileWriter(file);
            gson.toJson(registry, (Appendable)fw);
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void registerDefaults() {
        for (IFluidBlockDefaultRegistryProvider provider : RegistryManager.getDefaultFluidBlockRecipeHandlers()) {
            provider.registerFluidBlockRecipeDefaults();
        }
    }

    public static ArrayList<FluidBlockTransformer> getRegistry() {
        return registry;
    }
}

