/*
 * Decompiled with CFR 0.152.
 */
package exnihiloadscensio.registries;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import exnihiloadscensio.json.CustomBlockInfoJson;
import exnihiloadscensio.registries.manager.IHeatDefaultRegistryProvider;
import exnihiloadscensio.registries.manager.RegistryManager;
import exnihiloadscensio.util.BlockInfo;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class HeatRegistry {
    private static Map<BlockInfo, Integer> registry = new HashMap<BlockInfo, Integer>();
    private static Map<BlockInfo, Integer> externalRegistry = new HashMap<BlockInfo, Integer>();
    private static Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(BlockInfo.class, (Object)new CustomBlockInfoJson()).create();

    public static void register(BlockInfo info, int heatAmount) {
        HeatRegistry.registerInternal(info, heatAmount);
        externalRegistry.put(info, heatAmount);
    }

    public static void register(ItemStack stack, int heatAmount) {
        HeatRegistry.register(new BlockInfo(stack), heatAmount);
    }

    public static void registerInternal(BlockInfo info, int heatAmount) {
        registry.put(info, heatAmount);
    }

    public static void registerInternal(ItemStack stack, int heatAmount) {
        HeatRegistry.register(new BlockInfo(stack), heatAmount);
    }

    public static void registerDefaults() {
        for (IHeatDefaultRegistryProvider provider : RegistryManager.getDefaultHeatRecipeHandlers()) {
            provider.registerHeatRecipeDefaults();
        }
    }

    public static int getHeatAmount(ItemStack stack) {
        return registry.get(new BlockInfo(stack));
    }

    public static int getHeatAmount(BlockInfo info) {
        if (registry.containsKey(info)) {
            return registry.get(info);
        }
        return 0;
    }

    public static void loadJson(File file) {
        registry.clear();
        if (file.exists()) {
            try {
                FileReader fr = new FileReader(file);
                HashMap gsonInput = (HashMap)gson.fromJson((Reader)fr, new TypeToken<HashMap<String, Integer>>(){}.getType());
                for (Map.Entry entry : gsonInput.entrySet()) {
                    registry.put(new BlockInfo((String)entry.getKey()), (Integer)entry.getValue());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            HeatRegistry.registerDefaults();
            HeatRegistry.saveJson(file);
        }
        registry.putAll(externalRegistry);
    }

    public static void saveJson(File file) {
        try {
            FileWriter fw = new FileWriter(file);
            gson.toJson(registry, (Appendable)fw);
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

