/*
 * Decompiled with CFR 0.152.
 */
package exnihiloadscensio.tiles;

import exnihiloadscensio.blocks.BlockInfestedLeaves;
import exnihiloadscensio.config.Config;
import exnihiloadscensio.texturing.Color;
import exnihiloadscensio.util.Util;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileInfestedLeaves
extends TileEntity
implements ITickable {
    private static int tileId = 0;
    private float progress = 0.0f;
    private boolean hasNearbyLeaves = true;
    private IBlockState leafBlock = Blocks.field_150362_t.func_176223_P();
    private int updateIndex = tileId++ % Config.leavesUpdateFrequency;

    public void func_73660_a() {
        if (this.progress < 1.0f) {
            this.progress = (float)((double)this.progress + 1.0 / (double)Config.infestedLeavesTicks);
            this.func_70296_d();
            if (this.progress > 1.0f) {
                this.progress = 1.0f;
                this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
            }
        }
        if (!this.field_145850_b.field_72995_K && this.hasNearbyLeaves || this.field_145850_b.func_82737_E() % (long)Config.leavesUpdateFrequency == (long)this.updateIndex) {
            this.hasNearbyLeaves = false;
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        BlockPos newPos = new BlockPos((Vec3i)this.field_174879_c.func_177982_a(x, y, z));
                        IBlockState state = this.field_145850_b.func_180495_p(newPos);
                        if (state == null || state.func_177230_c() == null || state.func_177230_c() != Blocks.field_150362_t && state.func_177230_c() != Blocks.field_150361_u) continue;
                        this.hasNearbyLeaves = true;
                        if (!((double)this.field_145850_b.field_73012_v.nextFloat() < Config.leavesSpreadChance)) continue;
                        BlockInfestedLeaves.infestLeafBlock(this.field_145850_b, newPos);
                    }
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 16384.0;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColor() {
        if (this.field_145850_b == null || this.field_174879_c == null) {
            return Util.whiteColor.toInt();
        }
        Color green = new Color(BiomeColorHelper.func_180287_b((IBlockAccess)this.field_145850_b, (BlockPos)this.field_174879_c));
        return Color.average(green, Util.whiteColor, (float)Math.pow(this.progress, 2.0)).toInt();
    }

    public void setProgress(float newProgress) {
        this.progress = newProgress;
        this.func_70296_d();
    }

    public void setLeafBlock(IBlockState block) {
        this.leafBlock = block;
        this.func_70296_d();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74776_a("progress", this.progress);
        tag.func_74778_a("leafBlock", this.leafBlock.func_177230_c().getRegistryName().toString());
        tag.func_74768_a("leafBlockMeta", this.leafBlock.func_177230_c().func_176201_c(this.leafBlock));
        return super.func_189515_b(tag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        this.progress = tag.func_74760_g("progress");
        this.leafBlock = tag.func_74764_b("leafBlock") && tag.func_74764_b("leafBlockMeta") ? Block.func_149684_b((String)tag.func_74779_i("leafBlock")).func_176203_a(tag.func_74762_e("leafBlockMeta")) : Blocks.field_150362_t.func_176223_P();
        super.func_145839_a(tag);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager networkManager, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public float getProgress() {
        return this.progress;
    }

    public boolean isHasNearbyLeaves() {
        return this.hasNearbyLeaves;
    }

    public IBlockState getLeafBlock() {
        return this.leafBlock;
    }
}

